/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.util.internal;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class MapUtils {
    private MapUtils() {
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, Supplier<V> valueCreator) {
        return MapUtils.getOrCreate(map, key, valueCreator, null);
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, Supplier<V> valueCreator, Consumer<V> initializer) {
        V value = map.get(key);
        if (value == null) {
            value = valueCreator.get();
            map.put(key, value);
            if (initializer != null) {
                initializer.accept(value);
            }
        }
        return value;
    }
}

