/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import spoon.SpoonException;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.support.visitor.AbstractTypingContext;
import spoon.support.visitor.ClassTypingContext;

public class MethodTypingContext
extends AbstractTypingContext {
    private CtFormalTypeDeclarer scopeMethod;
    private List<CtTypeReference<?>> actualTypeArguments;
    private ClassTypingContext classTypingContext;
    private Set<CtFormalTypeDeclarer> checkingFormalTypeParamsOf = Collections.newSetFromMap(new IdentityHashMap(1));

    @Override
    public CtFormalTypeDeclarer getAdaptationScope() {
        return this.scopeMethod;
    }

    public MethodTypingContext setMethod(CtMethod<?> method) {
        this.actualTypeArguments = ClassTypingContext.getTypeReferences(method.getFormalCtTypeParameters());
        if (this.classTypingContext != null) {
            CtType<?> declType = method.getDeclaringType();
            if (declType == null) {
                throw new SpoonException("Cannot use method without declaring type as scope of method typing context");
            }
            if (this.classTypingContext.getAdaptationScope() != declType) {
                if (!this.classTypingContext.isSubtypeOf((CtTypeReference<?>)declType.getReference())) {
                    throw new SpoonException("Cannot create MethodTypingContext for method declared in different ClassTypingContext");
                }
                Factory factory = method.getFactory();
                CtMethod adaptedMethod = factory.Core().createMethod();
                adaptedMethod.setParent(this.classTypingContext.getAdaptationScope());
                adaptedMethod.setModifiers(method.getModifiers());
                adaptedMethod.setSimpleName(method.getSimpleName());
                for (CtTypeParameter ctTypeParameter : method.getFormalCtTypeParameters()) {
                    CtTypeParameter newTypeParam = ctTypeParameter.clone();
                    newTypeParam.setSuperclass(this.adaptTypeForNewMethod(ctTypeParameter.getSuperclass()));
                    adaptedMethod.addFormalCtTypeParameter(newTypeParam);
                }
                this.scopeMethod = adaptedMethod;
                for (CtTypeReference ctTypeReference : method.getThrownTypes()) {
                    adaptedMethod.addThrownType(this.adaptType((CtTypeInformation)((Object)ctTypeReference.clone())));
                }
                adaptedMethod.setType(this.adaptType(method.getType()));
                ArrayList adaptedParams = new ArrayList(method.getParameters().size());
                for (CtParameter<?> parameter : method.getParameters()) {
                    adaptedParams.add(factory.Executable().createParameter(null, this.adaptType(parameter.getType()), parameter.getSimpleName()));
                }
                adaptedMethod.setParameters(adaptedParams);
                method = adaptedMethod;
            }
        }
        this.scopeMethod = method;
        return this;
    }

    public MethodTypingContext setConstructor(CtConstructor<?> constructor) {
        this.actualTypeArguments = ClassTypingContext.getTypeReferences(constructor.getFormalCtTypeParameters());
        this.checkSameTypingContext(this.classTypingContext, constructor);
        this.scopeMethod = constructor;
        return this;
    }

    @Override
    public ClassTypingContext getEnclosingGenericTypeAdapter() {
        if (this.classTypingContext == null && this.scopeMethod != null) {
            this.classTypingContext = new ClassTypingContext(this.getScopeMethodDeclaringType());
        }
        return this.classTypingContext;
    }

    public MethodTypingContext setClassTypingContext(ClassTypingContext classTypingContext) {
        this.checkSameTypingContext(classTypingContext, this.scopeMethod);
        this.classTypingContext = classTypingContext;
        return this;
    }

    public MethodTypingContext setInvocation(CtInvocation<?> invocation) {
        CtTypeReference targetTypeRef;
        Object target;
        if (this.classTypingContext == null && (target = invocation.getTarget()) != null && (targetTypeRef = target.getType()) != null) {
            this.classTypingContext = new ClassTypingContext(targetTypeRef);
        }
        this.setExecutableReference(invocation.getExecutable());
        return this;
    }

    public MethodTypingContext setExecutableReference(CtExecutableReference<?> execRef) {
        CtExecutable<?> exec;
        CtTypeReference<?> declaringTypeRef;
        if (this.classTypingContext == null && (declaringTypeRef = execRef.getDeclaringType()) != null) {
            this.classTypingContext = new ClassTypingContext(declaringTypeRef);
        }
        if ((exec = execRef.getExecutableDeclaration()) == null) {
            throw new SpoonException("Cannot create MethodTypingContext from CtExecutable of CtExecutableReference is null");
        }
        if (exec instanceof CtMethod) {
            this.setMethod((CtMethod)exec);
        } else if (exec instanceof CtConstructor) {
            this.setConstructor((CtConstructor)exec);
        } else {
            throw new SpoonException("Cannot create MethodTypingContext from " + exec.getClass().getName());
        }
        this.actualTypeArguments = execRef.getActualTypeArguments();
        return this;
    }

    @Override
    protected CtTypeReference<?> adaptTypeParameter(CtTypeParameter typeParam) {
        CtFormalTypeDeclarer typeParamDeclarer = typeParam.getTypeParameterDeclarer();
        if (typeParamDeclarer instanceof CtType) {
            return this.getEnclosingGenericTypeAdapter().adaptType(typeParam);
        }
        if (typeParamDeclarer instanceof CtMethod) {
            if (!(this.scopeMethod instanceof CtMethod)) {
                return null;
            }
        } else if (typeParamDeclarer instanceof CtConstructor) {
            if (!(this.scopeMethod instanceof CtConstructor)) {
                return null;
            }
        } else {
            throw new SpoonException("Unexpected type parameter declarer");
        }
        if (!this.hasSameMethodFormalTypeParameters(typeParamDeclarer)) {
            return null;
        }
        int typeParamPosition = typeParamDeclarer.getFormalCtTypeParameters().indexOf(typeParam);
        return this.actualTypeArguments.get(typeParamPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSameMethodFormalTypeParameters(CtFormalTypeDeclarer typeParamDeclarer) {
        List<CtTypeParameter> thisTypeParameters = this.scopeMethod.getFormalCtTypeParameters();
        List<CtTypeParameter> thatTypeParameters = typeParamDeclarer.getFormalCtTypeParameters();
        if (thisTypeParameters.size() != thatTypeParameters.size()) {
            return false;
        }
        if (this.checkingFormalTypeParamsOf.contains(typeParamDeclarer)) {
            return true;
        }
        try {
            this.checkingFormalTypeParamsOf.add(typeParamDeclarer);
            for (int i2 = 0; i2 < thisTypeParameters.size(); ++i2) {
                if (this.isSameMethodFormalTypeParameter(thisTypeParameters.get(i2), thatTypeParameters.get(i2))) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.checkingFormalTypeParamsOf.remove(typeParamDeclarer);
        }
        return true;
    }

    private boolean isSameMethodFormalTypeParameter(CtTypeParameter scopeParam, CtTypeParameter superParam) {
        CtTypeReference<?> scopeBound = MethodTypingContext.getBound(scopeParam);
        CtTypeReference<?> superBound = MethodTypingContext.getBound(superParam);
        if (scopeBound.getActualTypeArguments().size() != superBound.getActualTypeArguments().size()) {
            return false;
        }
        CtTypeReference superBoundAdapted = this.adaptType(superBound);
        if (superBoundAdapted == null) {
            return false;
        }
        return scopeBound.getQualifiedName().equals(superBoundAdapted.getQualifiedName());
    }

    private int getIndexOfTypeParam(CtFormalTypeDeclarer declarer, CtTypeReference<?> typeRef) {
        CtTypeParameter typeParam;
        if (typeRef instanceof CtTypeParameterReference && (typeParam = ((CtTypeParameterReference)typeRef).getDeclaration()) != null && declarer == typeParam.getTypeParameterDeclarer()) {
            return declarer.getFormalCtTypeParameters().indexOf(typeParam);
        }
        return -1;
    }

    private static CtTypeReference<?> getBound(CtTypeParameter typeParam) {
        CtTypeReference<Object> bound = typeParam.getSuperclass();
        if (bound == null) {
            bound = typeParam.getFactory().Type().OBJECT;
        }
        return bound;
    }

    private CtType<?> getScopeMethodDeclaringType() {
        if (this.scopeMethod != null) {
            return this.scopeMethod.getDeclaringType();
        }
        throw new SpoonException("scopeMethod is not assigned");
    }

    private CtTypeReference<?> adaptTypeForNewMethod(CtTypeReference<?> typeRef) {
        if (typeRef == null) {
            return null;
        }
        if (typeRef instanceof CtTypeParameterReference) {
            CtTypeParameterReference typeParamRef = (CtTypeParameterReference)typeRef;
            CtTypeParameter typeParam = typeParamRef.getDeclaration();
            if (typeParam == null) {
                throw new SpoonException("Declaration of the CtTypeParameter should not be null.");
            }
            if (typeParam.getTypeParameterDeclarer() instanceof CtExecutable) {
                return typeRef.clone();
            }
        }
        return this.classTypingContext.adaptType(typeRef);
    }

    private void checkSameTypingContext(ClassTypingContext ctc, CtFormalTypeDeclarer executable) {
        if (ctc != null && executable != null) {
            CtType<?> scope = executable.getDeclaringType();
            if (scope == null) {
                throw new SpoonException("Cannot use executable without declaring type as scope of method typing context");
            }
            if (scope != ctc.getAdaptationScope()) {
                throw new SpoonException("Declaring type of executable is not same like scope of classTypingContext provided for method typing context");
            }
        }
    }
}

