/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.java.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import spoon.SpoonException;

public class RtMethod {
    private final Class<?> clazz;
    private final Method method;
    private final String name;
    private final Class<?> returnType;
    private final Type genericReturnType;
    private final TypeVariable<Method>[] typeParameters;
    private final Class<?>[] parameterTypes;
    private final Type[] genericParameterTypes;
    private final Class<?>[] exceptionTypes;
    private final int modifiers;
    private final Annotation[] annotations;
    private final Annotation[][] parameterAnnotations;
    private final boolean isVarArgs;
    private final boolean isDefault;
    private static Method _method_isDefault;

    public RtMethod(Class<?> clazz, Method method, String name, Class<?> returnType, Type genericReturnType, TypeVariable<Method>[] typeParameters, Class<?>[] parameterTypes, Type[] genericParameterTypes, Class<?>[] exceptionTypes, int modifiers, Annotation[] annotations, Annotation[][] parameterAnnotations, boolean isVarArgs, boolean isDefault) {
        this.clazz = clazz;
        this.method = method;
        this.name = name;
        this.returnType = returnType;
        this.genericReturnType = genericReturnType;
        this.typeParameters = typeParameters;
        this.parameterTypes = parameterTypes;
        this.genericParameterTypes = genericParameterTypes;
        this.exceptionTypes = exceptionTypes;
        this.modifiers = modifiers;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.isVarArgs = isVarArgs;
        this.isDefault = isDefault;
    }

    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        return this.typeParameters;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.annotations;
    }

    public Annotation[][] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Type getGenericReturnType() {
        return this.genericReturnType;
    }

    public Type[] getGenericParameterTypes() {
        return this.genericParameterTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtMethod rtMethod = (RtMethod)o;
        if (!Objects.equals(this.name, rtMethod.name)) {
            return false;
        }
        if (!Objects.equals(this.returnType, rtMethod.returnType)) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, rtMethod.parameterTypes)) {
            return false;
        }
        return Arrays.equals(this.exceptionTypes, rtMethod.exceptionTypes);
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public static RtMethod create(Method method) {
        return new RtMethod(method.getDeclaringClass(), method, method.getName(), method.getReturnType(), method.getGenericReturnType(), method.getTypeParameters(), method.getParameterTypes(), method.getGenericParameterTypes(), method.getExceptionTypes(), method.getModifiers(), method.getDeclaredAnnotations(), method.getParameterAnnotations(), method.isVarArgs(), RtMethod._java8_isDefault(method));
    }

    private static boolean _java8_isDefault(Method method) {
        if (_method_isDefault == null) {
            return false;
        }
        try {
            return (Boolean)_method_isDefault.invoke((Object)method, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new SpoonException("Calling of Java8 Method#isDefault() failed", e);
        }
        catch (InvocationTargetException e) {
            throw new SpoonException("Calling of Java8 Method#isDefault() failed", e.getTargetException());
        }
    }

    public static <T> RtMethod[] methodsOf(Class<T> clazz) {
        RtMethod[] methods = new RtMethod[clazz.getDeclaredMethods().length];
        int i2 = 0;
        for (Method method : clazz.getDeclaredMethods()) {
            methods[i2++] = RtMethod.create(method);
        }
        return methods;
    }

    public static <T> RtMethod[] sameMethodsWithDifferentTypeOf(Class<T> klass, List<RtMethod> comparedMethods) {
        ArrayList<RtMethod> methods = new ArrayList<RtMethod>();
        for (Method method : klass.getDeclaredMethods()) {
            RtMethod rtMethod = RtMethod.create(method);
            for (RtMethod potential : comparedMethods) {
                if (!potential.isLightEquals(rtMethod) || rtMethod.returnType.equals(potential.returnType)) continue;
                methods.add(rtMethod);
            }
        }
        return methods.toArray(new RtMethod[0]);
    }

    private boolean isLightEquals(RtMethod rtMethod) {
        if (this == rtMethod) {
            return true;
        }
        if (rtMethod == null || this.getClass() != rtMethod.getClass()) {
            return false;
        }
        if (!Objects.equals(this.name, rtMethod.name)) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, rtMethod.parameterTypes);
    }

    static {
        try {
            _method_isDefault = Method.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            _method_isDefault = null;
        }
    }
}

