/*
 * Decompiled with CFR 0.152.
 */
package spoon.support.visitor.replace;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.reflect.code.CtAbstractInvocation;
import spoon.reflect.code.CtAbstractSwitch;
import spoon.reflect.code.CtAnnotationFieldAccess;
import spoon.reflect.code.CtArrayAccess;
import spoon.reflect.code.CtArrayRead;
import spoon.reflect.code.CtArrayWrite;
import spoon.reflect.code.CtAssert;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBinaryOperator;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtBodyHolder;
import spoon.reflect.code.CtBreak;
import spoon.reflect.code.CtCase;
import spoon.reflect.code.CtCatch;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtCodeSnippetExpression;
import spoon.reflect.code.CtCodeSnippetStatement;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConditional;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtContinue;
import spoon.reflect.code.CtDo;
import spoon.reflect.code.CtExecutableReferenceExpression;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtFor;
import spoon.reflect.code.CtForEach;
import spoon.reflect.code.CtIf;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtJavaDoc;
import spoon.reflect.code.CtJavaDocTag;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.code.CtLocalVariable;
import spoon.reflect.code.CtNewArray;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.code.CtOperatorAssignment;
import spoon.reflect.code.CtRHSReceiver;
import spoon.reflect.code.CtReturn;
import spoon.reflect.code.CtStatement;
import spoon.reflect.code.CtStatementList;
import spoon.reflect.code.CtSuperAccess;
import spoon.reflect.code.CtSwitch;
import spoon.reflect.code.CtSwitchExpression;
import spoon.reflect.code.CtSynchronized;
import spoon.reflect.code.CtTargetedExpression;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtThrow;
import spoon.reflect.code.CtTry;
import spoon.reflect.code.CtTryWithResource;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.code.CtUnaryOperator;
import spoon.reflect.code.CtVariableAccess;
import spoon.reflect.code.CtVariableRead;
import spoon.reflect.code.CtVariableWrite;
import spoon.reflect.code.CtWhile;
import spoon.reflect.code.CtYieldStatement;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtAnnotationMethod;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtAnonymousExecutable;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtCompilationUnit;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtEnumValue;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtFormalTypeDeclarer;
import spoon.reflect.declaration.CtImport;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtModule;
import spoon.reflect.declaration.CtModuleRequirement;
import spoon.reflect.declaration.CtMultiTypedElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtPackageDeclaration;
import spoon.reflect.declaration.CtPackageExport;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtProvidedService;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.CtUsedService;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.reference.CtActualTypeContainer;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtCatchVariableReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtLocalVariableReference;
import spoon.reflect.reference.CtModuleReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtParameterReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeMemberWildcardImportReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtUnboundVariableReference;
import spoon.reflect.reference.CtVariableReference;
import spoon.reflect.reference.CtWildcardReference;
import spoon.reflect.visitor.CtScanner;
import spoon.support.visitor.replace.InvalidReplaceException;
import spoon.support.visitor.replace.ReplaceListListener;
import spoon.support.visitor.replace.ReplaceListener;
import spoon.support.visitor.replace.ReplaceMapListener;
import spoon.support.visitor.replace.ReplaceSetListener;

public class ReplacementVisitor
extends CtScanner {
    private CtElement original;
    private CtElement[] replace;
    private static final CtElement[] EMPTY = new CtElement[0];

    public static void replace(CtElement original, CtElement replace) {
        CtElement[] ctElementArray;
        if (replace == null) {
            ctElementArray = EMPTY;
        } else {
            CtElement[] ctElementArray2 = new CtElement[1];
            ctElementArray = ctElementArray2;
            ctElementArray2[0] = replace;
        }
        new ReplacementVisitor(original, ctElementArray).scan(original.getParent());
    }

    public static <E extends CtElement> void replace(CtElement original, Collection<E> replaces) {
        new ReplacementVisitor(original, replaces.toArray(new CtElement[replaces.size()])).scan(original.getParent());
    }

    private ReplacementVisitor(CtElement original, CtElement ... replace) {
        this.original = original;
        this.replace = replace == null ? EMPTY : replace;
    }

    private <K, V extends CtElement> void replaceInMapIfExist(Map<K, V> mapProtected, ReplaceMapListener listener) {
        HashMap<K, CtElement> map = new HashMap<K, CtElement>(mapProtected);
        CtElement shouldBeDeleted = null;
        Object key = null;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() != this.original) continue;
            shouldBeDeleted = (CtElement)entry.getValue();
            key = entry.getKey();
            break;
        }
        if (shouldBeDeleted != null) {
            if (this.replace.length > 0) {
                if (this.replace.length > 1) {
                    throw new InvalidReplaceException("Cannot replace single value by multiple values in " + listener.getClass().getSimpleName());
                }
                CtElement val = this.replace[0];
                if (val != null) {
                    map.put(key, val);
                    val.setParent(shouldBeDeleted.getParent());
                } else {
                    map.remove(key);
                }
            } else {
                map.remove(key);
            }
            listener.set(map);
        }
    }

    private <T extends CtElement> void replaceInSetIfExist(Set<T> setProtected, ReplaceSetListener listener) {
        HashSet<T> set = new HashSet<T>(setProtected);
        CtElement shouldBeDeleted = null;
        for (CtElement element : set) {
            if (element != this.original) continue;
            shouldBeDeleted = element;
            break;
        }
        if (shouldBeDeleted != null) {
            set.remove(shouldBeDeleted);
            for (CtElement ele : this.replace) {
                if (ele == null) continue;
                set.add(ele);
                ele.setParent(shouldBeDeleted.getParent());
            }
            listener.set(set);
        }
    }

    private <T extends CtElement> void replaceInListIfExist(List<T> listProtected, ReplaceListListener listener) {
        ArrayList<T> list = new ArrayList<T>(listProtected);
        CtElement shouldBeDeleted = null;
        int index = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) != this.original) continue;
            index = i2;
            shouldBeDeleted = (CtElement)list.get(i2);
            break;
        }
        if (shouldBeDeleted != null) {
            list.remove(index);
            if (this.replace.length > 0) {
                for (CtElement aReplace : this.replace) {
                    CtElement ele = aReplace;
                    if (ele == null) continue;
                    list.add(index, ele);
                    ele.setParent(shouldBeDeleted.getParent());
                    ++index;
                }
            }
            listener.set(list);
        }
    }

    private void replaceElementIfExist(CtElement candidate, ReplaceListener listener) {
        if (candidate == this.original) {
            CtElement val = null;
            if (this.replace.length > 0) {
                if (this.replace.length > 1) {
                    throw new InvalidReplaceException("Cannot replace single value by multiple values in " + listener.getClass().getSimpleName());
                }
                val = this.replace[0];
            }
            if (val != null) {
                val.setParent(candidate.getParent());
            }
            listener.set(val);
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotation(CtAnnotation<A> annotation) {
        this.replaceElementIfExist(annotation.getType(), new CtTypedElementTypeReplaceListener(annotation));
        this.replaceInListIfExist(annotation.getComments(), new CtElementCommentsReplaceListener(annotation));
        this.replaceElementIfExist(annotation.getAnnotationType(), new CtAnnotationAnnotationTypeReplaceListener(annotation));
        this.replaceInListIfExist(annotation.getAnnotations(), new CtElementAnnotationsReplaceListener(annotation));
        this.replaceInMapIfExist(annotation.getValues(), new CtAnnotationValuesReplaceListener(annotation));
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.replaceInListIfExist(annotationType.getAnnotations(), new CtElementAnnotationsReplaceListener(annotationType));
        this.replaceInListIfExist(annotationType.getTypeMembers(), new CtTypeTypeMembersReplaceListener(annotationType));
        this.replaceInListIfExist(annotationType.getComments(), new CtElementCommentsReplaceListener(annotationType));
    }

    @Override
    public void visitCtAnonymousExecutable(CtAnonymousExecutable anonymousExec) {
        this.replaceInListIfExist(anonymousExec.getAnnotations(), new CtElementAnnotationsReplaceListener(anonymousExec));
        this.replaceElementIfExist(anonymousExec.getBody(), new CtExecutableBodyReplaceListener(anonymousExec));
        this.replaceInListIfExist(anonymousExec.getComments(), new CtElementCommentsReplaceListener(anonymousExec));
    }

    @Override
    public <T> void visitCtArrayRead(CtArrayRead<T> arrayRead) {
        this.replaceInListIfExist(arrayRead.getAnnotations(), new CtElementAnnotationsReplaceListener(arrayRead));
        this.replaceElementIfExist(arrayRead.getType(), new CtTypedElementTypeReplaceListener(arrayRead));
        this.replaceInListIfExist(arrayRead.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(arrayRead));
        this.replaceElementIfExist((CtElement)arrayRead.getTarget(), new CtTargetedExpressionTargetReplaceListener(arrayRead));
        this.replaceElementIfExist(arrayRead.getIndexExpression(), new CtArrayAccessIndexExpressionReplaceListener(arrayRead));
        this.replaceInListIfExist(arrayRead.getComments(), new CtElementCommentsReplaceListener(arrayRead));
    }

    @Override
    public <T> void visitCtArrayWrite(CtArrayWrite<T> arrayWrite) {
        this.replaceInListIfExist(arrayWrite.getAnnotations(), new CtElementAnnotationsReplaceListener(arrayWrite));
        this.replaceElementIfExist(arrayWrite.getType(), new CtTypedElementTypeReplaceListener(arrayWrite));
        this.replaceInListIfExist(arrayWrite.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(arrayWrite));
        this.replaceElementIfExist((CtElement)arrayWrite.getTarget(), new CtTargetedExpressionTargetReplaceListener(arrayWrite));
        this.replaceElementIfExist(arrayWrite.getIndexExpression(), new CtArrayAccessIndexExpressionReplaceListener(arrayWrite));
        this.replaceInListIfExist(arrayWrite.getComments(), new CtElementCommentsReplaceListener(arrayWrite));
    }

    @Override
    public <T> void visitCtArrayTypeReference(CtArrayTypeReference<T> reference) {
        this.replaceElementIfExist(reference.getPackage(), new CtTypeReferencePackageReplaceListener(reference));
        this.replaceElementIfExist(reference.getDeclaringType(), new CtTypeReferenceDeclaringTypeReplaceListener(reference));
        this.replaceElementIfExist(reference.getComponentType(), new CtArrayTypeReferenceComponentTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getActualTypeArguments(), new CtActualTypeContainerActualTypeArgumentsReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtAssert(CtAssert<T> asserted) {
        this.replaceInListIfExist(asserted.getAnnotations(), new CtElementAnnotationsReplaceListener(asserted));
        this.replaceElementIfExist(asserted.getAssertExpression(), new CtAssertAssertExpressionReplaceListener(asserted));
        this.replaceElementIfExist(asserted.getExpression(), new CtAssertExpressionReplaceListener(asserted));
        this.replaceInListIfExist(asserted.getComments(), new CtElementCommentsReplaceListener(asserted));
    }

    @Override
    public <T, A extends T> void visitCtAssignment(CtAssignment<T, A> assignement) {
        this.replaceInListIfExist(assignement.getAnnotations(), new CtElementAnnotationsReplaceListener(assignement));
        this.replaceElementIfExist(assignement.getType(), new CtTypedElementTypeReplaceListener(assignement));
        this.replaceInListIfExist(assignement.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(assignement));
        this.replaceElementIfExist(assignement.getAssigned(), new CtAssignmentAssignedReplaceListener(assignement));
        this.replaceElementIfExist(assignement.getAssignment(), new CtRHSReceiverAssignmentReplaceListener(assignement));
        this.replaceInListIfExist(assignement.getComments(), new CtElementCommentsReplaceListener(assignement));
    }

    @Override
    public <T> void visitCtBinaryOperator(CtBinaryOperator<T> operator) {
        this.replaceInListIfExist(operator.getAnnotations(), new CtElementAnnotationsReplaceListener(operator));
        this.replaceElementIfExist(operator.getType(), new CtTypedElementTypeReplaceListener(operator));
        this.replaceInListIfExist(operator.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(operator));
        this.replaceElementIfExist(operator.getLeftHandOperand(), new CtBinaryOperatorLeftHandOperandReplaceListener(operator));
        this.replaceElementIfExist(operator.getRightHandOperand(), new CtBinaryOperatorRightHandOperandReplaceListener(operator));
        this.replaceInListIfExist(operator.getComments(), new CtElementCommentsReplaceListener(operator));
    }

    @Override
    public <R> void visitCtBlock(CtBlock<R> block) {
        this.replaceInListIfExist(block.getAnnotations(), new CtElementAnnotationsReplaceListener(block));
        this.replaceInListIfExist(block.getStatements(), new CtStatementListStatementsReplaceListener(block));
        this.replaceInListIfExist(block.getComments(), new CtElementCommentsReplaceListener(block));
    }

    @Override
    public void visitCtBreak(CtBreak breakStatement) {
        this.replaceInListIfExist(breakStatement.getAnnotations(), new CtElementAnnotationsReplaceListener(breakStatement));
        this.replaceInListIfExist(breakStatement.getComments(), new CtElementCommentsReplaceListener(breakStatement));
    }

    @Override
    public <S> void visitCtCase(CtCase<S> caseStatement) {
        this.replaceInListIfExist(caseStatement.getAnnotations(), new CtElementAnnotationsReplaceListener(caseStatement));
        this.replaceInListIfExist(caseStatement.getCaseExpressions(), new CtCaseCaseExpressionsReplaceListener(caseStatement));
        this.replaceInListIfExist(caseStatement.getStatements(), new CtStatementListStatementsReplaceListener(caseStatement));
        this.replaceInListIfExist(caseStatement.getComments(), new CtElementCommentsReplaceListener(caseStatement));
    }

    @Override
    public void visitCtCatch(CtCatch catchBlock) {
        this.replaceInListIfExist(catchBlock.getAnnotations(), new CtElementAnnotationsReplaceListener(catchBlock));
        this.replaceElementIfExist(catchBlock.getParameter(), new CtCatchParameterReplaceListener(catchBlock));
        this.replaceElementIfExist(catchBlock.getBody(), new CtCatchBodyReplaceListener(catchBlock));
        this.replaceInListIfExist(catchBlock.getComments(), new CtElementCommentsReplaceListener(catchBlock));
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.replaceInListIfExist(ctClass.getAnnotations(), new CtElementAnnotationsReplaceListener(ctClass));
        this.replaceElementIfExist(ctClass.getSuperclass(), new CtTypeInformationSuperclassReplaceListener(ctClass));
        this.replaceInSetIfExist(ctClass.getSuperInterfaces(), new CtTypeInformationSuperInterfacesReplaceListener(ctClass));
        this.replaceInListIfExist(ctClass.getFormalCtTypeParameters(), new CtFormalTypeDeclarerFormalCtTypeParametersReplaceListener(ctClass));
        this.replaceInListIfExist(ctClass.getTypeMembers(), new CtTypeTypeMembersReplaceListener(ctClass));
        this.replaceInListIfExist(ctClass.getComments(), new CtElementCommentsReplaceListener(ctClass));
    }

    @Override
    public void visitCtTypeParameter(CtTypeParameter typeParameter) {
        this.replaceInListIfExist(typeParameter.getAnnotations(), new CtElementAnnotationsReplaceListener(typeParameter));
        this.replaceElementIfExist(typeParameter.getSuperclass(), new CtTypeInformationSuperclassReplaceListener(typeParameter));
        this.replaceInListIfExist(typeParameter.getComments(), new CtElementCommentsReplaceListener(typeParameter));
    }

    @Override
    public <T> void visitCtConditional(CtConditional<T> conditional) {
        this.replaceElementIfExist(conditional.getType(), new CtTypedElementTypeReplaceListener(conditional));
        this.replaceInListIfExist(conditional.getAnnotations(), new CtElementAnnotationsReplaceListener(conditional));
        this.replaceElementIfExist(conditional.getCondition(), new CtConditionalConditionReplaceListener(conditional));
        this.replaceElementIfExist(conditional.getThenExpression(), new CtConditionalThenExpressionReplaceListener(conditional));
        this.replaceElementIfExist(conditional.getElseExpression(), new CtConditionalElseExpressionReplaceListener(conditional));
        this.replaceInListIfExist(conditional.getComments(), new CtElementCommentsReplaceListener(conditional));
        this.replaceInListIfExist(conditional.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(conditional));
    }

    @Override
    public <T> void visitCtConstructor(CtConstructor<T> c) {
        this.replaceInListIfExist(c.getAnnotations(), new CtElementAnnotationsReplaceListener(c));
        this.replaceInListIfExist(c.getParameters(), new CtExecutableParametersReplaceListener(c));
        this.replaceInSetIfExist(c.getThrownTypes(), new CtExecutableThrownTypesReplaceListener(c));
        this.replaceInListIfExist(c.getFormalCtTypeParameters(), new CtFormalTypeDeclarerFormalCtTypeParametersReplaceListener(c));
        this.replaceElementIfExist(c.getBody(), new CtExecutableBodyReplaceListener(c));
        this.replaceInListIfExist(c.getComments(), new CtElementCommentsReplaceListener(c));
    }

    @Override
    public void visitCtContinue(CtContinue continueStatement) {
        this.replaceInListIfExist(continueStatement.getAnnotations(), new CtElementAnnotationsReplaceListener(continueStatement));
        this.replaceInListIfExist(continueStatement.getComments(), new CtElementCommentsReplaceListener(continueStatement));
    }

    @Override
    public void visitCtDo(CtDo doLoop) {
        this.replaceInListIfExist(doLoop.getAnnotations(), new CtElementAnnotationsReplaceListener(doLoop));
        this.replaceElementIfExist(doLoop.getLoopingExpression(), new CtDoLoopingExpressionReplaceListener(doLoop));
        this.replaceElementIfExist(doLoop.getBody(), new CtLoopBodyReplaceListener(doLoop));
        this.replaceInListIfExist(doLoop.getComments(), new CtElementCommentsReplaceListener(doLoop));
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.replaceInListIfExist(ctEnum.getAnnotations(), new CtElementAnnotationsReplaceListener(ctEnum));
        this.replaceInSetIfExist(ctEnum.getSuperInterfaces(), new CtTypeInformationSuperInterfacesReplaceListener(ctEnum));
        this.replaceInListIfExist(ctEnum.getTypeMembers(), new CtTypeTypeMembersReplaceListener(ctEnum));
        this.replaceInListIfExist(ctEnum.getEnumValues(), new CtEnumEnumValuesReplaceListener(ctEnum));
        this.replaceInListIfExist(ctEnum.getComments(), new CtElementCommentsReplaceListener(ctEnum));
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.replaceElementIfExist(reference.getDeclaringType(), new CtExecutableReferenceDeclaringTypeReplaceListener(reference));
        this.replaceElementIfExist(reference.getType(), new CtExecutableReferenceTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getParameters(), new CtExecutableReferenceParametersReplaceListener(reference));
        this.replaceInListIfExist(reference.getActualTypeArguments(), new CtActualTypeContainerActualTypeArgumentsReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
        this.replaceInListIfExist(reference.getComments(), new CtElementCommentsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtField(CtField<T> f) {
        this.replaceInListIfExist(f.getAnnotations(), new CtElementAnnotationsReplaceListener(f));
        this.replaceElementIfExist(f.getType(), new CtTypedElementTypeReplaceListener(f));
        this.replaceElementIfExist(f.getDefaultExpression(), new CtVariableDefaultExpressionReplaceListener(f));
        this.replaceInListIfExist(f.getComments(), new CtElementCommentsReplaceListener(f));
    }

    @Override
    public <T> void visitCtEnumValue(CtEnumValue<T> enumValue) {
        this.replaceInListIfExist(enumValue.getAnnotations(), new CtElementAnnotationsReplaceListener(enumValue));
        this.replaceElementIfExist(enumValue.getType(), new CtTypedElementTypeReplaceListener(enumValue));
        this.replaceElementIfExist(enumValue.getDefaultExpression(), new CtVariableDefaultExpressionReplaceListener(enumValue));
        this.replaceInListIfExist(enumValue.getComments(), new CtElementCommentsReplaceListener(enumValue));
    }

    @Override
    public <T> void visitCtThisAccess(CtThisAccess<T> thisAccess) {
        this.replaceInListIfExist(thisAccess.getComments(), new CtElementCommentsReplaceListener(thisAccess));
        this.replaceInListIfExist(thisAccess.getAnnotations(), new CtElementAnnotationsReplaceListener(thisAccess));
        this.replaceElementIfExist(thisAccess.getType(), new CtTypedElementTypeReplaceListener(thisAccess));
        this.replaceInListIfExist(thisAccess.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(thisAccess));
        this.replaceElementIfExist((CtElement)thisAccess.getTarget(), new CtTargetedExpressionTargetReplaceListener(thisAccess));
    }

    @Override
    public <T> void visitCtAnnotationFieldAccess(CtAnnotationFieldAccess<T> annotationFieldAccess) {
        this.replaceInListIfExist(annotationFieldAccess.getComments(), new CtElementCommentsReplaceListener(annotationFieldAccess));
        this.replaceInListIfExist(annotationFieldAccess.getAnnotations(), new CtElementAnnotationsReplaceListener(annotationFieldAccess));
        this.replaceInListIfExist(annotationFieldAccess.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(annotationFieldAccess));
        this.replaceElementIfExist((CtElement)annotationFieldAccess.getTarget(), new CtTargetedExpressionTargetReplaceListener(annotationFieldAccess));
        this.replaceElementIfExist(annotationFieldAccess.getVariable(), new CtAnnotationFieldAccessVariableReplaceListener(annotationFieldAccess));
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.replaceElementIfExist(reference.getDeclaringType(), new CtFieldReferenceDeclaringTypeReplaceListener(reference));
        this.replaceElementIfExist(reference.getType(), new CtVariableReferenceTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
    }

    @Override
    public void visitCtFor(CtFor forLoop) {
        this.replaceInListIfExist(forLoop.getAnnotations(), new CtElementAnnotationsReplaceListener(forLoop));
        this.replaceInListIfExist(forLoop.getForInit(), new CtForForInitReplaceListener(forLoop));
        this.replaceElementIfExist(forLoop.getExpression(), new CtForExpressionReplaceListener(forLoop));
        this.replaceInListIfExist(forLoop.getForUpdate(), new CtForForUpdateReplaceListener(forLoop));
        this.replaceElementIfExist(forLoop.getBody(), new CtLoopBodyReplaceListener(forLoop));
        this.replaceInListIfExist(forLoop.getComments(), new CtElementCommentsReplaceListener(forLoop));
    }

    @Override
    public void visitCtForEach(CtForEach foreach) {
        this.replaceInListIfExist(foreach.getAnnotations(), new CtElementAnnotationsReplaceListener(foreach));
        this.replaceElementIfExist(foreach.getVariable(), new CtForEachVariableReplaceListener(foreach));
        this.replaceElementIfExist(foreach.getExpression(), new CtForEachExpressionReplaceListener(foreach));
        this.replaceElementIfExist(foreach.getBody(), new CtLoopBodyReplaceListener(foreach));
        this.replaceInListIfExist(foreach.getComments(), new CtElementCommentsReplaceListener(foreach));
    }

    @Override
    public void visitCtIf(CtIf ifElement) {
        this.replaceInListIfExist(ifElement.getAnnotations(), new CtElementAnnotationsReplaceListener(ifElement));
        this.replaceElementIfExist(ifElement.getCondition(), new CtIfConditionReplaceListener(ifElement));
        this.replaceElementIfExist((CtElement)ifElement.getThenStatement(), new CtIfThenStatementReplaceListener(ifElement));
        this.replaceElementIfExist((CtElement)ifElement.getElseStatement(), new CtIfElseStatementReplaceListener(ifElement));
        this.replaceInListIfExist(ifElement.getComments(), new CtElementCommentsReplaceListener(ifElement));
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.replaceInListIfExist(intrface.getAnnotations(), new CtElementAnnotationsReplaceListener(intrface));
        this.replaceInSetIfExist(intrface.getSuperInterfaces(), new CtTypeInformationSuperInterfacesReplaceListener(intrface));
        this.replaceInListIfExist(intrface.getFormalCtTypeParameters(), new CtFormalTypeDeclarerFormalCtTypeParametersReplaceListener(intrface));
        this.replaceInListIfExist(intrface.getTypeMembers(), new CtTypeTypeMembersReplaceListener(intrface));
        this.replaceInListIfExist(intrface.getComments(), new CtElementCommentsReplaceListener(intrface));
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.replaceInListIfExist(invocation.getAnnotations(), new CtElementAnnotationsReplaceListener(invocation));
        this.replaceInListIfExist(invocation.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(invocation));
        this.replaceElementIfExist((CtElement)invocation.getTarget(), new CtTargetedExpressionTargetReplaceListener(invocation));
        this.replaceElementIfExist(invocation.getExecutable(), new CtAbstractInvocationExecutableReplaceListener(invocation));
        this.replaceInListIfExist(invocation.getArguments(), new CtAbstractInvocationArgumentsReplaceListener(invocation));
        this.replaceInListIfExist(invocation.getComments(), new CtElementCommentsReplaceListener(invocation));
    }

    @Override
    public <T> void visitCtLiteral(CtLiteral<T> literal) {
        this.replaceInListIfExist(literal.getAnnotations(), new CtElementAnnotationsReplaceListener(literal));
        this.replaceElementIfExist(literal.getType(), new CtTypedElementTypeReplaceListener(literal));
        this.replaceInListIfExist(literal.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(literal));
        this.replaceInListIfExist(literal.getComments(), new CtElementCommentsReplaceListener(literal));
    }

    @Override
    public <T> void visitCtLocalVariable(CtLocalVariable<T> localVariable) {
        this.replaceInListIfExist(localVariable.getAnnotations(), new CtElementAnnotationsReplaceListener(localVariable));
        this.replaceElementIfExist(localVariable.getType(), new CtTypedElementTypeReplaceListener(localVariable));
        this.replaceElementIfExist(localVariable.getDefaultExpression(), new CtVariableDefaultExpressionReplaceListener(localVariable));
        this.replaceInListIfExist(localVariable.getComments(), new CtElementCommentsReplaceListener(localVariable));
    }

    @Override
    public <T> void visitCtLocalVariableReference(CtLocalVariableReference<T> reference) {
        this.replaceElementIfExist(reference.getType(), new CtVariableReferenceTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        this.replaceInListIfExist(catchVariable.getComments(), new CtElementCommentsReplaceListener(catchVariable));
        this.replaceInListIfExist(catchVariable.getAnnotations(), new CtElementAnnotationsReplaceListener(catchVariable));
        this.replaceInListIfExist(catchVariable.getMultiTypes(), new CtMultiTypedElementMultiTypesReplaceListener(catchVariable));
    }

    @Override
    public <T> void visitCtCatchVariableReference(CtCatchVariableReference<T> reference) {
        this.replaceElementIfExist(reference.getType(), new CtVariableReferenceTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> m) {
        this.replaceInListIfExist(m.getAnnotations(), new CtElementAnnotationsReplaceListener(m));
        this.replaceInListIfExist(m.getFormalCtTypeParameters(), new CtFormalTypeDeclarerFormalCtTypeParametersReplaceListener(m));
        this.replaceElementIfExist(m.getType(), new CtTypedElementTypeReplaceListener(m));
        this.replaceInListIfExist(m.getParameters(), new CtExecutableParametersReplaceListener(m));
        this.replaceInSetIfExist(m.getThrownTypes(), new CtExecutableThrownTypesReplaceListener(m));
        this.replaceElementIfExist(m.getBody(), new CtExecutableBodyReplaceListener(m));
        this.replaceInListIfExist(m.getComments(), new CtElementCommentsReplaceListener(m));
    }

    @Override
    public <T> void visitCtAnnotationMethod(CtAnnotationMethod<T> annotationMethod) {
        this.replaceInListIfExist(annotationMethod.getAnnotations(), new CtElementAnnotationsReplaceListener(annotationMethod));
        this.replaceElementIfExist(annotationMethod.getType(), new CtTypedElementTypeReplaceListener(annotationMethod));
        this.replaceElementIfExist(annotationMethod.getDefaultExpression(), new CtAnnotationMethodDefaultExpressionReplaceListener(annotationMethod));
        this.replaceInListIfExist(annotationMethod.getComments(), new CtElementCommentsReplaceListener(annotationMethod));
    }

    @Override
    public <T> void visitCtNewArray(CtNewArray<T> newArray) {
        this.replaceInListIfExist(newArray.getAnnotations(), new CtElementAnnotationsReplaceListener(newArray));
        this.replaceElementIfExist(newArray.getType(), new CtTypedElementTypeReplaceListener(newArray));
        this.replaceInListIfExist(newArray.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(newArray));
        this.replaceInListIfExist(newArray.getElements(), new CtNewArrayElementsReplaceListener(newArray));
        this.replaceInListIfExist(newArray.getDimensionExpressions(), new CtNewArrayDimensionExpressionsReplaceListener(newArray));
        this.replaceInListIfExist(newArray.getComments(), new CtElementCommentsReplaceListener(newArray));
    }

    @Override
    public <T> void visitCtConstructorCall(CtConstructorCall<T> ctConstructorCall) {
        this.replaceInListIfExist(ctConstructorCall.getAnnotations(), new CtElementAnnotationsReplaceListener(ctConstructorCall));
        this.replaceInListIfExist(ctConstructorCall.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(ctConstructorCall));
        this.replaceElementIfExist(ctConstructorCall.getExecutable(), new CtAbstractInvocationExecutableReplaceListener(ctConstructorCall));
        this.replaceElementIfExist((CtElement)ctConstructorCall.getTarget(), new CtTargetedExpressionTargetReplaceListener(ctConstructorCall));
        this.replaceInListIfExist(ctConstructorCall.getArguments(), new CtAbstractInvocationArgumentsReplaceListener(ctConstructorCall));
        this.replaceInListIfExist(ctConstructorCall.getComments(), new CtElementCommentsReplaceListener(ctConstructorCall));
    }

    @Override
    public <T> void visitCtNewClass(CtNewClass<T> newClass) {
        this.replaceInListIfExist(newClass.getAnnotations(), new CtElementAnnotationsReplaceListener(newClass));
        this.replaceInListIfExist(newClass.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(newClass));
        this.replaceElementIfExist(newClass.getExecutable(), new CtAbstractInvocationExecutableReplaceListener(newClass));
        this.replaceElementIfExist((CtElement)newClass.getTarget(), new CtTargetedExpressionTargetReplaceListener(newClass));
        this.replaceInListIfExist(newClass.getArguments(), new CtAbstractInvocationArgumentsReplaceListener(newClass));
        this.replaceElementIfExist(newClass.getAnonymousClass(), new CtNewClassAnonymousClassReplaceListener(newClass));
        this.replaceInListIfExist(newClass.getComments(), new CtElementCommentsReplaceListener(newClass));
    }

    @Override
    public <T> void visitCtLambda(CtLambda<T> lambda) {
        this.replaceInListIfExist(lambda.getAnnotations(), new CtElementAnnotationsReplaceListener(lambda));
        this.replaceElementIfExist(lambda.getType(), new CtTypedElementTypeReplaceListener(lambda));
        this.replaceInListIfExist(lambda.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(lambda));
        this.replaceInListIfExist(lambda.getParameters(), new CtExecutableParametersReplaceListener(lambda));
        this.replaceElementIfExist(lambda.getBody(), new CtExecutableBodyReplaceListener(lambda));
        this.replaceElementIfExist(lambda.getExpression(), new CtLambdaExpressionReplaceListener(lambda));
        this.replaceInListIfExist(lambda.getComments(), new CtElementCommentsReplaceListener(lambda));
    }

    @Override
    public <T, E extends CtExpression<?>> void visitCtExecutableReferenceExpression(CtExecutableReferenceExpression<T, E> expression) {
        this.replaceInListIfExist(expression.getComments(), new CtElementCommentsReplaceListener(expression));
        this.replaceInListIfExist(expression.getAnnotations(), new CtElementAnnotationsReplaceListener(expression));
        this.replaceElementIfExist(expression.getType(), new CtTypedElementTypeReplaceListener(expression));
        this.replaceInListIfExist(expression.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(expression));
        this.replaceElementIfExist(expression.getExecutable(), new CtExecutableReferenceExpressionExecutableReplaceListener(expression));
        this.replaceElementIfExist((CtElement)expression.getTarget(), new CtTargetedExpressionTargetReplaceListener(expression));
    }

    @Override
    public <T, A extends T> void visitCtOperatorAssignment(CtOperatorAssignment<T, A> assignment) {
        this.replaceInListIfExist(assignment.getAnnotations(), new CtElementAnnotationsReplaceListener(assignment));
        this.replaceElementIfExist(assignment.getType(), new CtTypedElementTypeReplaceListener(assignment));
        this.replaceInListIfExist(assignment.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(assignment));
        this.replaceElementIfExist(assignment.getAssigned(), new CtAssignmentAssignedReplaceListener(assignment));
        this.replaceElementIfExist(assignment.getAssignment(), new CtRHSReceiverAssignmentReplaceListener(assignment));
        this.replaceInListIfExist(assignment.getComments(), new CtElementCommentsReplaceListener(assignment));
    }

    @Override
    public void visitCtPackage(CtPackage ctPackage) {
        this.replaceInListIfExist(ctPackage.getAnnotations(), new CtElementAnnotationsReplaceListener(ctPackage));
        this.replaceInSetIfExist(ctPackage.getPackages(), new CtPackagePackagesReplaceListener(ctPackage));
        this.replaceInSetIfExist(ctPackage.getTypes(), new CtPackageTypesReplaceListener(ctPackage));
        this.replaceInListIfExist(ctPackage.getComments(), new CtElementCommentsReplaceListener(ctPackage));
    }

    @Override
    public void visitCtPackageReference(CtPackageReference reference) {
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtParameter(CtParameter<T> parameter) {
        this.replaceInListIfExist(parameter.getAnnotations(), new CtElementAnnotationsReplaceListener(parameter));
        this.replaceElementIfExist(parameter.getType(), new CtTypedElementTypeReplaceListener(parameter));
        this.replaceInListIfExist(parameter.getComments(), new CtElementCommentsReplaceListener(parameter));
    }

    @Override
    public <T> void visitCtParameterReference(CtParameterReference<T> reference) {
        this.replaceElementIfExist(reference.getType(), new CtVariableReferenceTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
    }

    @Override
    public <R> void visitCtReturn(CtReturn<R> returnStatement) {
        this.replaceInListIfExist(returnStatement.getAnnotations(), new CtElementAnnotationsReplaceListener(returnStatement));
        this.replaceElementIfExist(returnStatement.getReturnedExpression(), new CtReturnReturnedExpressionReplaceListener(returnStatement));
        this.replaceInListIfExist(returnStatement.getComments(), new CtElementCommentsReplaceListener(returnStatement));
    }

    @Override
    public <R> void visitCtStatementList(CtStatementList statements) {
        this.replaceInListIfExist(statements.getAnnotations(), new CtElementAnnotationsReplaceListener(statements));
        this.replaceInListIfExist(statements.getStatements(), new CtStatementListStatementsReplaceListener(statements));
        this.replaceInListIfExist(statements.getComments(), new CtElementCommentsReplaceListener(statements));
    }

    @Override
    public <S> void visitCtSwitch(CtSwitch<S> switchStatement) {
        this.replaceInListIfExist(switchStatement.getAnnotations(), new CtElementAnnotationsReplaceListener(switchStatement));
        this.replaceElementIfExist(switchStatement.getSelector(), new CtAbstractSwitchSelectorReplaceListener(switchStatement));
        this.replaceInListIfExist(switchStatement.getCases(), new CtAbstractSwitchCasesReplaceListener(switchStatement));
        this.replaceInListIfExist(switchStatement.getComments(), new CtElementCommentsReplaceListener(switchStatement));
    }

    @Override
    public <T, S> void visitCtSwitchExpression(CtSwitchExpression<T, S> switchExpression) {
        this.replaceInListIfExist(switchExpression.getAnnotations(), new CtElementAnnotationsReplaceListener(switchExpression));
        this.replaceElementIfExist(switchExpression.getSelector(), new CtAbstractSwitchSelectorReplaceListener(switchExpression));
        this.replaceInListIfExist(switchExpression.getCases(), new CtAbstractSwitchCasesReplaceListener(switchExpression));
        this.replaceInListIfExist(switchExpression.getComments(), new CtElementCommentsReplaceListener(switchExpression));
        this.replaceElementIfExist(switchExpression.getType(), new CtTypedElementTypeReplaceListener(switchExpression));
        this.replaceInListIfExist(switchExpression.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(switchExpression));
    }

    @Override
    public void visitCtSynchronized(CtSynchronized synchro) {
        this.replaceInListIfExist(synchro.getAnnotations(), new CtElementAnnotationsReplaceListener(synchro));
        this.replaceElementIfExist(synchro.getExpression(), new CtSynchronizedExpressionReplaceListener(synchro));
        this.replaceElementIfExist(synchro.getBlock(), new CtSynchronizedBlockReplaceListener(synchro));
        this.replaceInListIfExist(synchro.getComments(), new CtElementCommentsReplaceListener(synchro));
    }

    @Override
    public void visitCtThrow(CtThrow throwStatement) {
        this.replaceInListIfExist(throwStatement.getAnnotations(), new CtElementAnnotationsReplaceListener(throwStatement));
        this.replaceElementIfExist(throwStatement.getThrownExpression(), new CtThrowThrownExpressionReplaceListener(throwStatement));
        this.replaceInListIfExist(throwStatement.getComments(), new CtElementCommentsReplaceListener(throwStatement));
    }

    @Override
    public void visitCtTry(CtTry tryBlock) {
        this.replaceInListIfExist(tryBlock.getAnnotations(), new CtElementAnnotationsReplaceListener(tryBlock));
        this.replaceElementIfExist(tryBlock.getBody(), new CtTryBodyReplaceListener(tryBlock));
        this.replaceInListIfExist(tryBlock.getCatchers(), new CtTryCatchersReplaceListener(tryBlock));
        this.replaceElementIfExist(tryBlock.getFinalizer(), new CtTryFinalizerReplaceListener(tryBlock));
        this.replaceInListIfExist(tryBlock.getComments(), new CtElementCommentsReplaceListener(tryBlock));
    }

    @Override
    public void visitCtTryWithResource(CtTryWithResource tryWithResource) {
        this.replaceInListIfExist(tryWithResource.getAnnotations(), new CtElementAnnotationsReplaceListener(tryWithResource));
        this.replaceInListIfExist(tryWithResource.getResources(), new CtTryWithResourceResourcesReplaceListener(tryWithResource));
        this.replaceElementIfExist(tryWithResource.getBody(), new CtTryBodyReplaceListener(tryWithResource));
        this.replaceInListIfExist(tryWithResource.getCatchers(), new CtTryCatchersReplaceListener(tryWithResource));
        this.replaceElementIfExist(tryWithResource.getFinalizer(), new CtTryFinalizerReplaceListener(tryWithResource));
        this.replaceInListIfExist(tryWithResource.getComments(), new CtElementCommentsReplaceListener(tryWithResource));
    }

    @Override
    public void visitCtTypeParameterReference(CtTypeParameterReference ref) {
        this.replaceElementIfExist(ref.getPackage(), new CtTypeReferencePackageReplaceListener(ref));
        this.replaceElementIfExist(ref.getDeclaringType(), new CtTypeReferenceDeclaringTypeReplaceListener(ref));
        this.replaceInListIfExist(ref.getAnnotations(), new CtElementAnnotationsReplaceListener(ref));
    }

    @Override
    public void visitCtWildcardReference(CtWildcardReference wildcardReference) {
        this.replaceElementIfExist(wildcardReference.getPackage(), new CtTypeReferencePackageReplaceListener(wildcardReference));
        this.replaceElementIfExist(wildcardReference.getDeclaringType(), new CtTypeReferenceDeclaringTypeReplaceListener(wildcardReference));
        this.replaceInListIfExist(wildcardReference.getAnnotations(), new CtElementAnnotationsReplaceListener(wildcardReference));
        this.replaceElementIfExist(wildcardReference.getBoundingType(), new CtWildcardReferenceBoundingTypeReplaceListener(wildcardReference));
    }

    @Override
    public <T> void visitCtIntersectionTypeReference(CtIntersectionTypeReference<T> reference) {
        this.replaceElementIfExist(reference.getPackage(), new CtTypeReferencePackageReplaceListener(reference));
        this.replaceElementIfExist(reference.getDeclaringType(), new CtTypeReferenceDeclaringTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getActualTypeArguments(), new CtActualTypeContainerActualTypeArgumentsReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
        this.replaceInListIfExist(reference.getBounds(), new CtIntersectionTypeReferenceBoundsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        this.replaceElementIfExist(reference.getPackage(), new CtTypeReferencePackageReplaceListener(reference));
        this.replaceElementIfExist(reference.getDeclaringType(), new CtTypeReferenceDeclaringTypeReplaceListener(reference));
        this.replaceInListIfExist(reference.getActualTypeArguments(), new CtActualTypeContainerActualTypeArgumentsReplaceListener(reference));
        this.replaceInListIfExist(reference.getAnnotations(), new CtElementAnnotationsReplaceListener(reference));
        this.replaceInListIfExist(reference.getComments(), new CtElementCommentsReplaceListener(reference));
    }

    @Override
    public <T> void visitCtTypeAccess(CtTypeAccess<T> typeAccess) {
        this.replaceInListIfExist(typeAccess.getAnnotations(), new CtElementAnnotationsReplaceListener(typeAccess));
        this.replaceInListIfExist(typeAccess.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(typeAccess));
        this.replaceElementIfExist(typeAccess.getAccessedType(), new CtTypeAccessAccessedTypeReplaceListener(typeAccess));
        this.replaceInListIfExist(typeAccess.getComments(), new CtElementCommentsReplaceListener(typeAccess));
    }

    @Override
    public <T> void visitCtUnaryOperator(CtUnaryOperator<T> operator) {
        this.replaceInListIfExist(operator.getAnnotations(), new CtElementAnnotationsReplaceListener(operator));
        this.replaceElementIfExist(operator.getType(), new CtTypedElementTypeReplaceListener(operator));
        this.replaceInListIfExist(operator.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(operator));
        this.replaceElementIfExist(operator.getOperand(), new CtUnaryOperatorOperandReplaceListener(operator));
        this.replaceInListIfExist(operator.getComments(), new CtElementCommentsReplaceListener(operator));
    }

    @Override
    public <T> void visitCtVariableRead(CtVariableRead<T> variableRead) {
        this.replaceInListIfExist(variableRead.getAnnotations(), new CtElementAnnotationsReplaceListener(variableRead));
        this.replaceInListIfExist(variableRead.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(variableRead));
        this.replaceElementIfExist(variableRead.getVariable(), new CtVariableAccessVariableReplaceListener(variableRead));
        this.replaceInListIfExist(variableRead.getComments(), new CtElementCommentsReplaceListener(variableRead));
    }

    @Override
    public <T> void visitCtVariableWrite(CtVariableWrite<T> variableWrite) {
        this.replaceInListIfExist(variableWrite.getAnnotations(), new CtElementAnnotationsReplaceListener(variableWrite));
        this.replaceInListIfExist(variableWrite.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(variableWrite));
        this.replaceElementIfExist(variableWrite.getVariable(), new CtVariableAccessVariableReplaceListener(variableWrite));
        this.replaceInListIfExist(variableWrite.getComments(), new CtElementCommentsReplaceListener(variableWrite));
    }

    @Override
    public void visitCtWhile(CtWhile whileLoop) {
        this.replaceInListIfExist(whileLoop.getAnnotations(), new CtElementAnnotationsReplaceListener(whileLoop));
        this.replaceElementIfExist(whileLoop.getLoopingExpression(), new CtWhileLoopingExpressionReplaceListener(whileLoop));
        this.replaceElementIfExist(whileLoop.getBody(), new CtLoopBodyReplaceListener(whileLoop));
        this.replaceInListIfExist(whileLoop.getComments(), new CtElementCommentsReplaceListener(whileLoop));
    }

    @Override
    public <T> void visitCtCodeSnippetExpression(CtCodeSnippetExpression<T> expression) {
        this.replaceElementIfExist(expression.getType(), new CtTypedElementTypeReplaceListener(expression));
        this.replaceInListIfExist(expression.getComments(), new CtElementCommentsReplaceListener(expression));
        this.replaceInListIfExist(expression.getAnnotations(), new CtElementAnnotationsReplaceListener(expression));
        this.replaceInListIfExist(expression.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(expression));
    }

    @Override
    public void visitCtCodeSnippetStatement(CtCodeSnippetStatement statement) {
        this.replaceInListIfExist(statement.getComments(), new CtElementCommentsReplaceListener(statement));
        this.replaceInListIfExist(statement.getAnnotations(), new CtElementAnnotationsReplaceListener(statement));
    }

    @Override
    public <T> void visitCtUnboundVariableReference(CtUnboundVariableReference<T> reference) {
        this.replaceElementIfExist(reference.getType(), new CtVariableReferenceTypeReplaceListener(reference));
    }

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.replaceInListIfExist(fieldRead.getAnnotations(), new CtElementAnnotationsReplaceListener(fieldRead));
        this.replaceInListIfExist(fieldRead.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(fieldRead));
        this.replaceElementIfExist((CtElement)fieldRead.getTarget(), new CtTargetedExpressionTargetReplaceListener(fieldRead));
        this.replaceElementIfExist(fieldRead.getVariable(), new CtFieldAccessVariableReplaceListener(fieldRead));
        this.replaceInListIfExist(fieldRead.getComments(), new CtElementCommentsReplaceListener(fieldRead));
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.replaceInListIfExist(fieldWrite.getAnnotations(), new CtElementAnnotationsReplaceListener(fieldWrite));
        this.replaceInListIfExist(fieldWrite.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(fieldWrite));
        this.replaceElementIfExist((CtElement)fieldWrite.getTarget(), new CtTargetedExpressionTargetReplaceListener(fieldWrite));
        this.replaceElementIfExist(fieldWrite.getVariable(), new CtFieldAccessVariableReplaceListener(fieldWrite));
        this.replaceInListIfExist(fieldWrite.getComments(), new CtElementCommentsReplaceListener(fieldWrite));
    }

    @Override
    public <T> void visitCtSuperAccess(CtSuperAccess<T> f) {
        this.replaceInListIfExist(f.getComments(), new CtElementCommentsReplaceListener(f));
        this.replaceInListIfExist(f.getAnnotations(), new CtElementAnnotationsReplaceListener(f));
        this.replaceInListIfExist(f.getTypeCasts(), new CtExpressionTypeCastsReplaceListener(f));
        this.replaceElementIfExist((CtElement)f.getTarget(), new CtTargetedExpressionTargetReplaceListener(f));
        this.replaceElementIfExist(f.getVariable(), new CtVariableAccessVariableReplaceListener(f));
    }

    @Override
    public void visitCtComment(CtComment comment) {
        this.replaceInListIfExist(comment.getComments(), new CtElementCommentsReplaceListener(comment));
        this.replaceInListIfExist(comment.getAnnotations(), new CtElementAnnotationsReplaceListener(comment));
    }

    @Override
    public void visitCtJavaDoc(CtJavaDoc javaDoc) {
        this.replaceInListIfExist(javaDoc.getComments(), new CtElementCommentsReplaceListener(javaDoc));
        this.replaceInListIfExist(javaDoc.getAnnotations(), new CtElementAnnotationsReplaceListener(javaDoc));
        this.replaceInListIfExist(javaDoc.getTags(), new CtJavaDocTagsReplaceListener(javaDoc));
    }

    @Override
    public void visitCtJavaDocTag(CtJavaDocTag docTag) {
        this.replaceInListIfExist(docTag.getComments(), new CtElementCommentsReplaceListener(docTag));
        this.replaceInListIfExist(docTag.getAnnotations(), new CtElementAnnotationsReplaceListener(docTag));
    }

    @Override
    public void visitCtImport(CtImport ctImport) {
        this.replaceElementIfExist(ctImport.getReference(), new CtImportReferenceReplaceListener(ctImport));
        this.replaceInListIfExist(ctImport.getAnnotations(), new CtElementAnnotationsReplaceListener(ctImport));
        this.replaceInListIfExist(ctImport.getComments(), new CtElementCommentsReplaceListener(ctImport));
    }

    @Override
    public void visitCtModule(CtModule module) {
        this.replaceInListIfExist(module.getComments(), new CtElementCommentsReplaceListener(module));
        this.replaceInListIfExist(module.getAnnotations(), new CtElementAnnotationsReplaceListener(module));
        this.replaceInListIfExist(module.getModuleDirectives(), new CtModuleModuleDirectivesReplaceListener(module));
        this.replaceElementIfExist(module.getRootPackage(), new CtModuleRootPackageReplaceListener(module));
    }

    @Override
    public void visitCtModuleReference(CtModuleReference moduleReference) {
        this.replaceInListIfExist(moduleReference.getAnnotations(), new CtElementAnnotationsReplaceListener(moduleReference));
    }

    @Override
    public void visitCtPackageExport(CtPackageExport moduleExport) {
        this.replaceInListIfExist(moduleExport.getComments(), new CtElementCommentsReplaceListener(moduleExport));
        this.replaceElementIfExist(moduleExport.getPackageReference(), new CtPackageExportPackageReferenceReplaceListener(moduleExport));
        this.replaceInListIfExist(moduleExport.getTargetExport(), new CtPackageExportTargetExportReplaceListener(moduleExport));
        this.replaceInListIfExist(moduleExport.getAnnotations(), new CtElementAnnotationsReplaceListener(moduleExport));
    }

    @Override
    public void visitCtModuleRequirement(CtModuleRequirement moduleRequirement) {
        this.replaceInListIfExist(moduleRequirement.getComments(), new CtElementCommentsReplaceListener(moduleRequirement));
        this.replaceElementIfExist(moduleRequirement.getModuleReference(), new CtModuleRequirementModuleReferenceReplaceListener(moduleRequirement));
        this.replaceInListIfExist(moduleRequirement.getAnnotations(), new CtElementAnnotationsReplaceListener(moduleRequirement));
    }

    @Override
    public void visitCtProvidedService(CtProvidedService moduleProvidedService) {
        this.replaceInListIfExist(moduleProvidedService.getComments(), new CtElementCommentsReplaceListener(moduleProvidedService));
        this.replaceElementIfExist(moduleProvidedService.getServiceType(), new CtProvidedServiceServiceTypeReplaceListener(moduleProvidedService));
        this.replaceInListIfExist(moduleProvidedService.getImplementationTypes(), new CtProvidedServiceImplementationTypesReplaceListener(moduleProvidedService));
        this.replaceInListIfExist(moduleProvidedService.getAnnotations(), new CtElementAnnotationsReplaceListener(moduleProvidedService));
    }

    @Override
    public void visitCtUsedService(CtUsedService usedService) {
        this.replaceInListIfExist(usedService.getComments(), new CtElementCommentsReplaceListener(usedService));
        this.replaceElementIfExist(usedService.getServiceType(), new CtUsedServiceServiceTypeReplaceListener(usedService));
        this.replaceInListIfExist(usedService.getAnnotations(), new CtElementAnnotationsReplaceListener(usedService));
    }

    @Override
    public void visitCtCompilationUnit(CtCompilationUnit compilationUnit) {
        this.replaceInListIfExist(compilationUnit.getComments(), new CtElementCommentsReplaceListener(compilationUnit));
        this.replaceInListIfExist(compilationUnit.getAnnotations(), new CtElementAnnotationsReplaceListener(compilationUnit));
        this.replaceElementIfExist(compilationUnit.getPackageDeclaration(), new CtCompilationUnitPackageDeclarationReplaceListener(compilationUnit));
        this.replaceInListIfExist(compilationUnit.getImports(), new CtCompilationUnitImportsReplaceListener(compilationUnit));
        this.replaceElementIfExist(compilationUnit.getDeclaredModuleReference(), new CtCompilationUnitDeclaredModuleReferenceReplaceListener(compilationUnit));
        this.replaceInListIfExist(compilationUnit.getDeclaredTypeReferences(), new CtCompilationUnitDeclaredTypeReferencesReplaceListener(compilationUnit));
    }

    @Override
    public void visitCtPackageDeclaration(CtPackageDeclaration packageDeclaration) {
        this.replaceInListIfExist(packageDeclaration.getComments(), new CtElementCommentsReplaceListener(packageDeclaration));
        this.replaceInListIfExist(packageDeclaration.getAnnotations(), new CtElementAnnotationsReplaceListener(packageDeclaration));
        this.replaceElementIfExist(packageDeclaration.getReference(), new CtPackageDeclarationReferenceReplaceListener(packageDeclaration));
    }

    @Override
    public void visitCtTypeMemberWildcardImportReference(CtTypeMemberWildcardImportReference wildcardReference) {
        this.replaceElementIfExist(wildcardReference.getTypeReference(), new CtTypeMemberWildcardImportReferenceTypeReferenceReplaceListener(wildcardReference));
    }

    @Override
    public void visitCtYieldStatement(CtYieldStatement statement) {
        this.replaceInListIfExist(statement.getAnnotations(), new CtElementAnnotationsReplaceListener(statement));
        this.replaceElementIfExist(statement.getExpression(), new CtYieldStatementExpressionReplaceListener(statement));
        this.replaceInListIfExist(statement.getComments(), new CtElementCommentsReplaceListener(statement));
    }

    class CtTypedElementTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtTypedElement element;

        CtTypedElementTypeReplaceListener(CtTypedElement element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setType(replace);
        }
    }

    class CtElementCommentsReplaceListener
    implements ReplaceListListener<List> {
        private final CtElement element;

        CtElementCommentsReplaceListener(CtElement element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setComments(replace);
        }
    }

    class CtAnnotationAnnotationTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtAnnotation element;

        CtAnnotationAnnotationTypeReplaceListener(CtAnnotation element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setAnnotationType(replace);
        }
    }

    class CtElementAnnotationsReplaceListener
    implements ReplaceListListener<List> {
        private final CtElement element;

        CtElementAnnotationsReplaceListener(CtElement element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setAnnotations(replace);
        }
    }

    class CtAnnotationValuesReplaceListener
    implements ReplaceMapListener<Map> {
        private final CtAnnotation element;

        CtAnnotationValuesReplaceListener(CtAnnotation element) {
            this.element = element;
        }

        @Override
        public void set(Map replace) {
            this.element.setValues(replace);
        }
    }

    class CtTypeTypeMembersReplaceListener
    implements ReplaceListListener<List> {
        private final CtType element;

        CtTypeTypeMembersReplaceListener(CtType element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setTypeMembers(replace);
        }
    }

    class CtExecutableBodyReplaceListener
    implements ReplaceListener<CtBlock> {
        private final CtBodyHolder element;

        CtExecutableBodyReplaceListener(CtBodyHolder element) {
            this.element = element;
        }

        @Override
        public void set(CtBlock replace) {
            this.element.setBody(replace);
        }
    }

    class CtExpressionTypeCastsReplaceListener
    implements ReplaceListListener<List> {
        private final CtExpression element;

        CtExpressionTypeCastsReplaceListener(CtExpression element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setTypeCasts(replace);
        }
    }

    class CtTargetedExpressionTargetReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtTargetedExpression element;

        CtTargetedExpressionTargetReplaceListener(CtTargetedExpression element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setTarget(replace);
        }
    }

    class CtArrayAccessIndexExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtArrayAccess element;

        CtArrayAccessIndexExpressionReplaceListener(CtArrayAccess element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setIndexExpression(replace);
        }
    }

    class CtTypeReferencePackageReplaceListener
    implements ReplaceListener<CtPackageReference> {
        private final CtTypeReference element;

        CtTypeReferencePackageReplaceListener(CtTypeReference element) {
            this.element = element;
        }

        @Override
        public void set(CtPackageReference replace) {
            this.element.setPackage(replace);
        }
    }

    class CtTypeReferenceDeclaringTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtTypeReference element;

        CtTypeReferenceDeclaringTypeReplaceListener(CtTypeReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setDeclaringType(replace);
        }
    }

    class CtArrayTypeReferenceComponentTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtArrayTypeReference element;

        CtArrayTypeReferenceComponentTypeReplaceListener(CtArrayTypeReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setComponentType(replace);
        }
    }

    class CtActualTypeContainerActualTypeArgumentsReplaceListener
    implements ReplaceListListener<List> {
        private final CtActualTypeContainer element;

        CtActualTypeContainerActualTypeArgumentsReplaceListener(CtActualTypeContainer element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setActualTypeArguments(replace);
        }
    }

    class CtAssertAssertExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtAssert element;

        CtAssertAssertExpressionReplaceListener(CtAssert element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setAssertExpression(replace);
        }
    }

    class CtAssertExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtAssert element;

        CtAssertExpressionReplaceListener(CtAssert element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setExpression(replace);
        }
    }

    class CtAssignmentAssignedReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtAssignment element;

        CtAssignmentAssignedReplaceListener(CtAssignment element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setAssigned(replace);
        }
    }

    class CtRHSReceiverAssignmentReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtRHSReceiver element;

        CtRHSReceiverAssignmentReplaceListener(CtRHSReceiver element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setAssignment(replace);
        }
    }

    class CtBinaryOperatorLeftHandOperandReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtBinaryOperator element;

        CtBinaryOperatorLeftHandOperandReplaceListener(CtBinaryOperator element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setLeftHandOperand(replace);
        }
    }

    class CtBinaryOperatorRightHandOperandReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtBinaryOperator element;

        CtBinaryOperatorRightHandOperandReplaceListener(CtBinaryOperator element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setRightHandOperand(replace);
        }
    }

    class CtStatementListStatementsReplaceListener
    implements ReplaceListListener<List> {
        private final CtStatementList element;

        CtStatementListStatementsReplaceListener(CtStatementList element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setStatements(replace);
        }
    }

    class CtCaseCaseExpressionsReplaceListener
    implements ReplaceListListener<List> {
        private final CtCase element;

        CtCaseCaseExpressionsReplaceListener(CtCase element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setCaseExpressions(replace);
        }
    }

    class CtCatchParameterReplaceListener
    implements ReplaceListener<CtCatchVariable> {
        private final CtCatch element;

        CtCatchParameterReplaceListener(CtCatch element) {
            this.element = element;
        }

        @Override
        public void set(CtCatchVariable replace) {
            this.element.setParameter(replace);
        }
    }

    class CtCatchBodyReplaceListener
    implements ReplaceListener<CtBlock> {
        private final CtBodyHolder element;

        CtCatchBodyReplaceListener(CtBodyHolder element) {
            this.element = element;
        }

        @Override
        public void set(CtBlock replace) {
            this.element.setBody(replace);
        }
    }

    class CtTypeInformationSuperclassReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtType element;

        CtTypeInformationSuperclassReplaceListener(CtType element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setSuperclass(replace);
        }
    }

    class CtTypeInformationSuperInterfacesReplaceListener
    implements ReplaceSetListener<Set> {
        private final CtType element;

        CtTypeInformationSuperInterfacesReplaceListener(CtType element) {
            this.element = element;
        }

        @Override
        public void set(Set replace) {
            this.element.setSuperInterfaces(replace);
        }
    }

    class CtFormalTypeDeclarerFormalCtTypeParametersReplaceListener
    implements ReplaceListListener<List> {
        private final CtFormalTypeDeclarer element;

        CtFormalTypeDeclarerFormalCtTypeParametersReplaceListener(CtFormalTypeDeclarer element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setFormalCtTypeParameters(replace);
        }
    }

    class CtConditionalConditionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtConditional element;

        CtConditionalConditionReplaceListener(CtConditional element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setCondition(replace);
        }
    }

    class CtConditionalThenExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtConditional element;

        CtConditionalThenExpressionReplaceListener(CtConditional element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setThenExpression(replace);
        }
    }

    class CtConditionalElseExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtConditional element;

        CtConditionalElseExpressionReplaceListener(CtConditional element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setElseExpression(replace);
        }
    }

    class CtExecutableParametersReplaceListener
    implements ReplaceListListener<List> {
        private final CtExecutable element;

        CtExecutableParametersReplaceListener(CtExecutable element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setParameters(replace);
        }
    }

    class CtExecutableThrownTypesReplaceListener
    implements ReplaceSetListener<Set> {
        private final CtExecutable element;

        CtExecutableThrownTypesReplaceListener(CtExecutable element) {
            this.element = element;
        }

        @Override
        public void set(Set replace) {
            this.element.setThrownTypes(replace);
        }
    }

    class CtDoLoopingExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtDo element;

        CtDoLoopingExpressionReplaceListener(CtDo element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setLoopingExpression(replace);
        }
    }

    class CtLoopBodyReplaceListener
    implements ReplaceListener<CtStatement> {
        private final CtBodyHolder element;

        CtLoopBodyReplaceListener(CtBodyHolder element) {
            this.element = element;
        }

        @Override
        public void set(CtStatement replace) {
            this.element.setBody(replace);
        }
    }

    class CtEnumEnumValuesReplaceListener
    implements ReplaceListListener<List> {
        private final CtEnum element;

        CtEnumEnumValuesReplaceListener(CtEnum element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setEnumValues(replace);
        }
    }

    class CtExecutableReferenceDeclaringTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtExecutableReference element;

        CtExecutableReferenceDeclaringTypeReplaceListener(CtExecutableReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setDeclaringType(replace);
        }
    }

    class CtExecutableReferenceTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtExecutableReference element;

        CtExecutableReferenceTypeReplaceListener(CtExecutableReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setType(replace);
        }
    }

    class CtExecutableReferenceParametersReplaceListener
    implements ReplaceListListener<List> {
        private final CtExecutableReference element;

        CtExecutableReferenceParametersReplaceListener(CtExecutableReference element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setParameters(replace);
        }
    }

    class CtVariableDefaultExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtVariable element;

        CtVariableDefaultExpressionReplaceListener(CtVariable element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setDefaultExpression(replace);
        }
    }

    class CtAnnotationFieldAccessVariableReplaceListener
    implements ReplaceListener<CtFieldReference> {
        private final CtVariableAccess element;

        CtAnnotationFieldAccessVariableReplaceListener(CtVariableAccess element) {
            this.element = element;
        }

        @Override
        public void set(CtFieldReference replace) {
            this.element.setVariable(replace);
        }
    }

    class CtFieldReferenceDeclaringTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtFieldReference element;

        CtFieldReferenceDeclaringTypeReplaceListener(CtFieldReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setDeclaringType(replace);
        }
    }

    class CtVariableReferenceTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtVariableReference element;

        CtVariableReferenceTypeReplaceListener(CtVariableReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setType(replace);
        }
    }

    class CtForForInitReplaceListener
    implements ReplaceListListener<List> {
        private final CtFor element;

        CtForForInitReplaceListener(CtFor element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setForInit(replace);
        }
    }

    class CtForExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtFor element;

        CtForExpressionReplaceListener(CtFor element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setExpression(replace);
        }
    }

    class CtForForUpdateReplaceListener
    implements ReplaceListListener<List> {
        private final CtFor element;

        CtForForUpdateReplaceListener(CtFor element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setForUpdate(replace);
        }
    }

    class CtForEachVariableReplaceListener
    implements ReplaceListener<CtLocalVariable> {
        private final CtForEach element;

        CtForEachVariableReplaceListener(CtForEach element) {
            this.element = element;
        }

        @Override
        public void set(CtLocalVariable replace) {
            this.element.setVariable(replace);
        }
    }

    class CtForEachExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtForEach element;

        CtForEachExpressionReplaceListener(CtForEach element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setExpression(replace);
        }
    }

    class CtIfConditionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtIf element;

        CtIfConditionReplaceListener(CtIf element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setCondition(replace);
        }
    }

    class CtIfThenStatementReplaceListener
    implements ReplaceListener<CtStatement> {
        private final CtIf element;

        CtIfThenStatementReplaceListener(CtIf element) {
            this.element = element;
        }

        @Override
        public void set(CtStatement replace) {
            this.element.setThenStatement(replace);
        }
    }

    class CtIfElseStatementReplaceListener
    implements ReplaceListener<CtStatement> {
        private final CtIf element;

        CtIfElseStatementReplaceListener(CtIf element) {
            this.element = element;
        }

        @Override
        public void set(CtStatement replace) {
            this.element.setElseStatement(replace);
        }
    }

    class CtAbstractInvocationExecutableReplaceListener
    implements ReplaceListener<CtExecutableReference> {
        private final CtAbstractInvocation element;

        CtAbstractInvocationExecutableReplaceListener(CtAbstractInvocation element) {
            this.element = element;
        }

        @Override
        public void set(CtExecutableReference replace) {
            this.element.setExecutable(replace);
        }
    }

    class CtAbstractInvocationArgumentsReplaceListener
    implements ReplaceListListener<List> {
        private final CtAbstractInvocation element;

        CtAbstractInvocationArgumentsReplaceListener(CtAbstractInvocation element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setArguments(replace);
        }
    }

    class CtMultiTypedElementMultiTypesReplaceListener
    implements ReplaceListListener<List> {
        private final CtMultiTypedElement element;

        CtMultiTypedElementMultiTypesReplaceListener(CtMultiTypedElement element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setMultiTypes(replace);
        }
    }

    class CtAnnotationMethodDefaultExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtAnnotationMethod element;

        CtAnnotationMethodDefaultExpressionReplaceListener(CtAnnotationMethod element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setDefaultExpression(replace);
        }
    }

    class CtNewArrayElementsReplaceListener
    implements ReplaceListListener<List> {
        private final CtNewArray element;

        CtNewArrayElementsReplaceListener(CtNewArray element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setElements(replace);
        }
    }

    class CtNewArrayDimensionExpressionsReplaceListener
    implements ReplaceListListener<List> {
        private final CtNewArray element;

        CtNewArrayDimensionExpressionsReplaceListener(CtNewArray element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setDimensionExpressions(replace);
        }
    }

    class CtNewClassAnonymousClassReplaceListener
    implements ReplaceListener<CtClass> {
        private final CtNewClass element;

        CtNewClassAnonymousClassReplaceListener(CtNewClass element) {
            this.element = element;
        }

        @Override
        public void set(CtClass replace) {
            this.element.setAnonymousClass(replace);
        }
    }

    class CtLambdaExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtLambda element;

        CtLambdaExpressionReplaceListener(CtLambda element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setExpression(replace);
        }
    }

    class CtExecutableReferenceExpressionExecutableReplaceListener
    implements ReplaceListener<CtExecutableReference> {
        private final CtExecutableReferenceExpression element;

        CtExecutableReferenceExpressionExecutableReplaceListener(CtExecutableReferenceExpression element) {
            this.element = element;
        }

        @Override
        public void set(CtExecutableReference replace) {
            this.element.setExecutable(replace);
        }
    }

    class CtPackagePackagesReplaceListener
    implements ReplaceSetListener<Set> {
        private final CtPackage element;

        CtPackagePackagesReplaceListener(CtPackage element) {
            this.element = element;
        }

        @Override
        public void set(Set replace) {
            this.element.setPackages(replace);
        }
    }

    class CtPackageTypesReplaceListener
    implements ReplaceSetListener<Set> {
        private final CtPackage element;

        CtPackageTypesReplaceListener(CtPackage element) {
            this.element = element;
        }

        @Override
        public void set(Set replace) {
            this.element.setTypes(replace);
        }
    }

    class CtReturnReturnedExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtReturn element;

        CtReturnReturnedExpressionReplaceListener(CtReturn element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setReturnedExpression(replace);
        }
    }

    class CtAbstractSwitchSelectorReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtAbstractSwitch element;

        CtAbstractSwitchSelectorReplaceListener(CtAbstractSwitch element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setSelector(replace);
        }
    }

    class CtAbstractSwitchCasesReplaceListener
    implements ReplaceListListener<List> {
        private final CtAbstractSwitch element;

        CtAbstractSwitchCasesReplaceListener(CtAbstractSwitch element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setCases(replace);
        }
    }

    class CtSynchronizedExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtSynchronized element;

        CtSynchronizedExpressionReplaceListener(CtSynchronized element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setExpression(replace);
        }
    }

    class CtSynchronizedBlockReplaceListener
    implements ReplaceListener<CtBlock> {
        private final CtSynchronized element;

        CtSynchronizedBlockReplaceListener(CtSynchronized element) {
            this.element = element;
        }

        @Override
        public void set(CtBlock replace) {
            this.element.setBlock(replace);
        }
    }

    class CtThrowThrownExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtThrow element;

        CtThrowThrownExpressionReplaceListener(CtThrow element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setThrownExpression(replace);
        }
    }

    class CtTryBodyReplaceListener
    implements ReplaceListener<CtBlock> {
        private final CtBodyHolder element;

        CtTryBodyReplaceListener(CtBodyHolder element) {
            this.element = element;
        }

        @Override
        public void set(CtBlock replace) {
            this.element.setBody(replace);
        }
    }

    class CtTryCatchersReplaceListener
    implements ReplaceListListener<List> {
        private final CtTry element;

        CtTryCatchersReplaceListener(CtTry element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setCatchers(replace);
        }
    }

    class CtTryFinalizerReplaceListener
    implements ReplaceListener<CtBlock> {
        private final CtTry element;

        CtTryFinalizerReplaceListener(CtTry element) {
            this.element = element;
        }

        @Override
        public void set(CtBlock replace) {
            this.element.setFinalizer(replace);
        }
    }

    class CtTryWithResourceResourcesReplaceListener
    implements ReplaceListListener<List> {
        private final CtTryWithResource element;

        CtTryWithResourceResourcesReplaceListener(CtTryWithResource element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setResources(replace);
        }
    }

    class CtWildcardReferenceBoundingTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtWildcardReference element;

        CtWildcardReferenceBoundingTypeReplaceListener(CtWildcardReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setBoundingType(replace);
        }
    }

    class CtIntersectionTypeReferenceBoundsReplaceListener
    implements ReplaceListListener<List> {
        private final CtIntersectionTypeReference element;

        CtIntersectionTypeReferenceBoundsReplaceListener(CtIntersectionTypeReference element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setBounds(replace);
        }
    }

    class CtTypeAccessAccessedTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtTypeAccess element;

        CtTypeAccessAccessedTypeReplaceListener(CtTypeAccess element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setAccessedType(replace);
        }
    }

    class CtUnaryOperatorOperandReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtUnaryOperator element;

        CtUnaryOperatorOperandReplaceListener(CtUnaryOperator element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setOperand(replace);
        }
    }

    class CtVariableAccessVariableReplaceListener
    implements ReplaceListener<CtVariableReference> {
        private final CtVariableAccess element;

        CtVariableAccessVariableReplaceListener(CtVariableAccess element) {
            this.element = element;
        }

        @Override
        public void set(CtVariableReference replace) {
            this.element.setVariable(replace);
        }
    }

    class CtWhileLoopingExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtWhile element;

        CtWhileLoopingExpressionReplaceListener(CtWhile element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setLoopingExpression(replace);
        }
    }

    class CtFieldAccessVariableReplaceListener
    implements ReplaceListener<CtFieldReference> {
        private final CtVariableAccess element;

        CtFieldAccessVariableReplaceListener(CtVariableAccess element) {
            this.element = element;
        }

        @Override
        public void set(CtFieldReference replace) {
            this.element.setVariable(replace);
        }
    }

    class CtJavaDocTagsReplaceListener
    implements ReplaceListListener<List> {
        private final CtJavaDoc element;

        CtJavaDocTagsReplaceListener(CtJavaDoc element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setTags(replace);
        }
    }

    class CtImportReferenceReplaceListener
    implements ReplaceListener<CtReference> {
        private final CtImport element;

        CtImportReferenceReplaceListener(CtImport element) {
            this.element = element;
        }

        @Override
        public void set(CtReference replace) {
            this.element.setReference(replace);
        }
    }

    class CtModuleModuleDirectivesReplaceListener
    implements ReplaceListListener<List> {
        private final CtModule element;

        CtModuleModuleDirectivesReplaceListener(CtModule element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setModuleDirectives(replace);
        }
    }

    class CtModuleRootPackageReplaceListener
    implements ReplaceListener<CtPackage> {
        private final CtModule element;

        CtModuleRootPackageReplaceListener(CtModule element) {
            this.element = element;
        }

        @Override
        public void set(CtPackage replace) {
            this.element.setRootPackage(replace);
        }
    }

    class CtPackageExportPackageReferenceReplaceListener
    implements ReplaceListener<CtPackageReference> {
        private final CtPackageExport element;

        CtPackageExportPackageReferenceReplaceListener(CtPackageExport element) {
            this.element = element;
        }

        @Override
        public void set(CtPackageReference replace) {
            this.element.setPackageReference(replace);
        }
    }

    class CtPackageExportTargetExportReplaceListener
    implements ReplaceListListener<List> {
        private final CtPackageExport element;

        CtPackageExportTargetExportReplaceListener(CtPackageExport element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setTargetExport(replace);
        }
    }

    class CtModuleRequirementModuleReferenceReplaceListener
    implements ReplaceListener<CtModuleReference> {
        private final CtModuleRequirement element;

        CtModuleRequirementModuleReferenceReplaceListener(CtModuleRequirement element) {
            this.element = element;
        }

        @Override
        public void set(CtModuleReference replace) {
            this.element.setModuleReference(replace);
        }
    }

    class CtProvidedServiceServiceTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtProvidedService element;

        CtProvidedServiceServiceTypeReplaceListener(CtProvidedService element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setServiceType(replace);
        }
    }

    class CtProvidedServiceImplementationTypesReplaceListener
    implements ReplaceListListener<List> {
        private final CtProvidedService element;

        CtProvidedServiceImplementationTypesReplaceListener(CtProvidedService element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setImplementationTypes(replace);
        }
    }

    class CtUsedServiceServiceTypeReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtUsedService element;

        CtUsedServiceServiceTypeReplaceListener(CtUsedService element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setServiceType(replace);
        }
    }

    class CtCompilationUnitPackageDeclarationReplaceListener
    implements ReplaceListener<CtPackageDeclaration> {
        private final CtCompilationUnit element;

        CtCompilationUnitPackageDeclarationReplaceListener(CtCompilationUnit element) {
            this.element = element;
        }

        @Override
        public void set(CtPackageDeclaration replace) {
            this.element.setPackageDeclaration(replace);
        }
    }

    class CtCompilationUnitImportsReplaceListener
    implements ReplaceListListener<Collection> {
        private final CtCompilationUnit element;

        CtCompilationUnitImportsReplaceListener(CtCompilationUnit element) {
            this.element = element;
        }

        @Override
        public void set(Collection replace) {
            this.element.setImports(replace);
        }
    }

    class CtCompilationUnitDeclaredModuleReferenceReplaceListener
    implements ReplaceListener<CtModuleReference> {
        private final CtCompilationUnit element;

        CtCompilationUnitDeclaredModuleReferenceReplaceListener(CtCompilationUnit element) {
            this.element = element;
        }

        @Override
        public void set(CtModuleReference replace) {
            this.element.setDeclaredModuleReference(replace);
        }
    }

    class CtCompilationUnitDeclaredTypeReferencesReplaceListener
    implements ReplaceListListener<List> {
        private final CtCompilationUnit element;

        CtCompilationUnitDeclaredTypeReferencesReplaceListener(CtCompilationUnit element) {
            this.element = element;
        }

        @Override
        public void set(List replace) {
            this.element.setDeclaredTypeReferences(replace);
        }
    }

    class CtPackageDeclarationReferenceReplaceListener
    implements ReplaceListener<CtPackageReference> {
        private final CtPackageDeclaration element;

        CtPackageDeclarationReferenceReplaceListener(CtPackageDeclaration element) {
            this.element = element;
        }

        @Override
        public void set(CtPackageReference replace) {
            this.element.setReference(replace);
        }
    }

    class CtTypeMemberWildcardImportReferenceTypeReferenceReplaceListener
    implements ReplaceListener<CtTypeReference> {
        private final CtTypeMemberWildcardImportReference element;

        CtTypeMemberWildcardImportReferenceTypeReferenceReplaceListener(CtTypeMemberWildcardImportReference element) {
            this.element = element;
        }

        @Override
        public void set(CtTypeReference replace) {
            this.element.setTypeReference(replace);
        }
    }

    class CtYieldStatementExpressionReplaceListener
    implements ReplaceListener<CtExpression> {
        private final CtYieldStatement element;

        CtYieldStatementExpressionReplaceListener(CtYieldStatement element) {
            this.element = element;
        }

        @Override
        public void set(CtExpression replace) {
            this.element.setExpression(replace);
        }
    }
}

