/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.testing.AbstractAssert;
import spoon.testing.Assert;
import spoon.testing.utils.Check;
import spoon.testing.utils.ProcessorUtils;

public abstract class AbstractCtPackageAssert<T extends AbstractCtPackageAssert<T>>
extends AbstractAssert<T, CtPackage> {
    protected AbstractCtPackageAssert(CtPackage actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public T isEqualTo(CtPackage expected) {
        Check.assertNotNull(expected);
        if (!((CtPackage)this.actual).getSimpleName().equals(expected.getSimpleName())) {
            throw new AssertionError((Object)String.format("The actual package named %1$s isn't equals to the expected package named %2$s", ((CtPackage)this.actual).getSimpleName(), expected.getSimpleName()));
        }
        if (this.processors != null && !this.processors.isEmpty()) {
            ProcessorUtils.process(((CtPackage)this.actual).getFactory(), this.processors);
        }
        ArrayList actualTypes = new ArrayList(((CtPackage)this.actual).getTypes());
        class TypeComparator
        implements Comparator<CtType<?>> {
            TypeComparator() {
            }

            @Override
            public int compare(CtType<?> o1, CtType<?> o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        }
        Collections.sort(actualTypes, new TypeComparator());
        ArrayList expectedTypes = new ArrayList(expected.getTypes());
        Collections.sort(expectedTypes, new TypeComparator());
        for (int i2 = 0; i2 < ((CtPackage)this.actual).getTypes().size(); ++i2) {
            CtType actualType = (CtType)actualTypes.get(i2);
            CtType expectedType = (CtType)expectedTypes.get(i2);
            if (!actualType.toString().equals(expectedType.toString())) {
                throw new AssertionError((Object)String.format("%1$s and %2$s aren't equals.", actualType.getShortRepresentation(), expectedType.getShortRepresentation()));
            }
        }
        ArrayList<CtPackage> actualPackages = new ArrayList<CtPackage>(((CtPackage)this.actual).getPackages());
        class PackageComparator
        implements Comparator<CtPackage> {
            PackageComparator() {
            }

            @Override
            public int compare(CtPackage o1, CtPackage o2) {
                return o1.getSimpleName().compareTo(o2.getSimpleName());
            }
        }
        Collections.sort(actualPackages, new PackageComparator());
        ArrayList<CtPackage> expectedPackages = new ArrayList<CtPackage>(expected.getPackages());
        Collections.sort(expectedPackages, new PackageComparator());
        for (int i3 = 0; i3 < actualPackages.size(); ++i3) {
            CtPackage actualPackage = (CtPackage)actualPackages.get(i3);
            CtPackage expectedPackage = (CtPackage)expectedPackages.get(i3);
            Assert.assertThat(actualPackage).isEqualTo(expectedPackage);
        }
        return (T)((AbstractCtPackageAssert)this.myself);
    }
}

