/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.function.Consumer;
import spoon.Launcher;
import spoon.SpoonModelBuilder;
import spoon.compiler.SpoonResourceHelper;
import spoon.reflect.declaration.CtType;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.support.DefaultCoreFactory;
import spoon.support.StandardEnvironment;

public final class ModelUtils {
    private ModelUtils() {
        throw new AssertionError();
    }

    public static Factory createFactory() {
        return new FactoryImpl(new DefaultCoreFactory(), new StandardEnvironment());
    }

    public static <T extends CtType<?>> T build(String packageName, String className) throws Exception {
        Launcher launcher = new Launcher();
        launcher.getEnvironment().setCommentEnabled(false);
        SpoonModelBuilder comp = launcher.createCompiler();
        comp.addInputSources(SpoonResourceHelper.resources("./src/test/java/" + packageName.replace('.', '/') + "/" + className + ".java"));
        comp.build();
        return comp.getFactory().Package().get(packageName).getType(className);
    }

    public static <T extends CtType<?>> T build(String packageName, String className, final Factory f) throws Exception {
        Launcher launcher = new Launcher(){

            @Override
            public Factory createFactory() {
                return f;
            }
        };
        SpoonModelBuilder comp = launcher.createCompiler();
        comp.addInputSources(SpoonResourceHelper.resources("./src/test/java/" + packageName.replace('.', '/') + "/" + className + ".java"));
        comp.build();
        return comp.getFactory().Package().get(packageName).getType(className);
    }

    public static Factory build(Class<?> ... classesToBuild) throws Exception {
        return ModelUtils.build((Launcher launcher) -> {
            launcher.getEnvironment().setNoClasspath(false);
            launcher.getEnvironment().setCommentEnabled(false);
        }, classesToBuild);
    }

    public static Factory buildNoClasspath(Class<?> ... classesToBuild) throws Exception {
        return ModelUtils.build((Launcher launcher) -> launcher.getEnvironment().setNoClasspath(true), classesToBuild);
    }

    public static Factory build(Consumer<Launcher> config, Class<?> ... classesToBuild) throws Exception {
        Launcher launcher = new Launcher();
        config.accept(launcher);
        SpoonModelBuilder comp = launcher.createCompiler();
        for (Class<?> classToBuild : classesToBuild) {
            comp.addInputSources(SpoonResourceHelper.resources("./src/test/java/" + classToBuild.getName().replace('.', '/') + ".java"));
        }
        comp.build();
        return comp.getFactory();
    }

    public static Factory build(File ... filesToBuild) {
        Launcher launcher = new Launcher();
        launcher.getEnvironment().setNoClasspath(true);
        SpoonModelBuilder comp = launcher.createCompiler();
        for (File fileToBuild : filesToBuild) {
            try {
                comp.addInputSource(SpoonResourceHelper.createResource(fileToBuild));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("File not found", e);
            }
        }
        comp.build();
        return comp.getFactory();
    }

    public static <T> CtType<T> buildClass(Class<T> classToBuild) throws Exception {
        return ModelUtils.buildClass(classToBuild, true);
    }

    public static <T> CtType<T> buildClass(Class<T> classToBuild, boolean ensureFullclasspath) throws Exception {
        if (ensureFullclasspath) {
            return ModelUtils.build(classToBuild).Type().get(classToBuild);
        }
        return ModelUtils.buildNoClasspath(classToBuild).Type().get(classToBuild);
    }

    public static <T> CtType<T> buildClass(Consumer<Launcher> config, Class<T> classToBuild) throws Exception {
        return ModelUtils.build(config, classToBuild).Type().get(classToBuild);
    }

    public static void canBeBuilt(File outputDirectoryFile, int complianceLevel) {
        ModelUtils.canBeBuilt(outputDirectoryFile, complianceLevel, false);
    }

    public static void canBeBuilt(String outputDirectory, int complianceLevel) {
        ModelUtils.canBeBuilt(outputDirectory, complianceLevel, false);
    }

    public static void canBeBuilt(File outputDirectoryFile, int complianceLevel, boolean noClasspath) {
        Launcher launcher = new Launcher();
        Factory factory = launcher.getFactory();
        factory.getEnvironment().setComplianceLevel(complianceLevel);
        factory.getEnvironment().setNoClasspath(noClasspath);
        SpoonModelBuilder compiler = launcher.createCompiler(factory);
        compiler.addInputSource(outputDirectoryFile);
        try {
            compiler.build();
        }
        catch (Exception e) {
            AssertionError error = new AssertionError((Object)("Can't compile " + outputDirectoryFile.getName() + " because " + e.getMessage()));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    public static void canBeBuilt(String outputDirectory, int complianceLevel, boolean noClasspath) {
        ModelUtils.canBeBuilt(new File(outputDirectory), complianceLevel, noClasspath);
    }

    public static String getOptimizedString(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.toString().replaceAll("[\\r\\n\\t]+", "").replaceAll("\\s{2,}", " ");
    }
}

