/*
 * Decompiled with CFR 0.152.
 */
package spoon.testing.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.util.Collection;
import spoon.Launcher;
import spoon.SpoonException;
import spoon.processing.Processor;
import spoon.processing.ProcessorProperties;
import spoon.processing.Property;
import spoon.reflect.factory.Factory;
import spoon.support.compiler.jdt.JDTBasedSpoonCompiler;
import spoon.support.util.RtHelper;

public final class ProcessorUtils {
    private static final ObjectMapper converter = new ObjectMapper();

    private ProcessorUtils() {
        throw new AssertionError();
    }

    public static void process(Factory factory, Collection<Processor<?>> processors) {
        JDTBasedSpoonCompiler compiler = (JDTBasedSpoonCompiler)new Launcher().createCompiler(factory);
        compiler.process(processors);
    }

    public static void initProperties(Processor<?> p, ProcessorProperties properties) {
        if (properties != null) {
            for (Field f : RtHelper.getAllFields(p.getClass())) {
                if (!f.isAnnotationPresent(Property.class)) continue;
                Object obj = properties.get(f.getType(), f.getName());
                if (obj != null) {
                    f.setAccessible(true);
                    try {
                        f.set(p, obj);
                        continue;
                    }
                    catch (Exception e) {
                        throw new SpoonException(e);
                    }
                }
                obj = properties.get(String.class, f.getName());
                if (obj != null) {
                    try {
                        obj = converter.readValue((String)obj, f.getType());
                        f.setAccessible(true);
                        f.set(p, obj);
                        continue;
                    }
                    catch (Exception e) {
                        throw new SpoonException("Error while assigning the value to " + f.getName(), e);
                    }
                }
                if (!f.getAnnotation(Property.class).notNullable()) continue;
                throw new SpoonException("No value found for property '" + f.getName() + "' in processor " + p.getClass().getName());
            }
        }
    }
}

