/*
 * Decompiled with CFR 0.152.
 */
package sun.pitest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pitest.coverage.analysis.Block;
import sun.pitest.InvokeReceiver;

public final class CodeCoverageStore {
    private static final int CLASS_HIT_INDEX = 0;
    public static final String CLASS_NAME = CodeCoverageStore.class.getName().replace('.', '/');
    public static final String PROBE_METHOD_NAME = "visitProbes";
    private static InvokeReceiver invokeQueue;
    private static int classId;
    public static final String PROBE_FIELD_NAME = "$$pitCoverageProbes";
    public static final String PROBE_LENGTH_FIELD_NAME = "$$pitCoverageProbeSize";
    private static final Map<Integer, boolean[]> CLASS_HITS;

    public static void init(InvokeReceiver invokeQueue) {
        CodeCoverageStore.invokeQueue = invokeQueue;
    }

    private CodeCoverageStore() {
    }

    public static synchronized void reset() {
        for (Map.Entry<Integer, boolean[]> each : CLASS_HITS.entrySet()) {
            if (!each.getValue()[0]) continue;
            Arrays.fill(each.getValue(), false);
        }
    }

    public static synchronized Collection<Long> getHits() {
        ArrayList<Long> blockHits = new ArrayList<Long>();
        for (Map.Entry<Integer, boolean[]> each : CLASS_HITS.entrySet()) {
            boolean[] bs = each.getValue();
            if (!bs[0]) continue;
            int classId = each.getKey();
            for (int probeId = 1; probeId != bs.length; ++probeId) {
                if (!bs[probeId]) continue;
                blockHits.add(CodeCoverageStore.encode(classId, probeId));
            }
        }
        return blockHits;
    }

    public static int registerClass(String className) {
        int id = CodeCoverageStore.nextId();
        invokeQueue.registerClass(id, className);
        return id;
    }

    public static void registerMethod(int clazz, String methodName, String methodDesc, int firstProbe, int lastProbe, Iterable<Block> blocks) {
        invokeQueue.registerProbes(clazz, methodName, methodDesc, firstProbe, lastProbe, blocks);
    }

    private static synchronized int nextId() {
        return classId++;
    }

    public static int decodeClassId(long value) {
        return (int)(value >> 32);
    }

    public static int decodeLineId(long value) {
        return (int)value;
    }

    public static long encode(int classId, int line) {
        return (long)classId << 32 | (long)line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean[] getOrRegisterClassProbes(int classId, int probeCount) {
        boolean[] ret = CLASS_HITS.putIfAbsent(classId, new boolean[probeCount + 1]);
        if (ret == null) {
            return CLASS_HITS.get(classId);
        }
        if (ret.length < probeCount + 1) {
            Map<Integer, boolean[]> map = CLASS_HITS;
            synchronized (map) {
                ret = CLASS_HITS.get(classId);
                if (ret.length < probeCount + 1) {
                    ret = new boolean[probeCount + 1];
                    CLASS_HITS.put(classId, ret);
                    return ret;
                }
            }
        }
        return ret;
    }

    public static void resetAllStaticState() {
        CLASS_HITS.clear();
    }

    static {
        classId = 0;
        CLASS_HITS = new ConcurrentHashMap<Integer, boolean[]>();
    }
}

