/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.impl;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.RuntimeData;

public class CoveredTestResultPerTestMethodImpl
implements CoveredTestResultPerTestMethod {
    private static final long serialVersionUID = -789740001022671146L;
    protected final transient Map<String, ExecutionDataStore> executionDataStoreMap;
    protected final ConcurrentHashMap<String, Coverage> coverageResultsMap;
    protected final List<String> classesDirectory;
    protected transient RuntimeData data;
    protected transient ExecutionDataStore executionData;
    protected transient SessionInfoStore sessionInfos;
    protected transient CoverageTransformer coverageTransformer;
    private Set<String> runningTests;
    private Set<Failure> failingTests;
    private Set<Failure> assumptionFailingTests;
    private Set<String> ignoredTests;

    public CoveredTestResultPerTestMethodImpl(RuntimeData data, List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.data = data;
        this.classesDirectory = classesDirectory;
        this.executionDataStoreMap = new HashMap<String, ExecutionDataStore>();
        this.coverageResultsMap = new ConcurrentHashMap();
        this.coverageTransformer = coverageTransformer;
        this.runningTests = new HashSet<String>();
        this.failingTests = new HashSet<Failure>();
        this.assumptionFailingTests = new HashSet<Failure>();
        this.ignoredTests = new HashSet<String>();
    }

    public List<String> getClassesDirectory() {
        return this.classesDirectory;
    }

    public RuntimeData getData() {
        return this.data;
    }

    public ExecutionDataStore getExecutionData() {
        return this.executionData;
    }

    public SessionInfoStore getSessionInfos() {
        return this.sessionInfos;
    }

    public CoverageTransformer getCoverageTransformer() {
        return this.coverageTransformer;
    }

    public void setData(RuntimeData data) {
        this.data = data;
    }

    public void setExecutionData(ExecutionDataStore executionData) {
        this.executionData = executionData;
    }

    public void setSessionInfos(SessionInfoStore sessionInfos) {
        this.sessionInfos = sessionInfos;
    }

    public Map<String, ExecutionDataStore> getExecutionDataStoreMap() {
        return this.executionDataStoreMap;
    }

    @Override
    public void computeCoverages() {
        this.executionDataStoreMap.entrySet().parallelStream().forEach(x -> {
            Coverage jUnit4Coverage = this.coverageTransformer.transformJacocoObject((ExecutionDataStore)x.getValue(), this.classesDirectory);
            this.coverageResultsMap.put((String)x.getKey(), jUnit4Coverage);
        });
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.coverageResultsMap;
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.getCoverageResultsMap().get(testMethodName);
    }

    @Override
    public Set<String> getRunningTests() {
        return this.runningTests;
    }

    @Override
    public Set<String> getPassingTests() {
        HashSet<String> passingTests = new HashSet<String>(this.runningTests);
        passingTests.removeAll(this.failingTests.stream().map(x -> x.testCaseName).collect(Collectors.toSet()));
        passingTests.removeAll(this.assumptionFailingTests.stream().map(x -> x.testCaseName).collect(Collectors.toSet()));
        return passingTests;
    }

    @Override
    public TestResult aggregate(TestResult that) {
        if (that instanceof CoveredTestResultPerTestMethodImpl) {
            CoveredTestResultPerTestMethodImpl thatListener = (CoveredTestResultPerTestMethodImpl)that;
            this.runningTests.addAll(thatListener.runningTests);
            this.failingTests.addAll(thatListener.failingTests);
            this.assumptionFailingTests.addAll(thatListener.assumptionFailingTests);
            this.ignoredTests.addAll(thatListener.ignoredTests);
        }
        return this;
    }

    @Override
    public Set<Failure> getFailingTests() {
        return this.failingTests;
    }

    @Override
    public Set<Failure> getAssumptionFailingTests() {
        return this.assumptionFailingTests;
    }

    @Override
    public Set<String> getIgnoredTests() {
        return this.ignoredTests;
    }

    @Override
    public Failure getFailureOf(String testMethodName) {
        return this.getFailingTests().stream().filter(failure -> failure.testCaseName.equals(testMethodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find %s in failing test", testMethodName)));
    }

    @Override
    public void save() {
        ListenerUtils.saveToMemoryMappedFile(new File(OUTPUT_DIR, "CoveredTestResultPerTest.dat"), this);
    }

    public static CoveredTestResultPerTestMethodImpl load() {
        return (CoveredTestResultPerTestMethodImpl)ListenerUtils.loadFromMemoryMappedFile(ListenerUtils.computeTargetFilePath(OUTPUT_DIR, "CoveredTestResultPerTest.dat"));
    }

    public String toString() {
        return "CoveredTestResultPerTestMethodImpl{coverageResultsMap=" + this.coverageResultsMap.keySet().stream().map(test -> "\t" + test + ": " + this.coverageResultsMap.get(test).toString()).collect(Collectors.joining(ConstantsHelper.LINE_SEPARATOR)) + ", classesDirectory='" + this.classesDirectory + '\'' + ", data=" + this.data + ", executionData=" + this.executionData + ", sessionInfos=" + this.sessionInfos + ", coverageTransformer=" + this.coverageTransformer + ", runningTests=" + this.runningTests + ", failingTests=" + this.failingTests + ", assumptionFailingTests=" + this.assumptionFailingTests + ", ignoredTests=" + this.ignoredTests + '}';
    }
}

