/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.junit4;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoveragePerTestMethod;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.impl.CoverageImpl;
import eu.stamp_project.testrunner.listener.impl.CoveragePerTestMethodImpl;
import eu.stamp_project.testrunner.listener.junit4.JUnit4Coverage;
import eu.stamp_project.testrunner.listener.junit4.JUnit4TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.RuntimeData;
import org.junit.runner.Description;

public class CoveragePerJUnit4TestMethod
extends JUnit4TestResult
implements CoveragePerTestMethod {
    private static final long serialVersionUID = 8360711686354566769L;
    private CoveragePerTestMethodImpl internalCoverage;
    private Map<String, List<IClassCoverage>> coveragesPerMethodName;

    public CoveragePerJUnit4TestMethod(RuntimeData data, List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.internalCoverage = new CoveragePerTestMethodImpl(data, classesDirectory, coverageTransformer);
        this.coveragesPerMethodName = new HashMap<String, List<IClassCoverage>>();
    }

    public synchronized void testStarted(Description description) throws Exception {
        this.internalCoverage.setExecutionData(new ExecutionDataStore());
        this.internalCoverage.setSessionInfos(new SessionInfoStore());
        this.internalCoverage.getData().setSessionId((String)this.toString.apply(description));
        this.internalCoverage.getData().collect((IExecutionDataVisitor)this.internalCoverage.getExecutionData(), (ISessionInfoVisitor)this.internalCoverage.getSessionInfos(), true);
    }

    @Override
    public synchronized void testFinished(Description description) throws Exception {
        this.internalCoverage.getData().collect((IExecutionDataVisitor)this.internalCoverage.getExecutionData(), (ISessionInfoVisitor)this.internalCoverage.getSessionInfos(), false);
        this.internalCoverage.getExecutionDataStoreMap().put((String)this.toString.apply(description), ListenerUtils.cloneExecutionDataStore(this.internalCoverage.getExecutionData()));
        if (isParametrized.test(description.getMethodName())) {
            this.collectForParametrizedTest((String)this.toStringParametrized.apply(description));
        }
    }

    private void collectForParametrizedTest(String testMethodName) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.internalCoverage.getExecutionData(), (ICoverageVisitor)coverageBuilder);
        try {
            for (String directory : this.internalCoverage.getClassesDirectory()) {
                analyzer.analyzeAll(new File(directory));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.coveragesPerMethodName.containsKey(testMethodName)) {
            this.coveragesPerMethodName.put(testMethodName, new ArrayList());
        }
        coverageBuilder.getClasses().forEach(classCoverage -> this.coveragesPerMethodName.get(testMethodName).add((IClassCoverage)classCoverage));
    }

    public Map<String, List<IClassCoverage>> getCoveragesPerMethodName() {
        return this.coveragesPerMethodName;
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.internalCoverage.getCoverageResultsMap();
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.internalCoverage.getCoverageOf(testMethodName);
    }

    @Override
    public void save() {
        if (!this.coveragesPerMethodName.isEmpty()) {
            this.aggregateParametrizedTestCoverage();
        }
        this.internalCoverage.save();
    }

    private void aggregateParametrizedTestCoverage() {
        this.coveragesPerMethodName.keySet().forEach(testMethodName -> {
            int covered = 0;
            int total = 0;
            ArrayList<IClassCoverage> classCoverages = new ArrayList<IClassCoverage>((Collection)this.coveragesPerMethodName.get(testMethodName));
            while (!classCoverages.isEmpty()) {
                IClassCoverage current = (IClassCoverage)classCoverages.get(0);
                List<IClassCoverage> subListOnSameClass = this.getSameClassCoverage(current.getName(), classCoverages);
                List coveragePerMethods = subListOnSameClass.stream().map(coverage -> CoverageImpl.getListOfCountForCounterFunction(coverage, ICounter::getCoveredCount)).collect(Collectors.toList());
                List bestCoverage = IntStream.range(0, ((List)coveragePerMethods.get(0)).size()).boxed().map(index -> coveragePerMethods.stream().map(integers -> (Integer)integers.get((int)index)).max(Integer::compareTo).get()).collect(Collectors.toList());
                covered += bestCoverage.stream().mapToInt(Integer::intValue).sum();
                total += CoverageImpl.getListOfCountForCounterFunction(subListOnSameClass.get(0), ICounter::getTotalCount).stream().mapToInt(Integer::intValue).sum();
                classCoverages.removeAll(subListOnSameClass);
            }
            JUnit4Coverage value = new JUnit4Coverage(covered, total);
            value.setExecutionPath(this.internalCoverage.getCoverageResultsMap().keySet().stream().map(this.internalCoverage.getCoverageResultsMap()::get).map(Coverage::getExecutionPath).collect(Collectors.joining("#")));
            this.internalCoverage.getCoverageResultsMap().put((String)testMethodName, value);
        });
    }

    private List<IClassCoverage> getSameClassCoverage(String className, List<IClassCoverage> classCoverages) {
        return classCoverages.stream().filter(iClassCoverage -> className.equals(iClassCoverage.getName())).collect(Collectors.toList());
    }

    @Override
    public void computeCoverages() {
        this.internalCoverage.computeCoverages();
    }
}

