/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.junit5;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoveragePerTestMethod;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.impl.CoveragePerTestMethodImpl;
import eu.stamp_project.testrunner.listener.junit5.JUnit5TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.runner.Failure;
import java.util.List;
import java.util.Map;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.RuntimeData;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class CoveragePerJUnit5TestMethod
extends JUnit5TestResult
implements CoveragePerTestMethod {
    private static final long serialVersionUID = 8360711686354566769L;
    private CoveragePerTestMethodImpl internalCoverage;

    public CoveragePerJUnit5TestMethod(RuntimeData data, List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.internalCoverage = new CoveragePerTestMethodImpl(data, classesDirectory, coverageTransformer);
    }

    @Override
    public synchronized void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.internalCoverage.setExecutionData(new ExecutionDataStore());
            this.internalCoverage.setSessionInfos(new SessionInfoStore());
            this.internalCoverage.getData().setSessionId((String)this.toString.apply(testIdentifier));
            this.internalCoverage.getData().collect((IExecutionDataVisitor)this.internalCoverage.getExecutionData(), (ISessionInfoVisitor)this.internalCoverage.getSessionInfos(), true);
            this.getRunningTests().add((String)this.toString.apply(testIdentifier));
        }
    }

    @Override
    public synchronized void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            this.internalCoverage.getData().collect((IExecutionDataVisitor)this.internalCoverage.getExecutionData(), (ISessionInfoVisitor)this.internalCoverage.getSessionInfos(), false);
            this.internalCoverage.getExecutionDataStoreMap().put((String)this.toString.apply(testIdentifier), ListenerUtils.cloneExecutionDataStore(this.internalCoverage.getExecutionData()));
            switch (testExecutionResult.getStatus()) {
                case FAILED: {
                    this.getFailingTests().add(new Failure((String)this.toString.apply(testIdentifier), (String)this.toClassName.apply(testIdentifier), (Throwable)testExecutionResult.getThrowable().get()));
                    break;
                }
            }
        }
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.internalCoverage.getCoverageResultsMap();
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.internalCoverage.getCoverageOf(testMethodName);
    }

    @Override
    public void save() {
        this.internalCoverage.save();
    }

    @Override
    public void computeCoverages() {
        this.internalCoverage.computeCoverages();
    }
}

