/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.junit5;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.impl.CoveredTestResultPerTestMethodImpl;
import eu.stamp_project.testrunner.listener.junit5.JUnit5TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.runner.Failure;
import java.util.List;
import java.util.Map;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.RuntimeData;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestIdentifier;

public class CoveredTestResultsPerJUnit5TestMethod
extends JUnit5TestResult
implements CoveredTestResultPerTestMethod {
    private static final long serialVersionUID = 5003707306546430948L;
    private CoveredTestResultPerTestMethodImpl internalCoveredTestResult;

    public CoveredTestResultsPerJUnit5TestMethod(RuntimeData data, List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.internalCoveredTestResult = new CoveredTestResultPerTestMethodImpl(data, classesDirectory, coverageTransformer);
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (testIdentifier.isTest()) {
            this.internalCoveredTestResult.getIgnoredTests().add((String)this.toString.apply(testIdentifier));
        }
    }

    @Override
    public synchronized void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.internalCoveredTestResult.setExecutionData(new ExecutionDataStore());
            this.internalCoveredTestResult.setSessionInfos(new SessionInfoStore());
            this.internalCoveredTestResult.getData().setSessionId((String)this.toString.apply(testIdentifier));
            this.internalCoveredTestResult.getData().collect((IExecutionDataVisitor)this.internalCoveredTestResult.getExecutionData(), (ISessionInfoVisitor)this.internalCoveredTestResult.getSessionInfos(), true);
            this.internalCoveredTestResult.getRunningTests().add((String)this.toString.apply(testIdentifier));
        }
    }

    @Override
    public synchronized void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testIdentifier.isTest()) {
            this.internalCoveredTestResult.getData().collect((IExecutionDataVisitor)this.internalCoveredTestResult.getExecutionData(), (ISessionInfoVisitor)this.internalCoveredTestResult.getSessionInfos(), false);
            this.internalCoveredTestResult.getExecutionDataStoreMap().put((String)this.toString.apply(testIdentifier), ListenerUtils.cloneExecutionDataStore(this.internalCoveredTestResult.getExecutionData()));
            switch (testExecutionResult.getStatus()) {
                case FAILED: {
                    this.internalCoveredTestResult.getFailingTests().add(new Failure((String)this.toString.apply(testIdentifier), (String)this.toClassName.apply(testIdentifier), (Throwable)testExecutionResult.getThrowable().get()));
                    break;
                }
            }
        }
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.internalCoveredTestResult.getCoverageResultsMap();
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.internalCoveredTestResult.getCoverageOf(testMethodName);
    }

    @Override
    public void save() {
        this.internalCoveredTestResult.save();
    }

    @Override
    public void computeCoverages() {
        this.internalCoveredTestResult.computeCoverages();
    }
}

