/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.maven;

import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.junit4.JUnit4TestResult;
import eu.stamp_project.testrunner.runner.Failure;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SurefireReportsReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SurefireReportsReader.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public TestResult readAll(String pathToRootContainingReports) {
        File rootDirectory = new File(pathToRootContainingReports);
        if (!rootDirectory.exists()) {
            LOGGER.error("{} does not exists! Could not read the surefire reports.", (Object)pathToRootContainingReports);
        }
        return Arrays.stream((Object[])Objects.requireNonNull(rootDirectory.listFiles())).filter(file -> file.getName().startsWith("TEST-")).map(File::getAbsolutePath).map(this::read).reduce(TestResult::aggregate).get();
    }

    public TestResult read(String pathToSurefireReports) {
        try {
            JUnit4TestResult listener = new JUnit4TestResult();
            File fXmlFile = new File(pathToSurefireReports);
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(fXmlFile);
            doc.getDocumentElement().normalize();
            NodeList testCases = doc.getElementsByTagName("testcase");
            IntStream.range(0, testCases.getLength()).boxed().map(testCases::item).map(this::readTestCase).forEach(listener::aggregate);
            return listener;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private JUnit4TestResult readTestCase(Node testCase) {
        JUnit4TestResult listener = new JUnit4TestResult();
        String testClassName = testCase.getAttributes().getNamedItem("classname").getNodeValue();
        String testName = testCase.getAttributes().getNamedItem("name").getNodeValue();
        Description testDescription = Description.createTestDescription((String)testClassName, (String)testName, (Serializable)((Object)(testClassName + "#" + testName)));
        if (testCase.getFirstChild() != null && testCase.getFirstChild().getNextSibling() != null) {
            Node nextSibling = testCase.getFirstChild().getNextSibling();
            if ("skipped".equals(nextSibling.getNodeName())) {
                try {
                    listener.testIgnored(testDescription);
                    return listener;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if ("failure".equals(nextSibling.getNodeName())) {
                String stacktrace = nextSibling.getFirstChild().getNodeValue();
                String fullQualifiedNameOfException = stacktrace.split(LINE_SEPARATOR)[0];
                listener.getFailingTests().add(new Failure(testClassName + "#" + testName, testClassName, fullQualifiedNameOfException, "", stacktrace));
            }
        }
        try {
            listener.testFinished(testDescription);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return listener;
    }
}

