/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner;

import eu.stamp_project.testrunner.listener.junit5.JUnit5TestResult;
import eu.stamp_project.testrunner.runner.ParserOptions;
import java.util.Arrays;
import java.util.List;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;

public class JUnit5Runner {
    public static void main(String[] args) {
        JUnit5TestResult jUnit5TestResult = new JUnit5TestResult();
        ParserOptions options = ParserOptions.parse(args);
        JUnit5Runner.run(options.getFullQualifiedNameOfTestClassesToRun(), options.getTestMethodNamesToRun(), options.getBlackList(), jUnit5TestResult, JUnit5Runner.class.getClassLoader());
        jUnit5TestResult.save();
    }

    public static void run(String[] testClassNames, String[] testMethodNames, List<String> blackList, JUnit5TestResult listener, ClassLoader customClassLoader) {
        LauncherDiscoveryRequestBuilder requestBuilder = LauncherDiscoveryRequestBuilder.request();
        if (testMethodNames.length == 0) {
            if (testClassNames.length > 0) {
                Arrays.asList(testClassNames).forEach(testClassName -> {
                    try {
                        requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(customClassLoader.loadClass((String)testClassName))});
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                });
            } else {
                try {
                    requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(customClassLoader.loadClass(testClassNames[0]))});
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            Arrays.asList(testMethodNames).forEach(testMethodName -> {
                try {
                    if (!testMethodName.contains("#")) {
                        requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod(customClassLoader.loadClass(testClassNames[0]), (String)testMethodName)});
                    } else {
                        String className = testMethodName.split("#")[0];
                        String methodName = testMethodName.split("#")[1];
                        requestBuilder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod(customClassLoader.loadClass(className), (String)methodName)});
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        LauncherDiscoveryRequest request = requestBuilder.build();
        Launcher launcher = LauncherFactory.create();
        launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
        launcher.execute(request, new TestExecutionListener[0]);
    }
}

