/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner;

import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.impl.CoverageCollectorDetailed;
import eu.stamp_project.testrunner.listener.impl.CoverageCollectorDetailedCompressed;
import eu.stamp_project.testrunner.listener.impl.CoverageCollectorMethodDetailed;
import eu.stamp_project.testrunner.listener.impl.CoverageCollectorSummarization;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ParserOptions {
    private static final Function<String, List<String>> convertArrayToList = value -> Arrays.asList(value.split(ConstantsHelper.PATH_SEPARATOR));
    private List<String> pathToCompiledClassesOfTheProject = Collections.singletonList("");
    public static final String FLAG_pathToCompiledClassesOfTheProject = "--sourceBinaries";
    private static final String FLAG_HELP_pathToCompiledClassesOfTheProject = "This flag must be followed by the paths of source binaries. Paths must be separated by the system path separator, e.g. ':' on Linux";
    private List<String> pathToCompiledTestClassesOfTheProject = Collections.singletonList("");
    public static final String FLAG_pathToCompiledTestClassesOfTheProject = "--testBinaries";
    private static final String FLAG_HELP_pathToCompiledTestClassesOfTheProject = "This flag must be followed by the paths of test binaries. Paths must be separated by the system path separator, e.g. ':' on Linux";
    private String[] fullQualifiedNameOfTestClassesToRun = new String[0];
    public static final String FLAG_fullQualifiedNameOfTestClassToRun = "--class";
    public static final String FLAG_HELP_fullQualifiedNameOfTestClassToRun = "This flag must be followed by the full qualified names of test classes to be run. Names must be separated by the system path separator, e.g. ':' on Linux";
    private String[] testMethodNamesToRun = new String[0];
    public static final String FLAG_testMethodNamesToRun = "--tests";
    public static final String FLAG_HELP_testMethodNamesToRun = "This flag must be followed by the list of simple names of test methods to be run. Names must be separated by the system path separator, e.g. ':' on Linux";
    private List<String> blackList = new ArrayList<String>();
    public static final String FLAG_blackList = "--blacklist";
    public static final String FLAG_HELP_blackList = "This flag must be followed by the list of simple names of test methods to NOT be run. Names must be separated by the system path separator, e.g. ':' on Linux";
    private CoverageTransformerDetail coverageTransformerDetail = CoverageTransformerDetail.SUMMARIZED;
    public static final String FLAG_coverage_detail = "--coverage-detail";
    public static final String FLAG_HELP_coverage_detail = "The value following this flag defines the level of detail provided in the coverage information. Valid values:'SUMMARIZED' (default), 'DETAIL' or 'METHOD_DETAIL'.";

    public static ParserOptions parse(String[] args) {
        System.out.println(String.format("Parsing %s", String.join((CharSequence)" ", args)));
        ParserOptions parserOptions = new ParserOptions();
        block19: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "--sourceBinaries": {
                    parserOptions.pathToCompiledClassesOfTheProject = Arrays.stream(args[++i].split(ConstantsHelper.PATH_SEPARATOR)).collect(Collectors.toList());
                    continue block19;
                }
                case "--testBinaries": {
                    parserOptions.pathToCompiledTestClassesOfTheProject = Arrays.stream(args[++i].split(ConstantsHelper.PATH_SEPARATOR)).collect(Collectors.toList());
                    continue block19;
                }
                case "--class": {
                    parserOptions.fullQualifiedNameOfTestClassesToRun = args[++i].split(ConstantsHelper.PATH_SEPARATOR);
                    continue block19;
                }
                case "--tests": {
                    parserOptions.testMethodNamesToRun = args[++i].split(ConstantsHelper.PATH_SEPARATOR);
                    continue block19;
                }
                case "--blacklist": {
                    parserOptions.blackList = convertArrayToList.apply(args[++i]);
                    continue block19;
                }
                case "--coverage-detail": {
                    parserOptions.coverageTransformerDetail = CoverageTransformerDetail.valueOf(args[++i]);
                    continue block19;
                }
                case " ": 
                case "": {
                    continue block19;
                }
                default: {
                    System.err.println(String.format("[ERROR]: %s is not a supported command line options", args[i]));
                    ParserOptions.usage();
                }
            }
        }
        return parserOptions;
    }

    private static void usage() {
        StringBuilder usage = new StringBuilder();
        usage.append("Usage:").append(ConstantsHelper.LINE_SEPARATOR);
        usage.append(FLAG_pathToCompiledClassesOfTheProject).append(" ").append(FLAG_HELP_pathToCompiledClassesOfTheProject).append(ConstantsHelper.LINE_SEPARATOR);
        usage.append(FLAG_pathToCompiledTestClassesOfTheProject).append(" ").append(FLAG_HELP_pathToCompiledTestClassesOfTheProject).append(ConstantsHelper.LINE_SEPARATOR);
        usage.append(FLAG_fullQualifiedNameOfTestClassToRun).append(" ").append(FLAG_HELP_fullQualifiedNameOfTestClassToRun).append(ConstantsHelper.LINE_SEPARATOR);
        usage.append(FLAG_testMethodNamesToRun).append(" ").append(FLAG_HELP_testMethodNamesToRun).append(ConstantsHelper.LINE_SEPARATOR);
        usage.append(FLAG_blackList).append(" ").append(FLAG_HELP_blackList).append(ConstantsHelper.LINE_SEPARATOR);
        usage.append(FLAG_coverage_detail).append(" ").append(FLAG_HELP_coverage_detail).append(ConstantsHelper.LINE_SEPARATOR);
        System.out.println(usage.toString());
    }

    private ParserOptions() {
    }

    public List<String> getPathToCompiledClassesOfTheProject() {
        return this.pathToCompiledClassesOfTheProject;
    }

    public List<String> getPathToCompiledTestClassesOfTheProject() {
        return this.pathToCompiledTestClassesOfTheProject;
    }

    public String[] getFullQualifiedNameOfTestClassesToRun() {
        return this.fullQualifiedNameOfTestClassesToRun;
    }

    public String[] getTestMethodNamesToRun() {
        return this.testMethodNamesToRun;
    }

    public List<String> getBlackList() {
        return this.blackList;
    }

    public CoverageTransformer getCoverageTransformer() {
        switch (this.coverageTransformerDetail) {
            case DETAIL: {
                return new CoverageCollectorDetailed();
            }
            case METHOD_DETAIL: {
                return new CoverageCollectorMethodDetailed();
            }
            case DETAIL_COMPRESSED: {
                return new CoverageCollectorDetailedCompressed();
            }
        }
        return new CoverageCollectorSummarization();
    }

    public static enum CoverageTransformerDetail {
        SUMMARIZED,
        DETAIL,
        METHOD_DETAIL,
        DETAIL_COMPRESSED;

    }
}

