/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner.coverage;

import eu.stamp_project.testrunner.listener.CoveragePerTestMethod;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.runner.coverage.JacocoRunnerPerTestMethod;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jacoco.core.runtime.RuntimeData;

public abstract class JacocoRunnerCoveredResultPerTestMethod
extends JacocoRunnerPerTestMethod {
    public JacocoRunnerCoveredResultPerTestMethod(List<String> classesDirectory, List<String> testClassesDirectory, CoverageTransformer coverageTransformer) {
        super(classesDirectory, testClassesDirectory, coverageTransformer);
    }

    public JacocoRunnerCoveredResultPerTestMethod(List<String> classesDirectory, List<String> testClassesDirectory, List<String> blackList, CoverageTransformer coverageTransformer) {
        super(classesDirectory, testClassesDirectory, blackList, coverageTransformer);
    }

    public CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethod(List<String> classesDirectory, List<String> testClassesDirectory, String[] testClassNames, String[] testMethodNames) {
        RuntimeData data = new RuntimeData();
        URL[] dirs = (URL[])testClassesDirectory.stream().map(x -> {
            try {
                return new File((String)x).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(dirs, (ClassLoader)this.instrumentedClassLoader);
        try {
            for (String fullyQualifiedClassName : testClassNames) {
                String resource = ConstantsHelper.fullQualifiedNameToPath.apply(fullyQualifiedClassName) + ".class";
                this.instrumentedClassLoader.addDefinition(fullyQualifiedClassName, IOUtils.toByteArray((InputStream)classLoader.getResourceAsStream(resource)));
            }
            this.runtime.startup(data);
            CoveredTestResultPerTestMethod listener = this.executeCoveredTestPerTestMethod(data, classesDirectory, testClassNames, testMethodNames);
            if (!listener.getFailingTests().isEmpty()) {
                System.err.println("Some test(s) failed during computation of coverage:\n" + listener.getFailingTests().stream().map(Failure::toString).collect(Collectors.joining("\n")));
            }
            this.runtime.shutdown();
            ResourceBundle.clearCache(this.instrumentedClassLoader);
            return listener;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected CoveragePerTestMethod executeTestPerTestMethod(RuntimeData data, List<String> classesDirectory, String[] testClassNames, String[] testMethodNames) {
        throw new UnsupportedOperationException();
    }

    protected abstract CoveredTestResultPerTestMethod executeCoveredTestPerTestMethod(RuntimeData var1, List<String> var2, String[] var3, String[] var4);
}

