/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner.coverage;

import eu.stamp_project.testrunner.listener.CoveragePerTestMethod;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResult;
import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.runner.coverage.JacocoRunner;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jacoco.core.runtime.RuntimeData;

public abstract class JacocoRunnerPerTestMethod
extends JacocoRunner {
    public CoveragePerTestMethod runCoveragePerTestMethod(List<String> classesDirectory, List<String> testClassesDirectory, String[] testClassNames, String[] testMethodNames) {
        RuntimeData data = new RuntimeData();
        URL[] dirs = (URL[])testClassesDirectory.stream().map(x -> {
            try {
                return new File((String)x).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(dirs, (ClassLoader)this.instrumentedClassLoader);
        try {
            for (String fullyQualifiedClassName : testClassNames) {
                String resource = ConstantsHelper.fullQualifiedNameToPath.apply(fullyQualifiedClassName) + ".class";
                this.instrumentedClassLoader.addDefinition(fullyQualifiedClassName, IOUtils.toByteArray((InputStream)classLoader.getResourceAsStream(resource)));
            }
            this.runtime.startup(data);
            CoveragePerTestMethod listener = this.executeTestPerTestMethod(data, classesDirectory, testClassNames, testMethodNames);
            if (!((TestResult)((Object)listener)).getFailingTests().isEmpty()) {
                System.err.println("Some test(s) failed during computation of coverage:\n" + ((TestResult)((Object)listener)).getFailingTests().stream().map(Failure::toString).collect(Collectors.joining("\n")));
            }
            this.runtime.shutdown();
            ResourceBundle.clearCache(this.instrumentedClassLoader);
            return listener;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected CoveredTestResult executeTest(String[] testClassNames, String[] testMethodNames, List<String> blackList) {
        throw new UnsupportedOperationException();
    }

    protected abstract CoveragePerTestMethod executeTestPerTestMethod(RuntimeData var1, List<String> var2, String[] var3, String[] var4);

    public JacocoRunnerPerTestMethod(List<String> classesDirectory, List<String> testClassesDirectory, CoverageTransformer coverageTransformer) {
        super(classesDirectory, testClassesDirectory, coverageTransformer);
    }

    public JacocoRunnerPerTestMethod(List<String> classesDirectory, List<String> testClassesDirectory, List<String> blackList, CoverageTransformer coverageTransformer) {
        super(classesDirectory, testClassesDirectory, blackList, coverageTransformer);
    }
}

