/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner.pit;

import eu.stamp_project.testrunner.EntryPoint;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.testapi.TestGroupConfig;

public class PitRunner {
    private static final String JUNIT4_TEST_PLUGIN = "junit";
    private static final String JUNIT5_TEST_PLUGIN = "junit5";
    public static final String REPORT_PITS = "target/report-pits/";

    public static void main(String[] args) {
        String classpath = args[0];
        String pathRootProject = args[1];
        String filterTargetClasses = args[2];
        String targetTest = args[3];
        String outputFormat = args[4];
        String mutationEngine = args[5];
        List<String> mutators = args.length == 7 ? Arrays.asList(args[6].split(ConstantsHelper.PATH_SEPARATOR)) : Collections.singletonList("");
        ReportOptions options = PitRunner.createReportOptions(classpath, pathRootProject, filterTargetClasses, targetTest, mutators, mutationEngine, outputFormat);
        SettingsFactory settingsFactory = PitRunner.createSettingFactory(classpath, options);
        org.pitest.mutationtest.tooling.EntryPoint e = new org.pitest.mutationtest.tooling.EntryPoint();
        e.execute(new File(pathRootProject), options, settingsFactory, Collections.emptyMap());
    }

    private static ReportOptions createReportOptions(String classpath, String pathRootProject, String filterTargetClasses, String targetTest, List<String> mutators, String mutationEngine, String outputFormat) {
        ReportOptions data = new ReportOptions();
        List<String> classpathList = Arrays.asList(classpath.split(":"));
        data.setClassPathElements(classpathList);
        data.setDependencyAnalysisMaxDistance(-1);
        data.setTargetClasses(Collections.singletonList(filterTargetClasses));
        data.setTargetTests(Collections.singletonList(toBeMatched -> Pattern.compile(targetTest).matcher((CharSequence)toBeMatched).matches()));
        data.setReportDir(pathRootProject + REPORT_PITS);
        data.setVerbose(true);
        data.setMutators(mutators);
        data.setSourceDirs(Collections.singletonList(new File(pathRootProject)));
        data.addOutputFormats(Collections.singletonList(outputFormat));
        TestGroupConfig testGroupConfig = new TestGroupConfig(Collections.emptyList(), Collections.emptyList());
        data.setGroupConfig(testGroupConfig);
        data.setExportLineCoverage(true);
        data.setMutationEngine(mutationEngine);
        data.setTestPlugin(EntryPoint.jUnit5Mode ? JUNIT5_TEST_PLUGIN : JUNIT4_TEST_PLUGIN);
        return data;
    }

    private static SettingsFactory createSettingFactory(String classpath, ReportOptions options) {
        URL[] urls = (URL[])Arrays.stream(classpath.split(":")).map(File::new).map(file -> {
            try {
                return file.toURI().toURL();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(urls);
        return new SettingsFactory(options, new PluginServices((ClassLoader)classLoader));
    }
}

