/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework.implementations.junit;

import eu.stamp_project.testrunner.test_framework.implementations.junit.JUnitSupport;
import java.util.HashMap;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtTypeReference;

public class JUnit4Support
extends JUnitSupport {
    public static int timeOutInMs = 0;

    public JUnit4Support() {
        super("org.junit.Assert");
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationAfterClass() {
        return "org.junit.AfterClass";
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationTest() {
        return "org.junit.Test";
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationIgnore() {
        return "org.junit.Ignore";
    }

    @Override
    public CtMethod<?> prepareTestMethod(CtMethod<?> testMethod) {
        CtMethod<?> clone = super.prepareTestMethod(testMethod);
        Factory factory = testMethod.getFactory();
        CtAnnotation testAnnotation = clone.getAnnotations().stream().filter(annotation -> annotation.toString().contains("Test")).findFirst().orElse(null);
        if (testAnnotation != null) {
            HashMap<String, CtLiteral> values = new HashMap<String, CtLiteral>(testAnnotation.getValues());
            CtExpression originalTimeout = (CtExpression)values.get("timeout");
            if (originalTimeout == null || originalTimeout instanceof CtLiteral && ((CtLiteral)originalTimeout).getValue().equals(0L)) {
                values.put("timeout", factory.createLiteral((Object)timeOutInMs));
            } else {
                int valueOriginalTimeout;
                if (originalTimeout.toString().endsWith("L")) {
                    String stringTimeout = originalTimeout.toString();
                    valueOriginalTimeout = Math.toIntExact(Long.parseLong(stringTimeout.substring(0, stringTimeout.length() - 1)));
                } else {
                    valueOriginalTimeout = Integer.parseInt(originalTimeout.toString());
                }
                if (valueOriginalTimeout < timeOutInMs) {
                    CtLiteral newTimeout = factory.createLiteral((Object)timeOutInMs);
                    values.put("timeout", newTimeout);
                }
            }
            values.remove("expected");
            testAnnotation.setValues(values);
        } else {
            CtAnnotation newTestAnnotation = factory.Core().createAnnotation();
            CtTypeReference ref = factory.Core().createTypeReference();
            ref.setSimpleName("Test");
            CtPackageReference refPackage = factory.Core().createPackageReference();
            refPackage.setSimpleName("org.junit");
            ref.setPackage(refPackage);
            newTestAnnotation.setAnnotationType(ref);
            HashMap<String, Integer> elementValue = new HashMap<String, Integer>();
            elementValue.put("timeout", timeOutInMs);
            newTestAnnotation.setElementValues(elementValue);
            clone.addAnnotation(newTestAnnotation);
        }
        return clone;
    }
}

