/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework.implementations.junit;

import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.test_framework.implementations.junit.JUnitSupport;
import java.util.Arrays;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtLambda;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.reference.CtVariableReference;

public class JUnit5Support
extends JUnitSupport {
    public JUnit5Support() {
        super("org.junit.jupiter.api.Assertions");
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationAfterClass() {
        return "org.junit.jupiter.api.AfterAll";
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationTest() {
        return "org.junit.jupiter.api.Test";
    }

    @Override
    protected String getFullQualifiedNameOfAnnotationIgnore() {
        return "org.junit.jupiter.api.Disabled";
    }

    @Override
    public CtMethod<?> generateExpectedExceptionsBlock(CtMethod<?> test, Failure failure, int numberOfFail) {
        Factory factory = test.getFactory();
        CtLambda lambda = factory.createLambda();
        lambda.setBody((CtStatement)test.getBody());
        CtInvocation invocation = factory.createInvocation();
        CtExecutableReference executableReference = factory.Core().createExecutableReference();
        executableReference.setStatic(true);
        executableReference.setSimpleName("assertThrows");
        executableReference.setDeclaringType(factory.Type().createReference(this.qualifiedNameOfAssertClass));
        invocation.setExecutable(executableReference);
        invocation.setType(factory.Type().voidPrimitiveType());
        invocation.setTarget((CtExpression)factory.createTypeAccess(factory.Type().createReference(this.qualifiedNameOfAssertClass)));
        CtTypeReference ctTypeOfException = factory.Type().createReference(failure.fullQualifiedNameOfException);
        CtFieldRead fieldRead = factory.createFieldRead();
        fieldRead.setTarget((CtExpression)factory.createTypeAccess(ctTypeOfException));
        CtFieldReference fieldReference = factory.createFieldReference();
        fieldReference.setDeclaringType(ctTypeOfException);
        fieldReference.setSimpleName("class");
        fieldRead.setVariable((CtVariableReference)fieldReference);
        invocation.setArguments(Arrays.asList(fieldRead, lambda));
        CtBlock body = factory.Core().createBlock();
        body.addStatement((CtStatement)invocation);
        test.setBody((CtStatement)body);
        test.setSimpleName(test.getSimpleName() + "_failAssert" + numberOfFail);
        return test;
    }
}

