/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner;

import eu.stamp_project.mutationtest.descartes.DescartesMutationEngine;
import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoveragePerTestMethod;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.impl.CoverageImpl;
import eu.stamp_project.testrunner.listener.impl.CoveragePerTestMethodImpl;
import eu.stamp_project.testrunner.listener.impl.CoveredTestResultPerTestMethodImpl;
import eu.stamp_project.testrunner.listener.impl.OnlineCoveredTestResultPerTestMethodImpl;
import eu.stamp_project.testrunner.listener.impl.TestResultImpl;
import eu.stamp_project.testrunner.listener.pit.AbstractParser;
import eu.stamp_project.testrunner.listener.pit.AbstractPitResult;
import eu.stamp_project.testrunner.runner.ParserOptions;
import eu.stamp_project.testrunner.runner.pit.PitRunner;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jacoco.agent.rt.RT;
import org.jacoco.core.runtime.IRuntime;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.objectweb.asm.ClassReader;
import org.opentest4j.TestAbortedException;
import org.pitest.junit5.JUnit5Configuration;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.engine.gregor.GregorMutationEngine;
import org.pitest.testapi.TestGroupConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPoint {
    public static boolean jUnit5Mode = false;
    public static boolean verbose = false;
    public static int timeoutInMs = 10000;
    public static File workingDirectory = null;
    public static String JVMArgs = null;
    public static PrintStream outPrintStream = null;
    public static PrintStream errPrintStream = null;
    public static boolean persistence = true;
    public static List<String> blackList = new ArrayList<String>();
    public static ParserOptions.CoverageTransformerDetail coverageDetail = ParserOptions.CoverageTransformerDetail.SUMMARIZED;
    public static String jacocoAgentIncludes;
    public static String jacocoAgentExcludes;
    private static ConstantsHelper.MutationEngine mutationEngine;
    public static List<String> pitMutators;
    public static AbstractParser.OutputFormat pitOutputFormat;
    private static final Logger LOGGER;
    private static final String JAVA_COMMAND = "java";
    private static final String CLASSPATH_OPT = "-classpath";
    private static final String JUNIT4_TEST_RUNNER_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.JUnit4Runner";
    private static final String JUNIT5_TEST_RUNNER_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.JUnit5Runner";
    private static final String JUNIT4_JACOCO_RUNNER_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit4JacocoRunner";
    private static final String JUNIT5_JACOCO_RUNNER_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit5JacocoRunner";
    private static final String JUNIT4_JACOCO_RUNNER_PER_TEST_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit4JacocoRunnerPerTestMethod";
    private static final String JUNIT5_JACOCO_RUNNER_PER_TEST_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit5JacocoRunnerPerTestMethod";
    private static final String JUNIT4_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit4JacocoRunnerCoveredResultPerTestMethod";
    private static final String JUNIT5_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit5JacocoRunnerCoveredResultPerTestMethod";
    private static final String JUNIT4_ONLINE_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit4OnlineJacocoRunner";
    private static final String JUNIT5_ONLINE_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME = "eu.stamp_project.testrunner.runner.coverage.JUnit5OnlineJacocoRunner";
    private static final String ABSOLUTE_PATH_TO_RUNNER_CLASSES;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final Function<List<Class<?>>, String> CLASSES_TO_PATH_OF_DEPENDENCIES;
    private static final List<Class<?>> JACOCO_DEPENDENCIES;
    private static final String ABSOLUTE_PATH_TO_JACOCO_DEPENDENCIES;
    private static final List<Class<?>> PIT_DEPENDENCIES;
    private static final List<Class<?>> PIT_DEPENDENCIES_FOR_JUNIT5;
    private static final String ABSOLUTE_PATH_TO_PIT_DEPENDENCIES;
    private static final String ABSOLUTE_PATH_TO_PIT_DEPENDENCIES_FOR_JUNIT5;

    public static void setMutationEngine(ConstantsHelper.MutationEngine mutationEngine) {
        EntryPoint.mutationEngine = mutationEngine;
        pitMutators = mutationEngine.mutators;
    }

    public static TestResult runTests(String classpath, String fullQualifiedNameOfTestClass) throws TimeoutException {
        return EntryPoint.runTests(classpath, new String[]{fullQualifiedNameOfTestClass}, new String[0]);
    }

    public static TestResult runTests(String classpath, String[] fullQualifiedNameOfTestClasses) throws TimeoutException {
        return EntryPoint.runTests(classpath, fullQualifiedNameOfTestClasses, new String[0]);
    }

    public static TestResult runTests(String classpath, String fullQualifiedNameOfTestClass, String methodName) throws TimeoutException {
        return EntryPoint.runTests(classpath, new String[]{fullQualifiedNameOfTestClass}, new String[]{methodName});
    }

    public static TestResult runTests(String classpath, String fullQualifiedNameOfTestClass, String[] methodNames) throws TimeoutException {
        return EntryPoint.runTests(classpath, new String[]{fullQualifiedNameOfTestClass}, methodNames);
    }

    public static TestResult runTests(String classpath, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        String javaCommand = String.join((CharSequence)" ", EntryPoint.getJavaCommand(), (classpath + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_RUNNER_CLASSES).replaceAll(" ", "%20"), jUnit5Mode ? JUNIT5_TEST_RUNNER_QUALIFIED_NAME : JUNIT4_TEST_RUNNER_QUALIFIED_NAME, "--class", String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, fullQualifiedNameOfTestClasses), methodNames.length == 0 ? "" : "--tests " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, methodNames), blackList.isEmpty() ? "" : "--blacklist " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, blackList));
        return EntryPoint.runTests(javaCommand);
    }

    private static TestResult runTests(String commandLine) throws TimeoutException {
        try {
            EntryPoint.runGivenCommandLine(commandLine);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout when running {}", (Object)commandLine);
            throw e;
        }
        TestResult load = TestResultImpl.load();
        if (verbose) {
            LOGGER.debug("Test has been run: {}", (Object)Stream.concat(load.getPassingTests().stream().map(Object::toString), load.getFailingTests().stream().map(Object::toString)).collect(Collectors.joining(",")));
        }
        return load;
    }

    public static Coverage runCoverage(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass) throws TimeoutException {
        return EntryPoint.runCoverage(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[0]);
    }

    public static Coverage runCoverage(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses) throws TimeoutException {
        return EntryPoint.runCoverage(classpath, targetProjectClasses, fullQualifiedNameOfTestClasses, new String[0]);
    }

    public static Coverage runCoverage(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String[] methodNames) throws TimeoutException {
        return EntryPoint.runCoverage(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, methodNames);
    }

    public static Coverage runCoverage(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        return EntryPoint.runCoverage(classpath, Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[0]), Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[1]), fullQualifiedNameOfTestClasses, methodNames);
    }

    public static Coverage runCoverage(String classpath, List<String> targetSourceClasses, List<String> targetTestClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        String javaCommand = String.join((CharSequence)" ", EntryPoint.getJavaCommand(), (classpath + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_RUNNER_CLASSES + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_JACOCO_DEPENDENCIES).replaceAll(" ", "%20"), jUnit5Mode ? JUNIT5_JACOCO_RUNNER_QUALIFIED_NAME : JUNIT4_JACOCO_RUNNER_QUALIFIED_NAME, "--sourceBinaries", ((String)targetSourceClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--testBinaries", ((String)targetTestClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--class", String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, fullQualifiedNameOfTestClasses), methodNames.length == 0 ? "" : "--tests " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, methodNames), blackList.isEmpty() ? "" : "--blacklist " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, blackList), coverageDetail == ParserOptions.CoverageTransformerDetail.SUMMARIZED ? "" : "--coverage-detail " + coverageDetail.name());
        return EntryPoint.runCoverage(javaCommand);
    }

    public static CoveragePerTestMethod runCoveragePerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass) throws TimeoutException {
        return EntryPoint.runCoveragePerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[0]);
    }

    public static CoveragePerTestMethod runCoveragePerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String testMethodName) throws TimeoutException {
        return EntryPoint.runCoveragePerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[]{testMethodName});
    }

    public static CoveragePerTestMethod runCoveragePerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String[] testMethodNames) throws TimeoutException {
        return EntryPoint.runCoveragePerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, testMethodNames);
    }

    public static CoveragePerTestMethod runCoveragePerTestMethods(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses) throws TimeoutException {
        return EntryPoint.runCoveragePerTestMethods(classpath, targetProjectClasses, fullQualifiedNameOfTestClasses, new String[0]);
    }

    private static Coverage runCoverage(String commandLine) throws TimeoutException {
        try {
            EntryPoint.runGivenCommandLine(commandLine);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout when running {}", (Object)commandLine);
            throw e;
        }
        Coverage load = CoverageImpl.load();
        if (verbose) {
            LOGGER.debug("Global coverage has been computed {}", (Object)load.toString());
        }
        return load;
    }

    public static CoveragePerTestMethod runCoveragePerTestMethods(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        return EntryPoint.runCoveragePerTestMethods(classpath, Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[0]), Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[1]), fullQualifiedNameOfTestClasses, methodNames);
    }

    public static CoveragePerTestMethod runCoveragePerTestMethods(String classpath, List<String> targetSourceClasses, List<String> targetTestClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        String javaCommand = String.join((CharSequence)" ", EntryPoint.getJavaCommand(), (classpath + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_RUNNER_CLASSES + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_JACOCO_DEPENDENCIES).replaceAll(" ", "%20"), jUnit5Mode ? JUNIT5_JACOCO_RUNNER_PER_TEST_QUALIFIED_NAME : JUNIT4_JACOCO_RUNNER_PER_TEST_QUALIFIED_NAME, "--sourceBinaries", ((String)targetSourceClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--testBinaries", ((String)targetTestClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--class", String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, fullQualifiedNameOfTestClasses), methodNames.length == 0 ? "" : "--tests " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, methodNames), blackList.isEmpty() ? "" : "--blacklist " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, blackList), coverageDetail == ParserOptions.CoverageTransformerDetail.SUMMARIZED ? "" : "--coverage-detail " + coverageDetail.name());
        try {
            EntryPoint.runGivenCommandLine(javaCommand);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout when running {}", (Object)javaCommand);
            throw e;
        }
        CoveragePerTestMethodImpl load = CoveragePerTestMethodImpl.load();
        if (verbose) {
            LOGGER.debug("Coverage per test methods has been computed {}{}", (Object)ConstantsHelper.LINE_SEPARATOR, (Object)((Object)load).toString());
        }
        return load;
    }

    public static CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass) throws TimeoutException {
        return EntryPoint.runCoveredTestResultPerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[0]);
    }

    public static CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String testMethodName) throws TimeoutException {
        return EntryPoint.runCoveredTestResultPerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[]{testMethodName});
    }

    public static CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String[] testMethodNames) throws TimeoutException {
        return EntryPoint.runCoveredTestResultPerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, testMethodNames);
    }

    public static CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses) throws TimeoutException {
        return EntryPoint.runCoveredTestResultPerTestMethods(classpath, targetProjectClasses, fullQualifiedNameOfTestClasses, new String[0]);
    }

    public static CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        return EntryPoint.runCoveredTestResultPerTestMethods(classpath, Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[0]), Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[1]), fullQualifiedNameOfTestClasses, methodNames);
    }

    public static CoveredTestResultPerTestMethod runCoveredTestResultPerTestMethods(String classpath, List<String> targetSourceClasses, List<String> targetTestClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        String javaCommand = String.join((CharSequence)" ", EntryPoint.getJavaCommand(), (classpath + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_RUNNER_CLASSES + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_JACOCO_DEPENDENCIES).replaceAll(" ", "%20"), jUnit5Mode ? JUNIT5_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME : JUNIT4_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME, "--sourceBinaries", ((String)targetSourceClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--testBinaries", ((String)targetTestClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--class", String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, fullQualifiedNameOfTestClasses), methodNames.length == 0 ? "" : "--tests " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, methodNames), blackList.isEmpty() ? "" : "--blacklist " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, blackList), coverageDetail == ParserOptions.CoverageTransformerDetail.SUMMARIZED ? "" : "--coverage-detail " + coverageDetail.name());
        try {
            EntryPoint.runGivenCommandLine(javaCommand);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout when running {}", (Object)javaCommand);
            throw e;
        }
        CoveredTestResultPerTestMethodImpl load = CoveredTestResultPerTestMethodImpl.load();
        if (verbose) {
            LOGGER.debug("Coverage per test methods has been computed {}{}", (Object)ConstantsHelper.LINE_SEPARATOR, (Object)((Object)load).toString());
        }
        return load;
    }

    public static CoveredTestResultPerTestMethod runOnlineCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass) throws TimeoutException {
        return EntryPoint.runOnlineCoveredTestResultPerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[0]);
    }

    public static CoveredTestResultPerTestMethod runOnlineCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String testMethodName) throws TimeoutException {
        return EntryPoint.runOnlineCoveredTestResultPerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, new String[]{testMethodName});
    }

    public static CoveredTestResultPerTestMethod runOnlineCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String fullQualifiedNameOfTestClass, String[] testMethodNames) throws TimeoutException {
        return EntryPoint.runOnlineCoveredTestResultPerTestMethods(classpath, targetProjectClasses, new String[]{fullQualifiedNameOfTestClass}, testMethodNames);
    }

    public static CoveredTestResultPerTestMethod runOnlineCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses) throws TimeoutException {
        return EntryPoint.runOnlineCoveredTestResultPerTestMethods(classpath, targetProjectClasses, fullQualifiedNameOfTestClasses, new String[0]);
    }

    public static CoveredTestResultPerTestMethod runOnlineCoveredTestResultPerTestMethods(String classpath, String targetProjectClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        return EntryPoint.runOnlineCoveredTestResultPerTestMethods(classpath, Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[0]), Collections.singletonList(targetProjectClasses.split(ConstantsHelper.PATH_SEPARATOR)[1]), fullQualifiedNameOfTestClasses, methodNames);
    }

    public static CoveredTestResultPerTestMethod runOnlineCoveredTestResultPerTestMethods(String classpath, List<String> targetSourceClasses, List<String> targetTestClasses, String[] fullQualifiedNameOfTestClasses, String[] methodNames) throws TimeoutException {
        File jacocoAgentJar;
        try {
            InputStream is = EntryPoint.class.getClassLoader().getResourceAsStream("jacocoagent.jar");
            jacocoAgentJar = File.createTempFile("test-runner", "jacoco-agent");
            jacocoAgentJar.deleteOnExit();
            FileOutputStream os = new FileOutputStream(jacocoAgentJar);
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String javaCommand = String.join((CharSequence)" ", EntryPoint.getJavaCommand(), (classpath + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_RUNNER_CLASSES + ConstantsHelper.PATH_SEPARATOR + ABSOLUTE_PATH_TO_JACOCO_DEPENDENCIES).replaceAll(" ", "%20"), "-javaagent:" + jacocoAgentJar.getAbsolutePath() + "=destfile=test-runner.exec,dumponexit=false" + (jacocoAgentIncludes != null ? ",includes=" + jacocoAgentIncludes : "") + (jacocoAgentIncludes != null ? ",excludes=" + jacocoAgentExcludes : ""), jUnit5Mode ? JUNIT5_ONLINE_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME : JUNIT4_ONLINE_JACOCO_RUNNER_COVERED_RESULT_PER_TEST_QUALIFIED_NAME, "--sourceBinaries", ((String)targetSourceClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--testBinaries", ((String)targetTestClasses.stream().reduce((x, y) -> x + ConstantsHelper.PATH_SEPARATOR + y).get()).replaceAll(" ", "%20"), "--class", String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, fullQualifiedNameOfTestClasses), methodNames.length == 0 ? "" : "--tests " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, methodNames), blackList.isEmpty() ? "" : "--blacklist " + String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, blackList), coverageDetail == ParserOptions.CoverageTransformerDetail.SUMMARIZED ? "" : "--coverage-detail " + coverageDetail.name());
        try {
            EntryPoint.runGivenCommandLine(javaCommand);
        }
        catch (TimeoutException e) {
            LOGGER.warn("Timeout when running {}", (Object)javaCommand);
            throw e;
        }
        new File(workingDirectory, "test-runner.exec").delete();
        OnlineCoveredTestResultPerTestMethodImpl load = OnlineCoveredTestResultPerTestMethodImpl.load();
        if (verbose) {
            LOGGER.debug("Coverage per test methods has been computed {}{}", (Object)ConstantsHelper.LINE_SEPARATOR, (Object)((Object)load).toString());
        }
        return load;
    }

    public static List<? extends AbstractPitResult> runPit(String classpath, String pathToRootProject, String filterTargetClasses, String targetTests) {
        String classpathToExecute = jUnit5Mode ? String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, classpath, ABSOLUTE_PATH_TO_PIT_DEPENDENCIES, ABSOLUTE_PATH_TO_PIT_DEPENDENCIES_FOR_JUNIT5) : String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, classpath, ABSOLUTE_PATH_TO_PIT_DEPENDENCIES);
        PitRunner.main(new String[]{classpathToExecute, pathToRootProject, filterTargetClasses, targetTests, pitOutputFormat.name().toLowerCase(), mutationEngine.name().toLowerCase(), String.join((CharSequence)ConstantsHelper.PATH_SEPARATOR, pitMutators)});
        return AbstractParser.build(pitOutputFormat).parseAndDelete(pathToRootProject + "target/report-pits/");
    }

    private static void runGivenCommandLine(String commandLine) throws TimeoutException {
        List<String> command = Arrays.asList(commandLine.split(" "));
        command = command.stream().map(s -> s.replaceAll("%20", " ")).collect(Collectors.toList());
        if (verbose) {
            LOGGER.debug("Run: {}", command);
        }
        if (workingDirectory != null && !workingDirectory.exists()) {
            LOGGER.warn("The specified working directory does not exist: {}.{} Inherit from this process: {}. Reset workingDirectory variable.", (Object)workingDirectory.getAbsolutePath(), (Object)new File(".").getAbsolutePath());
            workingDirectory = null;
        }
        Process process = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(command);
            if (workingDirectory != null) {
                pb.directory(workingDirectory);
            }
            if (verbose) {
                if (outPrintStream != null) {
                    pb.redirectOutput(ProcessBuilder.Redirect.PIPE);
                    pb.redirectError(ProcessBuilder.Redirect.PIPE);
                } else {
                    pb.inheritIO();
                }
            } else {
                pb.redirectOutput(File.createTempFile("test-runner-error", ".tmp")).redirectErrorStream(true);
            }
            process = pb.start();
            if (verbose && outPrintStream != null) {
                EntryPoint.inheritIO(process.getInputStream(), outPrintStream);
                EntryPoint.inheritIO(process.getErrorStream(), outPrintStream);
            }
            long startTime = System.currentTimeMillis();
            boolean finished = process.waitFor(timeoutInMs, TimeUnit.MILLISECONDS);
            long endTime = System.currentTimeMillis();
            if (!finished) {
                throw new RuntimeException("Forked process did not finish correctly. Timeout set was " + timeoutInMs + " ms, process took " + (endTime - startTime) + " ms before ending.");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (process != null) {
                process.destroyForcibly();
            }
            if (!persistence) {
                EntryPoint.reset();
            }
        }
    }

    private static void inheritIO(final InputStream src, final PrintStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    dest.println(sc.nextLine());
                }
                sc.close();
            }
        }).start();
    }

    private static void reset() {
        JVMArgs = null;
        workingDirectory = null;
        timeoutInMs = 10000;
        outPrintStream = null;
        errPrintStream = null;
        blackList.clear();
        jacocoAgentIncludes = null;
        jacocoAgentExcludes = null;
    }

    static String getJavaCommand() {
        if (JVMArgs != null && !JVMArgs.isEmpty()) {
            return "java " + JVMArgs + " " + CLASSPATH_OPT;
        }
        return "java -classpath";
    }

    private static String RemoveWinFileSeparator(String string) {
        if (!"/".equals(ConstantsHelper.FILE_SEPARATOR) && string.startsWith(ConstantsHelper.FILE_SEPARATOR)) {
            return string.substring(1);
        }
        return string;
    }

    private static String initAbsolutePathToRunnerClasses() {
        String path;
        URL resource = ClassLoader.getSystemClassLoader().getResource("runner-classes/");
        if (resource == null) {
            resource = EntryPoint.class.getClassLoader().getResource("runner-classes/");
        }
        if (resource == null) {
            try {
                Class<?> aClass = EntryPoint.class.getClassLoader().getClass();
                Method findResources = aClass.getMethod("findResource", String.class);
                resource = (URL)findResources.invoke((Object)EntryPoint.class.getClassLoader(), "runner-classes/");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((path = resource.getPath()).contains("!") && path.startsWith("file:")) {
            path = path.substring("file:".length()).split("!")[0];
        }
        path = EntryPoint.RemoveWinFileSeparator(path.replace("/", ConstantsHelper.FILE_SEPARATOR));
        LOGGER.debug("Path to runner Classes: {}", (Object)path);
        return path;
    }

    static {
        mutationEngine = ConstantsHelper.MutationEngine.DESCARTES;
        pitMutators = EntryPoint.mutationEngine.mutators;
        pitOutputFormat = AbstractParser.OutputFormat.XML;
        LOGGER = LoggerFactory.getLogger(EntryPoint.class);
        ABSOLUTE_PATH_TO_RUNNER_CLASSES = EntryPoint.initAbsolutePathToRunnerClasses();
        CLASSES_TO_PATH_OF_DEPENDENCIES = classes -> classes.stream().map(clazz -> clazz.getProtectionDomain().getCodeSource().getLocation()).map(URL::getPath).map(path -> path.startsWith("file:") ? path.substring("file:".length()) : path).map(path -> path.split("!")[0]).map(path -> path.replace("/", ConstantsHelper.FILE_SEPARATOR)).map(EntryPoint::RemoveWinFileSeparator).peek(path -> LOGGER.debug("{}", path)).collect(Collectors.joining(ConstantsHelper.PATH_SEPARATOR));
        JACOCO_DEPENDENCIES = Arrays.asList(IRuntime.class, RT.class, FileUtils.class, ClassReader.class);
        ABSOLUTE_PATH_TO_JACOCO_DEPENDENCIES = CLASSES_TO_PATH_OF_DEPENDENCIES.apply(JACOCO_DEPENDENCIES);
        PIT_DEPENDENCIES = Arrays.asList(GregorMutationEngine.class, TestGroupConfig.class, PluginServices.class, DescartesMutationEngine.class);
        PIT_DEPENDENCIES_FOR_JUNIT5 = Arrays.asList(JUnit5Configuration.class, ExtensionContext.class, TestAbortedException.class);
        ABSOLUTE_PATH_TO_PIT_DEPENDENCIES = CLASSES_TO_PATH_OF_DEPENDENCIES.apply(PIT_DEPENDENCIES);
        ABSOLUTE_PATH_TO_PIT_DEPENDENCIES_FOR_JUNIT5 = CLASSES_TO_PATH_OF_DEPENDENCIES.apply(PIT_DEPENDENCIES_FOR_JUNIT5);
    }
}

