/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.impl;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.impl.CoverageImpl;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionDataStore;

public class CoverageCollectorSummarization
implements CoverageTransformer {
    private static final long serialVersionUID = 109548359596802378L;

    public static List<Integer> getListOfCountForCounterFunction(IClassCoverage coverage, Function<ICounter, Integer> counterGetter) {
        return coverage.getMethods().stream().filter(iMethodCoverage -> !"<clinit>".equals(iMethodCoverage.getName())).flatMap(iMethodCoverage -> IntStream.range(iMethodCoverage.getFirstLine(), iMethodCoverage.getLastLine() + 1).mapToObj(arg_0 -> ((IMethodCoverage)iMethodCoverage).getLine(arg_0)).map(ILine::getInstructionCounter).map(counterGetter)).collect(Collectors.toList());
    }

    @Override
    public Coverage transformJacocoObject(ExecutionDataStore executionData, List<String> classesDirectory) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(executionData, (ICoverageVisitor)coverageBuilder);
        try {
            for (String directory : classesDirectory) {
                analyzer.analyzeAll(new File(directory));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int[] counter = new int[2];
        StringBuilder builderExecutionPath = new StringBuilder();
        coverageBuilder.getClasses().forEach(coverage -> {
            List<Integer> listOfCountForCounterFunction = CoverageCollectorSummarization.getListOfCountForCounterFunction(coverage, ICounter::getCoveredCount);
            builderExecutionPath.append(coverage.getName()).append(":").append(listOfCountForCounterFunction.stream().map(Objects::toString).collect(Collectors.joining(","))).append(";");
            counter[0] = counter[0] + listOfCountForCounterFunction.stream().mapToInt(Integer::intValue).sum();
            counter[1] = counter[1] + CoverageCollectorSummarization.getListOfCountForCounterFunction(coverage, ICounter::getTotalCount).stream().mapToInt(Integer::intValue).sum();
        });
        CoverageImpl coverage2 = new CoverageImpl(counter[0], counter[1], builderExecutionPath.toString());
        return coverage2;
    }
}

