/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.impl;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ILine;
import org.jacoco.core.analysis.IMethodCoverage;

public class CoverageImpl
implements Coverage,
Serializable {
    private static final long serialVersionUID = 109548359596802378L;
    protected int instructionsCovered;
    protected int instructionsTotal;
    protected String executionPath;

    public CoverageImpl() {
    }

    public CoverageImpl(int covered, int total) {
        this.instructionsCovered = covered;
        this.instructionsTotal = total;
        this.executionPath = "";
    }

    public CoverageImpl(int covered, int total, String executionPath) {
        this.instructionsCovered = covered;
        this.instructionsTotal = total;
        this.executionPath = executionPath;
    }

    @Override
    public void setExecutionPath(String executionPath) {
        this.executionPath = executionPath;
    }

    @Override
    public int getInstructionsCovered() {
        return this.instructionsCovered;
    }

    @Override
    public int getInstructionsTotal() {
        return this.instructionsTotal;
    }

    @Override
    public String getExecutionPath() {
        return this.executionPath;
    }

    public static List<Integer> getListOfCountForCounterFunction(IClassCoverage coverage, Function<ICounter, Integer> counterGetter) {
        return coverage.getMethods().stream().filter(iMethodCoverage -> !"<clinit>".equals(iMethodCoverage.getName())).flatMap(iMethodCoverage -> IntStream.range(iMethodCoverage.getFirstLine(), iMethodCoverage.getLastLine() + 1).mapToObj(arg_0 -> ((IMethodCoverage)iMethodCoverage).getLine(arg_0)).map(ILine::getInstructionCounter).map(counterGetter)).collect(Collectors.toList());
    }

    @Override
    public boolean isBetterThan(Coverage that) {
        if (that == null) {
            return true;
        }
        double percCoverageThis = (double)this.instructionsCovered / (double)this.instructionsTotal;
        double percCoverageThat = (double)that.getInstructionsCovered() / (double)that.getInstructionsTotal();
        return !this.executionPath.equals(that.getExecutionPath()) && percCoverageThis >= percCoverageThat;
    }

    public String toString() {
        return this.instructionsCovered + " / " + this.instructionsTotal;
    }

    @Override
    public void save() {
        ListenerUtils.saveToMemoryMappedFile(new File(OUTPUT_DIR, "Coverage.dat"), this);
    }

    public static Coverage load() {
        return (Coverage)ListenerUtils.loadFromMemoryMappedFile(ListenerUtils.computeTargetFilePath(OUTPUT_DIR, "Coverage.dat"));
    }
}

