/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.impl;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.runner.Failure;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jacoco.agent.rt.RT;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;

public class OnlineCoveredTestResultPerTestMethodImpl
implements CoveredTestResultPerTestMethod {
    private static final long serialVersionUID = 3860229575340959882L;
    protected final transient Map<String, ExecutionDataStore> executionDataStoreMap;
    protected final ConcurrentHashMap<String, Coverage> coverageResultsMap;
    protected final List<String> classesDirectory;
    protected transient ExecFileLoader execFileLoader;
    protected transient CoverageTransformer coverageTransformer;
    private final Set<String> runningTests;
    private final Set<Failure> failingTests;
    private final Set<Failure> assumptionFailingTests;
    private final Set<String> ignoredTests;

    public OnlineCoveredTestResultPerTestMethodImpl(List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.classesDirectory = classesDirectory;
        this.executionDataStoreMap = new HashMap<String, ExecutionDataStore>();
        this.coverageResultsMap = new ConcurrentHashMap();
        this.coverageTransformer = coverageTransformer;
        this.runningTests = new HashSet<String>();
        this.failingTests = new HashSet<Failure>();
        this.assumptionFailingTests = new HashSet<Failure>();
        this.ignoredTests = new HashSet<String>();
    }

    public static void setSessionId(String id) {
        RT.getAgent().setSessionId(id);
    }

    public Map<String, ExecutionDataStore> getExecutionDataStoreMap() {
        return this.executionDataStoreMap;
    }

    public void collect() {
        try {
            this.execFileLoader = new ExecFileLoader();
            this.execFileLoader.load((InputStream)new ByteArrayInputStream(RT.getAgent().getExecutionData(false)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        RT.getAgent().reset();
        RT.getAgent().getExecutionData(true);
    }

    public List<String> getClassesDirectory() {
        return this.classesDirectory;
    }

    public ExecutionDataStore getExecutionData() {
        return this.execFileLoader.getExecutionDataStore();
    }

    public SessionInfoStore getSessionInfos() {
        return this.execFileLoader.getSessionInfoStore();
    }

    public CoverageTransformer getCoverageTransformer() {
        return this.coverageTransformer;
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.coverageResultsMap;
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.getCoverageResultsMap().get(testMethodName);
    }

    @Override
    public Set<String> getRunningTests() {
        return this.runningTests;
    }

    @Override
    public Set<String> getPassingTests() {
        HashSet<String> passingTests = new HashSet<String>(this.runningTests);
        passingTests.removeAll(this.failingTests.stream().map(x -> x.testCaseName).collect(Collectors.toSet()));
        passingTests.removeAll(this.assumptionFailingTests.stream().map(x -> x.testCaseName).collect(Collectors.toSet()));
        return passingTests;
    }

    @Override
    public TestResult aggregate(TestResult that) {
        if (that instanceof OnlineCoveredTestResultPerTestMethodImpl) {
            OnlineCoveredTestResultPerTestMethodImpl thatListener = (OnlineCoveredTestResultPerTestMethodImpl)that;
            this.runningTests.addAll(thatListener.runningTests);
            this.failingTests.addAll(thatListener.failingTests);
            this.assumptionFailingTests.addAll(thatListener.assumptionFailingTests);
            this.ignoredTests.addAll(thatListener.ignoredTests);
        }
        return this;
    }

    @Override
    public Set<Failure> getFailingTests() {
        return this.failingTests;
    }

    @Override
    public Set<Failure> getAssumptionFailingTests() {
        return this.assumptionFailingTests;
    }

    @Override
    public Set<String> getIgnoredTests() {
        return this.ignoredTests;
    }

    @Override
    public Failure getFailureOf(String testMethodName) {
        return this.getFailingTests().stream().filter(failure -> failure.testCaseName.equals(testMethodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find %s in failing test", testMethodName)));
    }

    @Override
    public void save() {
        ListenerUtils.saveToMemoryMappedFile(new File(OUTPUT_DIR, "CoveredTestResultPerTest.dat"), this);
    }

    @Override
    public void computeCoverages() {
        this.executionDataStoreMap.entrySet().parallelStream().forEach(x -> {
            Coverage jUnit4Coverage = this.coverageTransformer.transformJacocoObject((ExecutionDataStore)x.getValue(), this.classesDirectory);
            this.coverageResultsMap.put((String)x.getKey(), jUnit4Coverage);
        });
    }

    public static OnlineCoveredTestResultPerTestMethodImpl load() {
        return (OnlineCoveredTestResultPerTestMethodImpl)ListenerUtils.loadFromMemoryMappedFile(ListenerUtils.computeTargetFilePath(OUTPUT_DIR, "CoveredTestResultPerTest.dat"));
    }

    public String toString() {
        return "OnlineCoveredTestResultPerTestMethodImpl{coverageResultsMap=" + this.coverageResultsMap + ", classesDirectory=" + this.classesDirectory + ", coverageTransformer=" + this.coverageTransformer + ", runningTests=" + this.runningTests + ", failingTests=" + this.failingTests + ", assumptionFailingTests=" + this.assumptionFailingTests + ", ignoredTests=" + this.ignoredTests + '}';
    }
}

