/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.impl;

import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.runner.Failure;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class TestResultImpl
implements TestResult,
Serializable {
    private static final long serialVersionUID = 6898135595908384570L;
    private Set<String> runningTests = new HashSet<String>();
    private Set<Failure> failingTests = new HashSet<Failure>();
    private Set<Failure> assumptionFailingTests = new HashSet<Failure>();
    private Set<String> ignoredTests = new HashSet<String>();

    @Override
    public Set<String> getRunningTests() {
        return this.runningTests;
    }

    @Override
    public Set<String> getPassingTests() {
        HashSet<String> passingTests = new HashSet<String>(this.runningTests);
        passingTests.removeAll(this.failingTests.stream().map(x -> x.testCaseName).collect(Collectors.toSet()));
        passingTests.removeAll(this.assumptionFailingTests.stream().map(x -> x.testCaseName).collect(Collectors.toSet()));
        return passingTests;
    }

    @Override
    public TestResult aggregate(TestResult that) {
        if (that instanceof TestResultImpl) {
            TestResultImpl thatListener = (TestResultImpl)that;
            this.runningTests.addAll(thatListener.runningTests);
            this.failingTests.addAll(thatListener.failingTests);
            this.assumptionFailingTests.addAll(thatListener.assumptionFailingTests);
            this.ignoredTests.addAll(thatListener.ignoredTests);
        }
        return this;
    }

    @Override
    public Set<Failure> getFailingTests() {
        return this.failingTests;
    }

    @Override
    public Set<Failure> getAssumptionFailingTests() {
        return this.assumptionFailingTests;
    }

    @Override
    public Set<String> getIgnoredTests() {
        return this.ignoredTests;
    }

    @Override
    public Failure getFailureOf(String testMethodName) {
        return this.getFailingTests().stream().filter(failure -> failure.testCaseName.equals(testMethodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find %s in failing test", testMethodName)));
    }

    @Override
    public synchronized void save() {
        ListenerUtils.saveToMemoryMappedFile(new File(OUTPUT_DIR, "TestResult.dat"), this);
    }

    public static TestResult load() {
        return (TestResult)ListenerUtils.loadFromMemoryMappedFile(ListenerUtils.computeTargetFilePath(OUTPUT_DIR, "TestResult.dat"));
    }

    public String toString() {
        return "TestResultImpl{runningTests=" + this.getRunningTests() + ", failingTests=" + this.getFailingTests() + ", assumptionFailingTests=" + this.getAssumptionFailingTests() + ", ignoredTests=" + this.getIgnoredTests() + '}';
    }
}

