/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.junit4;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.impl.CoverageImpl;
import eu.stamp_project.testrunner.listener.impl.CoveredTestResultPerTestMethodImpl;
import eu.stamp_project.testrunner.listener.junit4.JUnit4Coverage;
import eu.stamp_project.testrunner.listener.junit4.JUnit4TestResult;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.RuntimeData;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;

public class CoveredTestResultsPerJUnit4TestMethod
extends JUnit4TestResult
implements CoveredTestResultPerTestMethod {
    private static final long serialVersionUID = -6934847896187177463L;
    private CoveredTestResultPerTestMethodImpl internalCoveredTestResult;
    private Map<String, List<IClassCoverage>> coveragesPerMethodName;

    public CoveredTestResultsPerJUnit4TestMethod(RuntimeData data, List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.internalCoveredTestResult = new CoveredTestResultPerTestMethodImpl(data, classesDirectory, coverageTransformer);
        this.coveragesPerMethodName = new HashMap<String, List<IClassCoverage>>();
    }

    public synchronized void testStarted(Description description) throws Exception {
        this.internalCoveredTestResult.setExecutionData(new ExecutionDataStore());
        this.internalCoveredTestResult.setSessionInfos(new SessionInfoStore());
        this.internalCoveredTestResult.getData().setSessionId((String)this.toString.apply(description));
        this.internalCoveredTestResult.getData().collect((IExecutionDataVisitor)this.internalCoveredTestResult.getExecutionData(), (ISessionInfoVisitor)this.internalCoveredTestResult.getSessionInfos(), true);
    }

    @Override
    public synchronized void testFinished(Description description) throws Exception {
        this.internalCoveredTestResult.getRunningTests().add((String)this.toString.apply(description));
        this.internalCoveredTestResult.getData().collect((IExecutionDataVisitor)this.internalCoveredTestResult.getExecutionData(), (ISessionInfoVisitor)this.internalCoveredTestResult.getSessionInfos(), false);
        this.internalCoveredTestResult.getExecutionDataStoreMap().put((String)this.toString.apply(description), ListenerUtils.cloneExecutionDataStore(this.internalCoveredTestResult.getExecutionData()));
        if (isParametrized.test(ListenerUtils.getMethodName.apply(description))) {
            this.collectForParametrizedTest((String)this.toStringParametrized.apply(description));
        }
    }

    @Override
    public void testFailure(Failure failure) throws Exception {
        this.internalCoveredTestResult.getFailingTests().add(new eu.stamp_project.testrunner.runner.Failure((String)this.toString.apply(failure.getDescription()), ListenerUtils.getClassName.apply(failure.getDescription()), failure.getException()));
    }

    @Override
    public void testAssumptionFailure(Failure failure) {
        this.internalCoveredTestResult.getAssumptionFailingTests().add(new eu.stamp_project.testrunner.runner.Failure((String)this.toString.apply(failure.getDescription()), failure.getDescription().getClassName(), failure.getException()));
    }

    @Override
    public void testIgnored(Description description) throws Exception {
        this.internalCoveredTestResult.getIgnoredTests().add((String)this.toString.apply(description));
    }

    private void collectForParametrizedTest(String testMethodName) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        Analyzer analyzer = new Analyzer(this.internalCoveredTestResult.getExecutionData(), (ICoverageVisitor)coverageBuilder);
        try {
            for (String directory : this.internalCoveredTestResult.getClassesDirectory()) {
                analyzer.analyzeAll(new File(directory));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.coveragesPerMethodName.containsKey(testMethodName)) {
            this.coveragesPerMethodName.put(testMethodName, new ArrayList());
        }
        coverageBuilder.getClasses().forEach(classCoverage -> this.coveragesPerMethodName.get(testMethodName).add((IClassCoverage)classCoverage));
    }

    public Map<String, List<IClassCoverage>> getCoveragesPerMethodName() {
        return this.coveragesPerMethodName;
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.internalCoveredTestResult.getCoverageResultsMap();
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.internalCoveredTestResult.getCoverageOf(testMethodName);
    }

    @Override
    public Set<String> getRunningTests() {
        return this.internalCoveredTestResult.getRunningTests();
    }

    @Override
    public Set<String> getPassingTests() {
        return this.internalCoveredTestResult.getPassingTests();
    }

    @Override
    public TestResult aggregate(TestResult that) {
        if (that instanceof CoveredTestResultsPerJUnit4TestMethod) {
            return this.internalCoveredTestResult.aggregate(((CoveredTestResultsPerJUnit4TestMethod)that).internalCoveredTestResult);
        }
        return this;
    }

    @Override
    public Set<eu.stamp_project.testrunner.runner.Failure> getFailingTests() {
        return this.internalCoveredTestResult.getFailingTests();
    }

    @Override
    public Set<eu.stamp_project.testrunner.runner.Failure> getAssumptionFailingTests() {
        return this.internalCoveredTestResult.getAssumptionFailingTests();
    }

    @Override
    public Set<String> getIgnoredTests() {
        return this.internalCoveredTestResult.getIgnoredTests();
    }

    @Override
    public eu.stamp_project.testrunner.runner.Failure getFailureOf(String testMethodName) {
        return this.getFailingTests().stream().filter(failure -> failure.testCaseName.equals(testMethodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find %s in failing test", testMethodName)));
    }

    @Override
    public void save() {
        if (!this.coveragesPerMethodName.isEmpty()) {
            this.aggregateParametrizedTestCoverage();
        }
        this.internalCoveredTestResult.save();
    }

    private void aggregateParametrizedTestCoverage() {
        this.coveragesPerMethodName.keySet().forEach(testMethodName -> {
            int covered = 0;
            int total = 0;
            ArrayList<IClassCoverage> classCoverages = new ArrayList<IClassCoverage>((Collection)this.coveragesPerMethodName.get(testMethodName));
            while (!classCoverages.isEmpty()) {
                IClassCoverage current = (IClassCoverage)classCoverages.get(0);
                List<IClassCoverage> subListOnSameClass = this.getSameClassCoverage(current.getName(), classCoverages);
                List coveragePerMethods = subListOnSameClass.stream().map(coverage -> CoverageImpl.getListOfCountForCounterFunction(coverage, ICounter::getCoveredCount)).collect(Collectors.toList());
                List bestCoverage = IntStream.range(0, ((List)coveragePerMethods.get(0)).size()).boxed().map(index -> coveragePerMethods.stream().map(integers -> (Integer)integers.get((int)index)).max(Integer::compareTo).get()).collect(Collectors.toList());
                covered += bestCoverage.stream().mapToInt(Integer::intValue).sum();
                total += CoverageImpl.getListOfCountForCounterFunction(subListOnSameClass.get(0), ICounter::getTotalCount).stream().mapToInt(Integer::intValue).sum();
                classCoverages.removeAll(subListOnSameClass);
            }
            JUnit4Coverage value = new JUnit4Coverage(covered, total);
            value.setExecutionPath(this.internalCoveredTestResult.getCoverageResultsMap().keySet().stream().map(this.internalCoveredTestResult.getCoverageResultsMap()::get).map(Coverage::getExecutionPath).collect(Collectors.joining("#")));
            this.internalCoveredTestResult.getCoverageResultsMap().put((String)testMethodName, value);
        });
    }

    private List<IClassCoverage> getSameClassCoverage(String className, List<IClassCoverage> classCoverages) {
        return classCoverages.stream().filter(iClassCoverage -> className.equals(iClassCoverage.getName())).collect(Collectors.toList());
    }

    @Override
    public void computeCoverages() {
        this.internalCoveredTestResult.computeCoverages();
    }
}

