/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.junit4;

import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.listener.impl.TestResultImpl;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.runner.Failure;
import java.io.Serializable;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class JUnit4TestResult
extends RunListener
implements TestResult,
Serializable {
    private static final long serialVersionUID = 2295395800748319976L;
    private TestResultImpl internalTestResult;
    protected final transient Function<Description, String> toString = description -> ListenerUtils.getClassName.apply((Description)description) + "#" + ListenerUtils.getMethodName.apply((Description)description);
    protected final transient Function<Description, String> toStringParametrized = description -> ListenerUtils.getClassName.apply((Description)description) + "#" + fromParametrizedToSimpleName.apply(ListenerUtils.getMethodName.apply((Description)description));
    protected static final Predicate<String> isParametrized = testMethodName -> Pattern.compile(".+\\[\\d+\\]").matcher((CharSequence)testMethodName).matches();
    protected static final Function<String, String> fromParametrizedToSimpleName = parametrizedName -> parametrizedName.contains("[") ? parametrizedName.split("\\[")[0] : parametrizedName;

    public JUnit4TestResult() {
        this.internalTestResult = new TestResultImpl();
    }

    public void testFinished(Description description) throws Exception {
        this.internalTestResult.getRunningTests().add(this.toString.apply(description));
    }

    public void testFailure(org.junit.runner.notification.Failure failure) throws Exception {
        this.internalTestResult.getFailingTests().add(new Failure(this.toString.apply(failure.getDescription()), ListenerUtils.getClassName.apply(failure.getDescription()), failure.getException()));
    }

    public void testAssumptionFailure(org.junit.runner.notification.Failure failure) {
        this.internalTestResult.getAssumptionFailingTests().add(new Failure(this.toString.apply(failure.getDescription()), ListenerUtils.getClassName.apply(failure.getDescription()), failure.getException()));
    }

    public void testIgnored(Description description) throws Exception {
        this.internalTestResult.getIgnoredTests().add(this.toString.apply(description));
    }

    @Override
    public Set<String> getRunningTests() {
        return this.internalTestResult.getRunningTests();
    }

    @Override
    public Set<String> getPassingTests() {
        return this.internalTestResult.getPassingTests();
    }

    @Override
    public TestResult aggregate(TestResult that) {
        if (that instanceof JUnit4TestResult) {
            return this.internalTestResult.aggregate(((JUnit4TestResult)that).internalTestResult);
        }
        return this;
    }

    @Override
    public Set<Failure> getFailingTests() {
        return this.internalTestResult.getFailingTests();
    }

    @Override
    public Set<Failure> getAssumptionFailingTests() {
        return this.internalTestResult.getAssumptionFailingTests();
    }

    @Override
    public Set<String> getIgnoredTests() {
        return this.internalTestResult.getIgnoredTests();
    }

    @Override
    public Failure getFailureOf(String testMethodName) {
        return this.getFailingTests().stream().filter(failure -> failure.testCaseName.equals(testMethodName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Could not find %s in failing test", testMethodName)));
    }

    @Override
    public void save() {
        this.internalTestResult.save();
    }

    public String toString() {
        return "JUnit4TestResult{runningTests=" + this.internalTestResult.getRunningTests() + ", failingTests=" + this.internalTestResult.getFailingTests() + ", assumptionFailingTests=" + this.internalTestResult.getAssumptionFailingTests() + ", ignoredTests=" + this.internalTestResult.getIgnoredTests() + '}';
    }
}

