/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.pit;

import eu.stamp_project.testrunner.listener.pit.AbstractPitResult;
import eu.stamp_project.testrunner.listener.pit.PitCSVResultParser;
import eu.stamp_project.testrunner.listener.pit.PitXMLResultParser;
import java.io.File;
import java.util.List;

public abstract class AbstractParser<T extends AbstractPitResult> {
    private final String PATH_TO_MUTATIONS_RESULT;

    AbstractParser(String PATH_TO_MUTATIONS_RESULT) {
        this.PATH_TO_MUTATIONS_RESULT = PATH_TO_MUTATIONS_RESULT;
    }

    protected File getPathOfMutationsFile(String pathToDirectoryResults) {
        if (!new File(pathToDirectoryResults).exists()) {
            return null;
        }
        if (new File(pathToDirectoryResults + this.PATH_TO_MUTATIONS_RESULT).exists()) {
            return new File(pathToDirectoryResults + this.PATH_TO_MUTATIONS_RESULT);
        }
        File[] files = new File(pathToDirectoryResults).listFiles();
        if (files == null) {
            return null;
        }
        File directoryReportPit = files[0];
        if (!directoryReportPit.exists()) {
            return null;
        }
        return new File(directoryReportPit.getPath() + this.PATH_TO_MUTATIONS_RESULT);
    }

    public List<T> parseAndDelete(String pathToDirectoryResults) {
        File fileResults = this.getPathOfMutationsFile(pathToDirectoryResults);
        List<T> results = this.parse(fileResults);
        return results;
    }

    public abstract List<T> parse(File var1);

    public static AbstractParser<?> build(OutputFormat outputFormat) {
        switch (outputFormat) {
            case CSV: {
                return new PitCSVResultParser();
            }
            case XML: {
                return new PitXMLResultParser();
            }
        }
        throw new RuntimeException("Unrecognized parameter:" + outputFormat.toString());
    }

    public static enum OutputFormat {
        XML,
        CSV;

    }
}

