/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.pit;

import eu.stamp_project.testrunner.listener.pit.AbstractParser;
import eu.stamp_project.testrunner.listener.pit.AbstractPitResult;
import eu.stamp_project.testrunner.listener.pit.PitCSVResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public class PitCSVResultParser
extends AbstractParser<PitCSVResult> {
    public PitCSVResultParser() {
        super("/mutations.csv");
    }

    @Override
    public List<PitCSVResult> parse(File fileResults) {
        ArrayList<PitCSVResult> results = new ArrayList<PitCSVResult>();
        try (BufferedReader buffer = new BufferedReader(new FileReader(fileResults));){
            buffer.lines().forEach(line -> {
                String[] splittedLines = line.split(",");
                if (splittedLines.length == 7) {
                    String fullQualifiedNameClass;
                    String fullQualifiedNameMethod;
                    AbstractPitResult.State state;
                    try {
                        state = AbstractPitResult.State.valueOf(splittedLines[5]);
                    }
                    catch (Exception e) {
                        state = AbstractPitResult.State.NO_COVERAGE;
                    }
                    String fullQualifiedNameOfMutatedClass = splittedLines[1];
                    String fullQualifiedNameMutantOperator = splittedLines[2];
                    if ("none".equals(splittedLines[6])) {
                        fullQualifiedNameMethod = "none";
                        fullQualifiedNameClass = "none";
                    } else {
                        String[] nameOfTheKiller = splittedLines[6].split("\\(");
                        if (nameOfTheKiller.length > 1) {
                            fullQualifiedNameMethod = nameOfTheKiller[0];
                            fullQualifiedNameClass = nameOfTheKiller[1].substring(0, nameOfTheKiller[1].length() - 1);
                        } else {
                            fullQualifiedNameMethod = "none";
                            fullQualifiedNameClass = nameOfTheKiller[0].substring(0, nameOfTheKiller[0].length() / 2);
                        }
                    }
                    int lineNumber = Integer.parseInt(splittedLines[4]);
                    String location = splittedLines[3];
                    results.add(new PitCSVResult(fullQualifiedNameOfMutatedClass, state, fullQualifiedNameMutantOperator, fullQualifiedNameMethod, fullQualifiedNameClass, lineNumber, location));
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return results;
    }
}

