/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.pit;

import eu.stamp_project.testrunner.listener.pit.AbstractParser;
import eu.stamp_project.testrunner.listener.pit.AbstractPitResult;
import eu.stamp_project.testrunner.listener.pit.PitXMLResult;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PitXMLResultParser
extends AbstractParser<PitXMLResult> {
    public PitXMLResultParser() {
        super("/mutations.xml");
    }

    @Override
    public List<PitXMLResult> parse(File fileResults) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            class Handler
            extends DefaultHandler {
                private StringBuilder stringBuilder;
                final List<PitXMLResult> results = new ArrayList<PitXMLResult>();
                String sourceFile;
                String methodDescription;
                String mutatedClass;
                String mutatedMethod;
                String mutator;
                String killingTest;
                String description;
                String fullQualifiedNameMethod;
                String fullQualifiedNameClass;
                int numberOfTestsRun;
                int lineNumber;
                int index;
                int block;
                AbstractPitResult.State state;
                boolean detected;
                boolean startElement = false;

                Handler() {
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) {
                    this.startElement = true;
                    this.stringBuilder = new StringBuilder();
                    if (qName.equalsIgnoreCase("mutation")) {
                        this.detected = Boolean.parseBoolean(attributes.getValue("detected"));
                        this.numberOfTestsRun = Integer.parseInt(attributes.getValue("numberOfTestsRun"));
                        try {
                            this.state = AbstractPitResult.State.valueOf(attributes.getValue("status"));
                        }
                        catch (Exception e) {
                            this.state = AbstractPitResult.State.NO_COVERAGE;
                        }
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) {
                    this.stringBuilder.append(new String(ch, start, length));
                }

                @Override
                public void endElement(String uri, String localName, String qName) {
                    this.startElement = false;
                    if (qName.equalsIgnoreCase("sourceFile")) {
                        this.sourceFile = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("mutatedClass")) {
                        this.mutatedClass = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("mutatedMethod")) {
                        this.mutatedMethod = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("methodDescription")) {
                        this.methodDescription = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("lineNumber")) {
                        this.lineNumber = Integer.parseInt(this.stringBuilder.toString());
                    } else if (qName.equalsIgnoreCase("mutator")) {
                        this.mutator = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("index")) {
                        this.index = Integer.parseInt(this.stringBuilder.toString());
                    } else if (qName.equalsIgnoreCase("block")) {
                        this.block = Integer.parseInt(this.stringBuilder.toString());
                    } else if (qName.equalsIgnoreCase("killingTest")) {
                        this.killingTest = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("description")) {
                        this.description = this.stringBuilder.toString();
                    } else if (qName.equalsIgnoreCase("mutation")) {
                        if (this.killingTest.trim().equals("")) {
                            this.fullQualifiedNameMethod = "none";
                            this.fullQualifiedNameClass = "none";
                        } else {
                            String[] nameOfTheKiller = this.killingTest.split("\\(");
                            if (nameOfTheKiller.length > 1) {
                                this.fullQualifiedNameMethod = nameOfTheKiller[0];
                                this.fullQualifiedNameClass = nameOfTheKiller[1].substring(0, nameOfTheKiller[1].length() - 1);
                            } else {
                                this.fullQualifiedNameMethod = "none";
                                this.fullQualifiedNameClass = nameOfTheKiller[0].substring(0, nameOfTheKiller[0].length() / 2);
                            }
                        }
                        this.results.add(new PitXMLResult(this.mutatedClass, this.state, this.mutator, this.fullQualifiedNameMethod, this.fullQualifiedNameClass, this.lineNumber, this.mutatedMethod, this.methodDescription, this.description, this.index, this.block, this.numberOfTestsRun, this.detected));
                    }
                }

                public List<PitXMLResult> getResults() {
                    return this.results;
                }
            }
            Handler handler = new Handler();
            saxParser.parse(fileResults, (DefaultHandler)handler);
            return handler.getResults();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<PitXMLResult>();
        }
    }
}

