/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.utils;

import eu.stamp_project.testrunner.EntryPoint;
import eu.stamp_project.testrunner.listener.CoveredTestResultPerTestMethod;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.function.Function;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.junit.runner.Description;

public class ListenerUtils {
    public static final Function<Description, String> getMethodName = description -> {
        String methodName = "";
        try {
            methodName = description.getMethodName();
        }
        catch (NoSuchMethodError e) {
            methodName = description.getDisplayName().split("\\(")[0];
        }
        return methodName;
    };
    public static final Function<Description, String> getClassName = description -> {
        String className = "";
        try {
            className = description.getClassName();
        }
        catch (NoSuchMethodError e) {
            className = description.isSuite() ? description.getDisplayName() : description.getDisplayName().split("\\(")[1].split("\\)")[0];
        }
        return className;
    };

    public static ExecutionDataStore cloneExecutionDataStore(ExecutionDataStore original) {
        ExecutionDataStore cloned = new ExecutionDataStore();
        original.getContents().stream().forEach(x -> {
            ExecutionData executionData = new ExecutionData(x.getId(), x.getName(), (boolean[])x.getProbes().clone());
            ExecutionDataStore executionDataStore = cloned;
            synchronized (executionDataStore) {
                cloned.put(executionData);
            }
        });
        return cloned;
    }

    public static void saveToMemoryMappedFile(File file, Object object) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            out.writeObject(object);
            out.flush();
            byte[] bytes = bos.toByteArray();
            File outputDir = new File(CoveredTestResultPerTestMethod.OUTPUT_DIR);
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                System.err.println("Error while creating output dir");
            }
            FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
            MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_WRITE, 0L, bytes.length);
            buffer.put(bytes);
            bos.close();
            out.close();
            channel.close();
            System.out.println("File saved to the following path: " + file.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.println("Error while writing memory-mapped serialized file.");
            throw new RuntimeException(e);
        }
    }

    public static <T> T loadFromMemoryMappedFile(File file) {
        try {
            FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            byte[] buffer = new byte[(int)channel.size()];
            mappedByteBuffer.get(buffer);
            ObjectInputStream is = new ObjectInputStream(new ByteArrayInputStream(buffer));
            Object load = is.readObject();
            is.close();
            channel.close();
            file.delete();
            return (T)load;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static File computeTargetFilePath(String outputDir, String outputFile) {
        return new File(new File(EntryPoint.workingDirectory != null && EntryPoint.workingDirectory.exists() ? EntryPoint.workingDirectory.getAbsolutePath() : "./", outputDir).getAbsolutePath(), outputFile);
    }
}

