/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.maven;

import eu.stamp_project.testrunner.listener.TestResult;
import eu.stamp_project.testrunner.maven.SurefireReportsReader;
import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntryPoint.class);
    public static String preGoals = "";
    private static final Properties properties = new Properties();
    private static final String POM_FILE = "pom.xml";
    private static final String GOAL_TEST = "test";
    private static final String GOAL_SPECIFY = "-Dtest=";
    private static final String TEST_CLASS_SEPARATOR = ",";
    private static final String TEST_METHOD_SEPARATOR = "+";
    private static final String TEST_CLASS_METHOD_SEPARATOR = "#";
    private static final String PATH_TO_SUREFIRE = "target/surefire-reports/";
    public static String mavenHome;

    public static TestResult runTestClasses(String absolutePathToRootProject, String ... fullQualifiedNameOfTestClasses) {
        return EntryPoint.runTestClassesSpecificPom(absolutePathToRootProject, POM_FILE, fullQualifiedNameOfTestClasses);
    }

    public static TestResult runTestClassesSpecificPom(String absolutePathToRootProject, String pomFileName, String ... fullQualifiedNameOfTestClasses) {
        if (fullQualifiedNameOfTestClasses.length > 0) {
            EntryPoint.runMavenGoal(absolutePathToRootProject, GOAL_TEST, GOAL_SPECIFY + String.join((CharSequence)TEST_CLASS_SEPARATOR, fullQualifiedNameOfTestClasses));
        } else {
            EntryPoint.runMavenGoal(absolutePathToRootProject, pomFileName, GOAL_TEST);
        }
        return new SurefireReportsReader().readAll(absolutePathToRootProject + "/" + PATH_TO_SUREFIRE);
    }

    public static TestResult runTests(String absolutePathToRootProject, String fullQualifiedNameOfTestClass, String ... testMethods) {
        return EntryPoint.runTestsSpecificPom(absolutePathToRootProject, fullQualifiedNameOfTestClass, POM_FILE, testMethods);
    }

    public static TestResult runTestsSpecificPom(String absolutePathToRootProject, String fullQualifiedNameOfTestClass, String pomFileName, String ... testMethods) {
        if (testMethods.length > 0) {
            EntryPoint.runMavenGoal(absolutePathToRootProject + "/" + pomFileName, GOAL_TEST, GOAL_SPECIFY + fullQualifiedNameOfTestClass + TEST_CLASS_METHOD_SEPARATOR + String.join((CharSequence)TEST_METHOD_SEPARATOR, testMethods));
        } else {
            EntryPoint.runMavenGoal(absolutePathToRootProject + "/" + pomFileName, GOAL_TEST);
        }
        return new SurefireReportsReader().readAll(absolutePathToRootProject + "/" + PATH_TO_SUREFIRE);
    }

    static int runMavenGoal(String absolutePathToPomFile, String ... goals) {
        String[] splittedPreGoals;
        String[] stringArray = splittedPreGoals = preGoals.isEmpty() ? new String[]{} : preGoals.split(TEST_CLASS_SEPARATOR);
        if (!eu.stamp_project.testrunner.EntryPoint.persistence) {
            preGoals = "";
        }
        CharSequence[] finalGoals = new String[splittedPreGoals.length + goals.length];
        System.arraycopy(splittedPreGoals, 0, finalGoals, 0, splittedPreGoals.length);
        System.arraycopy(goals, 0, finalGoals, splittedPreGoals.length, goals.length);
        LOGGER.debug("run mvn {}", (Object)String.join((CharSequence)" ", finalGoals));
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setGoals(Arrays.asList(goals));
        request.setPomFile(new File(absolutePathToPomFile));
        request.setJavaHome(new File(System.getProperty("java.home")));
        request.setProperties(properties);
        DefaultInvoker invoker = new DefaultInvoker();
        if (mavenHome == null) {
            EntryPoint.setMavenHome();
        }
        invoker.setMavenHome(new File(mavenHome));
        invoker.setOutputHandler(arg_0 -> ((Logger)LOGGER).info(arg_0));
        invoker.setErrorHandler(arg_0 -> ((Logger)LOGGER).error(arg_0));
        try {
            return invoker.execute((InvocationRequest)request).getExitCode();
        }
        catch (MavenInvocationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setMavenHome() {
        LOGGER.warn("Trying to lookup for maven home.");
        LOGGER.warn("This can fail, and thus lead to a crash of the application.");
        LOGGER.warn("You can set this value using the field mavenHome or defining the following property: MAVEN_HOME or M2_HOME");
        mavenHome = EntryPoint.getMavenHome(envVariable -> System.getenv().get(envVariable) != null, envVariable -> System.getenv().get(envVariable), "MAVEN_HOME", "M2_HOME");
        if (mavenHome == null && (mavenHome = EntryPoint.getMavenHome(path -> new File((String)path).exists(), Function.identity(), "/usr/share/maven/", "/usr/local/maven-3.3.9/", "/usr/share/maven3/", "/usr/share/apache-maven-3.8.1")) == null) {
            throw new RuntimeException("Maven home not found, please set properly MAVEN_HOME or M2_HOME.");
        }
    }

    private static String getMavenHome(Predicate<String> conditional, Function<String, String> getFunction, String ... possibleValues) {
        String mavenHome = null;
        Optional<String> potentialMavenHome = Arrays.stream(possibleValues).filter(conditional).findFirst();
        if (potentialMavenHome.isPresent()) {
            mavenHome = getFunction.apply(potentialMavenHome.get());
        }
        return mavenHome;
    }

    static {
        properties.setProperty("enforcer.skip", "true");
        properties.setProperty("checkstyle.skip", "true");
        properties.setProperty("cobertura.skip", "true");
        properties.setProperty("skipITs", "true");
        properties.setProperty("rat.skip", "true");
        properties.setProperty("license.skip", "true");
        properties.setProperty("findbugs.skip", "true");
        properties.setProperty("gpg.skip", "true");
        properties.setProperty("jacoco.skip", "true");
    }
}

