/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;

public class Failure
implements Serializable {
    public final String testCaseName;
    public final String testClassName;
    public final String fullQualifiedNameOfException;
    public final String messageOfFailure;
    public final String stackTrace;

    public Failure(String testCaseName, String testClassName, Throwable exception) {
        this.testCaseName = testCaseName;
        this.fullQualifiedNameOfException = exception.getClass().getName();
        this.messageOfFailure = exception.getMessage();
        this.testClassName = testClassName;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        this.stackTrace = sw.toString();
    }

    public Failure(String testCaseName, String testClassName, String fullQualifiedNameOfException, String messageOfFailure, String stackTrace) {
        this.testCaseName = testCaseName;
        this.fullQualifiedNameOfException = fullQualifiedNameOfException;
        this.messageOfFailure = messageOfFailure;
        this.testClassName = testClassName;
        this.stackTrace = stackTrace;
    }

    public String toString() {
        return this.testCaseName + "(" + this.testClassName + "): " + this.messageOfFailure;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Failure failure = (Failure)o;
        if (this.testCaseName != null ? !this.testCaseName.equals(failure.testCaseName) : failure.testCaseName != null) {
            return false;
        }
        if (this.fullQualifiedNameOfException != null ? !this.fullQualifiedNameOfException.equals(failure.fullQualifiedNameOfException) : failure.fullQualifiedNameOfException != null) {
            return false;
        }
        return this.messageOfFailure != null ? this.messageOfFailure.equals(failure.messageOfFailure) : failure.messageOfFailure == null;
    }

    public int hashCode() {
        int result = this.testCaseName != null ? this.testCaseName.hashCode() : 0;
        result = 31 * result + (this.fullQualifiedNameOfException != null ? this.fullQualifiedNameOfException.hashCode() : 0);
        result = 31 * result + (this.messageOfFailure != null ? this.messageOfFailure.hashCode() : 0);
        return result;
    }
}

