/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner.coverage;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.CoveredTestResult;
import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.runner.coverage.MemoryClassLoader;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.instr.Instrumenter;
import org.jacoco.core.runtime.IExecutionDataAccessorGenerator;
import org.jacoco.core.runtime.IRuntime;
import org.jacoco.core.runtime.LoggerRuntime;
import org.jacoco.core.runtime.RuntimeData;

public abstract class JacocoRunner {
    protected MemoryClassLoader instrumentedClassLoader;
    protected Instrumenter instrumenter;
    protected IRuntime runtime;
    protected List<String> blackList;
    protected CoverageTransformer coverageTransformer;

    public JacocoRunner(List<String> classesDirectory, List<String> testClassesDirectory, CoverageTransformer coverageTransformer) {
        this(classesDirectory, testClassesDirectory, Collections.emptyList(), coverageTransformer);
    }

    public JacocoRunner(List<String> classesDirectory, List<String> testClassesDirectory, List<String> blackList, CoverageTransformer coverageTransformer) {
        URL[] dirs = (URL[])Stream.concat(classesDirectory.stream(), testClassesDirectory.stream()).map(x -> {
            try {
                return new File((String)x).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        this.instrumentedClassLoader = new MemoryClassLoader(dirs);
        this.blackList = blackList;
        this.runtime = new LoggerRuntime();
        this.instrumenter = new Instrumenter((IExecutionDataAccessorGenerator)this.runtime);
        this.coverageTransformer = coverageTransformer;
        this.instrumentAll(classesDirectory);
    }

    protected void recreateInstrumentedClassloaded(String classpath, String classesDirectory, Map<String, byte[]> definitions) {
        URLClassLoader urlloader = this.getUrlClassloaderFromClassPath(classpath);
        this.recreateInstrumentedClassloaded(urlloader, classesDirectory, definitions);
    }

    protected void recreateInstrumentedClassloaded(ClassLoader urlloader, String classesDirectory, Map<String, byte[]> definitions) {
        try {
            String[] dirs = classesDirectory.split(File.pathSeparator);
            URL[] urls = new URL[dirs.length];
            for (int i = 0; i < dirs.length; ++i) {
                String dir = dirs[i];
                urls[i] = new File(dir).toURI().toURL();
            }
            this.instrumentedClassLoader = new MemoryClassLoader(urls, urlloader);
            this.instrumentedClassLoader.setDefinitions(definitions);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Coverage run(List<String> classesDirectory, List<String> testClassesDirectory, String fullQualifiedNameOfTestClass, String ... testMethodNames) {
        RuntimeData data = new RuntimeData();
        ExecutionDataStore executionData = new ExecutionDataStore();
        SessionInfoStore sessionInfos = new SessionInfoStore();
        URL[] dirs = (URL[])testClassesDirectory.stream().map(x -> {
            try {
                return new File((String)x).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(dirs, (ClassLoader)this.instrumentedClassLoader);
        String resource = ConstantsHelper.fullQualifiedNameToPath.apply(fullQualifiedNameOfTestClass) + ".class";
        try {
            this.instrumentedClassLoader.addDefinition(fullQualifiedNameOfTestClass, IOUtils.toByteArray((InputStream)classLoader.getResourceAsStream(resource)));
            this.runtime.startup(data);
            CoveredTestResult listener = this.executeTest(new String[]{fullQualifiedNameOfTestClass}, testMethodNames, Collections.emptyList());
            if (!listener.getFailingTests().isEmpty()) {
                System.err.println("Some test(s) failed during computation of coverage:\n" + listener.getFailingTests().stream().map(Failure::toString).collect(Collectors.joining("\n")));
            }
            data.collect((IExecutionDataVisitor)executionData, (ISessionInfoVisitor)sessionInfos, false);
            this.runtime.shutdown();
            ResourceBundle.clearCache(this.instrumentedClassLoader);
            Coverage computedCoverage = this.coverageTransformer.transformJacocoObject(executionData, classesDirectory);
            return computedCoverage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract CoveredTestResult executeTest(String[] var1, String[] var2, List<String> var3);

    public Coverage run(List<String> classesDirectory, List<String> testClassesDirectory, String ... fullQualifiedNameOfTestClasses) {
        RuntimeData data = new RuntimeData();
        ExecutionDataStore executionData = new ExecutionDataStore();
        SessionInfoStore sessionInfos = new SessionInfoStore();
        URL[] dirs = (URL[])testClassesDirectory.stream().map(x -> {
            try {
                return new File((String)x).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }).toArray(URL[]::new);
        URLClassLoader classLoader = new URLClassLoader(dirs, (ClassLoader)this.instrumentedClassLoader);
        Arrays.stream(fullQualifiedNameOfTestClasses).forEach(fullQualifiedNameOfTestClass -> {
            String resource = ConstantsHelper.fullQualifiedNameToPath.apply((String)fullQualifiedNameOfTestClass) + ".class";
            try {
                this.instrumentedClassLoader.addDefinition((String)fullQualifiedNameOfTestClass, IOUtils.toByteArray((InputStream)classLoader.getResourceAsStream(resource)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        try {
            this.runtime.startup(data);
            CoveredTestResult listener = this.executeTest(fullQualifiedNameOfTestClasses, new String[0], this.blackList);
            if (!listener.getFailingTests().isEmpty()) {
                System.err.println("Some test(s) failed during computation of coverage:\n" + listener.getFailingTests().stream().map(Failure::toString).collect(Collectors.joining("\n")));
            }
            data.collect((IExecutionDataVisitor)executionData, (ISessionInfoVisitor)sessionInfos, false);
            this.runtime.shutdown();
            ResourceBundle.clearCache(this.instrumentedClassLoader);
            Coverage coverage = this.coverageTransformer.transformJacocoObject(executionData, classesDirectory);
            listener.setCoverageInformation(coverage);
            return listener;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void instrumentAll(List<String> classesDirectory) {
        for (String directory : classesDirectory) {
            Iterator iterator = FileUtils.iterateFiles((File)new File(directory), (String[])new String[]{"class"}, (boolean)true);
            while (iterator.hasNext()) {
                File next = (File)iterator.next();
                String fileName = next.getPath().substring(directory.length() + (directory.endsWith(ConstantsHelper.FILE_SEPARATOR) ? 0 : 1));
                String fullQualifiedName = ConstantsHelper.pathToFullQualifiedName.apply(fileName).substring(0, fileName.length() - ".class".length());
                try {
                    this.instrumentedClassLoader.addDefinition(fullQualifiedName, this.instrumenter.instrument(this.instrumentedClassLoader.getResourceAsStream(fileName), fullQualifiedName));
                }
                catch (IOException e) {
                    throw new RuntimeException(fileName + "," + new File(fileName).getAbsolutePath() + "," + fullQualifiedName, e);
                }
            }
        }
        ResourceBundle.clearCache(this.instrumentedClassLoader);
    }

    public MemoryClassLoader getInstrumentedClassLoader() {
        return this.instrumentedClassLoader;
    }

    public URLClassLoader getUrlClassloader(String[] classpath, String classesDirectory, String testClassesDirectory) {
        URLClassLoader classLoader;
        URL[] urls = new URL[classpath.length + 2];
        try {
            for (int i = 0; i < classpath.length; ++i) {
                urls[i] = new File(classpath[i]).toURI().toURL();
            }
            urls[classpath.length] = new File(classesDirectory).toURI().toURL();
            urls[classpath.length + 1] = new File(testClassesDirectory).toURI().toURL();
            classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return classLoader;
    }

    public URLClassLoader getUrlClassloaderFromClassPath(String classpath) {
        URLClassLoader classLoader;
        String[] cps = classpath.split(File.pathSeparator);
        URL[] urls = new URL[cps.length];
        try {
            for (int i = 0; i < cps.length; ++i) {
                urls[i] = new File(cps[i]).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return classLoader;
    }
}

