/*
 * Decompiled with CFR 0.152.
 */
package eu.timepit.fs2cron.calev;

import cats.FlatMap;
import cats.Functor;
import cats.Semigroupal;
import cats.effect.kernel.GenTemporal;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import com.github.eikek.calev.CalEvent;
import eu.timepit.fs2cron.Scheduler;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2$;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;

public final class CalevScheduler$
implements Serializable {
    public static final CalevScheduler$ MODULE$ = new CalevScheduler$();

    private CalevScheduler$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CalevScheduler$.class);
    }

    public <F> Scheduler<F, CalEvent> systemDefault(GenTemporal<F, Throwable> temporal, Sync<F> F) {
        return this.from(F.delay(this::systemDefault$$anonfun$1), temporal);
    }

    public <F> Scheduler<F, CalEvent> utc(GenTemporal<F, Throwable> F) {
        return this.from(F.pure((Object)ZoneOffset.UTC), F);
    }

    public <F> Scheduler<F, CalEvent> from(Object zoneId, GenTemporal<F, Throwable> F) {
        return new Scheduler<F, CalEvent>(zoneId, F){
            private final GenTemporal F$2;
            private final Object now;
            {
                this.F$2 = F$1;
                this.now = package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(F$1.realTimeInstant(), zoneId$1)).mapN(CalevScheduler$::eu$timepit$fs2cron$calev$CalevScheduler$$anon$1$$_$$lessinit$greater$$anonfun$1, (Functor)F$1, (Semigroupal)F$1);
            }

            public Object fromNowUntilNext(CalEvent schedule) {
                return package.all$.MODULE$.toFlatMapOps(this.now, (FlatMap)this.F$2).flatMap((Function1 & Serializable)from -> {
                    Object object;
                    Option option = schedule.nextElapse(from);
                    if (option instanceof Some) {
                        ZonedDateTime next = (ZonedDateTime)((Some)option).value();
                        long durationInMillis = from.until(next, ChronoUnit.MILLIS);
                        object = this.F$2.pure((Object)FiniteDuration$.MODULE$.apply(durationInMillis, TimeUnit.MILLISECONDS));
                    } else if (None$.MODULE$.equals(option)) {
                        String msg = new StringBuilder(45).append("Could not calculate the next date-time from ").append(from).append(" ").append(new StringBuilder(65).append("given the calendar event expression '").append(schedule.asString()).append("'. This should never happen.").toString()).toString();
                        object = this.F$2.raiseError((Object)new Throwable(msg));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return object;
                });
            }

            public GenTemporal temporal() {
                return this.F$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{eu$timepit$fs2cron$calev$CalevScheduler$$anon$1$$_$$lessinit$greater$$anonfun$1(java.time.Instant java.time.ZoneId ), fromNowUntilNext$$anonfun$1(com.github.eikek.calev.CalEvent java.time.ZonedDateTime )}, serializedLambda);
            }
        };
    }

    private final ZoneId systemDefault$$anonfun$1() {
        return ZoneId.systemDefault();
    }

    public static final /* synthetic */ ZonedDateTime eu$timepit$fs2cron$calev$CalevScheduler$$anon$1$$_$$lessinit$greater$$anonfun$1(Instant _$4, ZoneId _$5) {
        return _$4.atZone(_$5);
    }
}

