/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.async;

import eu.toolchain.async.ClockSource;

public interface RetryPolicy {
    public Instance apply(ClockSource var1);

    public static RetryPolicy linear(long backoff) {
        return new Linear(backoff);
    }

    public static RetryPolicy exponential(long base) {
        return RetryPolicy.exponential(base, (long)((double)base * Math.pow(2.0, 5.0)));
    }

    public static RetryPolicy exponential(long base, long max) {
        return new Exponential(base, max);
    }

    public static RetryPolicy timed(long duration, RetryPolicy policy) {
        return new Timed(duration, policy);
    }

    public static interface Instance {
        public Decision next();
    }

    public static class Decision {
        private final boolean shouldRetry;
        private final long backoff;

        public Decision(boolean shouldRetry, long backoff) {
            this.shouldRetry = shouldRetry;
            this.backoff = backoff;
        }

        public boolean shouldRetry() {
            return this.shouldRetry;
        }

        public long backoff() {
            return this.backoff;
        }

        public String toString() {
            return "Decision(shouldRetry=" + this.shouldRetry + ", backoff=" + this.backoff + ")";
        }
    }

    public static class Exponential
    implements RetryPolicy {
        private final long base;
        private final long max;

        public Exponential(long base, long max) {
            this.base = base;
            this.max = max;
        }

        @Override
        public Instance apply(ClockSource clockSource) {
            return new ExponentialInstance();
        }

        public String toString() {
            return "Exponential(base=" + this.base + ", base=" + this.base + ")";
        }

        private class ExponentialInstance
        implements Instance {
            int attempt = 0;

            private ExponentialInstance() {
            }

            @Override
            public Decision next() {
                return new Decision(true, this.calculateBackoff());
            }

            private long calculateBackoff() {
                if (this.attempt < 0) {
                    return Exponential.this.max;
                }
                int a = this.attempt++;
                long candidate = (long)((double)Exponential.this.base * Math.pow(2.0, a));
                if (candidate <= Exponential.this.max) {
                    return candidate;
                }
                this.attempt = -1;
                return Exponential.this.max;
            }
        }
    }

    public static class Linear
    implements RetryPolicy {
        private final long backoff;

        public Linear(long backoff) {
            this.backoff = backoff;
        }

        @Override
        public Instance apply(ClockSource clockSource) {
            Decision decision = new Decision(true, this.backoff);
            return () -> decision;
        }

        public String toString() {
            return "Linear(backoff=" + this.backoff + ")";
        }
    }

    public static class Timed
    implements RetryPolicy {
        private final long duration;
        private final RetryPolicy policy;

        public Timed(long duration, RetryPolicy policy) {
            this.duration = duration;
            this.policy = policy;
        }

        @Override
        public Instance apply(ClockSource clockSource) {
            long deadline = clockSource.now() + this.duration;
            Instance inner = this.policy.apply(clockSource);
            return () -> {
                Decision child = inner.next();
                boolean shouldRetry = clockSource.now() < deadline && child.shouldRetry();
                return new Decision(shouldRetry, child.backoff());
            };
        }

        public String toString() {
            return "Timed(duration=" + this.duration + ", policy=" + this.policy + ")";
        }
    }
}

