/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer;

import eu.toolchain.serializer.ArrayConstructor;
import eu.toolchain.serializer.BytesSerialWriter;
import eu.toolchain.serializer.LengthPolicy;
import eu.toolchain.serializer.SerialReader;
import eu.toolchain.serializer.SerialWriter;
import eu.toolchain.serializer.Serializer;
import eu.toolchain.serializer.StreamSerialWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.UUID;

public interface SerializerFramework {
    public Serializer<String> string();

    public Serializer<Byte> fixedByte();

    public Serializer<Boolean> fixedBoolean();

    public Serializer<Short> fixedShort();

    public Serializer<Integer> fixedInteger();

    public Serializer<Long> fixedLong();

    public Serializer<Float> fixedFloat();

    public Serializer<Double> fixedDouble();

    public Serializer<Character> fixedCharacter();

    public Serializer<Integer> variableInteger();

    public Serializer<Long> variableLong();

    @Deprecated
    public Serializer<Boolean> bool();

    @Deprecated
    public Serializer<Short> shortNumber();

    @Deprecated
    public Serializer<Integer> integer();

    @Deprecated
    public Serializer<Long> longNumber();

    @Deprecated
    public Serializer<Float> floatNumber();

    @Deprecated
    public Serializer<Double> doubleNumber();

    @Deprecated
    public Serializer<Integer> varint();

    @Deprecated
    public Serializer<Long> varlong();

    public <T> Serializer<T> nullable(Serializer<T> var1);

    public <T> Serializer<T> prefix(int var1, Serializer<T> var2);

    public <T> Serializer<T> prefix(byte[] var1, Serializer<T> var2);

    public <T> Serializer<T> lengthPrefixed(Serializer<T> var1, LengthPolicy var2);

    public <T> Serializer<T> lengthPrefixed(Serializer<T> var1);

    public <T> Serializer<List<T>> list(Serializer<T> var1);

    public <K, V> Serializer<Map<K, V>> map(Serializer<K> var1, Serializer<V> var2);

    public <K extends Comparable<?>, V> Serializer<SortedMap<K, V>> sortedMap(Serializer<K> var1, Serializer<V> var2);

    public <K extends Comparable<?>, V> Serializer<NavigableMap<K, V>> navigableMap(Serializer<K> var1, Serializer<V> var2);

    public <T> Serializer<Set<T>> set(Serializer<T> var1);

    public <T extends Comparable<?>> Serializer<SortedSet<T>> sortedSet(Serializer<T> var1);

    public <T extends Comparable<?>> Serializer<NavigableSet<T>> navigableSet(Serializer<T> var1);

    public <T> Serializer<T[]> array(Serializer<T> var1, ArrayConstructor<T> var2);

    public Serializer<boolean[]> booleanArray();

    public Serializer<short[]> shortArray();

    public Serializer<int[]> intArray();

    public Serializer<long[]> longArray();

    public Serializer<float[]> floatArray();

    public Serializer<double[]> doubleArray();

    public Serializer<byte[]> byteArray();

    public Serializer<char[]> charArray();

    public Serializer<UUID> uuid();

    public Serializer<BitSet> bitSet();

    public <T> Serializer<Optional<T>> optional(Serializer<T> var1);

    public <T extends Enum<T>> Serializer<T> forEnum(T[] var1);

    public <T extends Enum<T>> Serializer<T> forEnum(T[] var1, T var2);

    public <T> Serializer<T> notImplemented();

    public <T extends S, S> TypeMapping<T, S> type(int var1, Class<T> var2, Serializer<T> var3);

    public <T> Serializer<T> subtypes(Iterable<? extends TypeMapping<? extends T, T>> var1);

    public <T> Serializer<T> singleton(T var1);

    public <T> ByteBuffer serialize(Serializer<T> var1, T var2) throws IOException;

    public <T> T deserialize(Serializer<T> var1, ByteBuffer var2) throws IOException;

    public SerialWriter writeByteBuffer(ByteBuffer var1);

    public SerialReader readByteBuffer(ByteBuffer var1);

    public SerialWriter writeByteChannel(WritableByteChannel var1);

    public SerialReader readByteChannel(ReadableByteChannel var1);

    public BytesSerialWriter writeBytes();

    public SerialReader readByteArray(byte[] var1);

    public StreamSerialWriter writeStream(OutputStream var1);

    public SerialReader readStream(InputStream var1);

    public static class TypeMapping<T extends S, S> {
        final int id;
        final Class<T> key;
        final Serializer<T> serializer;

        public TypeMapping(int id, Class<T> key, Serializer<T> serializer) {
            this.id = id;
            this.key = key;
            this.serializer = serializer;
        }

        public int id() {
            return this.id;
        }

        public Class<T> key() {
            return this.key;
        }

        public Serializer<T> serializer() {
            return this.serializer;
        }
    }
}

