/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.toolchain.serializer.processor.AutoSerializeProcessor;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.FrameworkStatements;
import eu.toolchain.serializer.processor.ShortIterator;
import eu.toolchain.serializer.processor.annotation.AutoSerializeMirror;
import eu.toolchain.serializer.processor.annotation.SubTypeMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import eu.toolchain.serializer.processor.value.ValueSubType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Generated;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

public class AutoSerializeAbstractProcessor {
    final Elements elements;
    final FrameworkStatements statements;
    final AutoSerializeUtils utils;

    public Unverified<JavaFile> process(TypeElement element, AutoSerializeMirror autoSerialize) {
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        String serializerName = this.utils.serializerName(element);
        TypeName elementType = TypeName.get((TypeMirror)element.asType());
        TypeName supertype = TypeName.get((TypeMirror)this.utils.serializerFor(element.asType()));
        return this.subTypes(element, packageName).map(subTypes -> {
            TypeSpec.Builder generated = TypeSpec.classBuilder((String)serializerName);
            AnnotationSpec generatedAnnotation = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{AutoSerializeProcessor.class.getCanonicalName()}).build();
            generated.addAnnotation(generatedAnnotation);
            FieldSpec serializer = FieldSpec.builder((TypeName)supertype, (String)"serializer", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
            generated.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            generated.addSuperinterface(supertype);
            generated.addField(serializer);
            generated.addMethod(this.constructor(elementType, serializer, (List<ValueSubType>)subTypes));
            generated.addMethod(this.serialize(elementType, serializer));
            generated.addMethod(this.derialize(elementType, serializer));
            return JavaFile.builder((String)packageName, (TypeSpec)generated.build()).skipJavaLangImports(true).indent("    ").build();
        });
    }

    MethodSpec constructor(TypeName elementType, FieldSpec serializer, List<ValueSubType> subtypes) {
        ClassName list = ClassName.get(List.class);
        ClassName typeMapping = this.utils.typeMapping();
        ClassName arrayList = ClassName.get(ArrayList.class);
        ParameterSpec framework = ParameterSpec.builder((TypeName)this.utils.serializerFramework(), (String)"framework", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        MethodSpec.Builder b = MethodSpec.constructorBuilder();
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.addParameter(framework);
        b.addStatement("final $T<$T<? extends $T, $T>> mappings = new $T<>()", new Object[]{list, typeMapping, elementType, elementType, arrayList});
        for (ValueSubType subtype : subtypes) {
            ClassName serializerType = this.utils.serializerClassFor(subtype.getType());
            b.addStatement("mappings.add($N.<$T, $T>type($L, $T.class, new $T($N)))", new Object[]{framework, subtype.getType(), elementType, subtype.getId(), subtype.getType(), serializerType, framework});
        }
        b.addStatement("$N = $N.subtypes(mappings)", new Object[]{serializer, framework});
        return b.build();
    }

    MethodSpec serialize(TypeName valueType, FieldSpec serializer) {
        ParameterSpec buffer = this.utils.parameter((TypeName)this.utils.serialWriter(), "buffer");
        ParameterSpec value = this.utils.parameter(valueType, "value");
        return this.utils.serializeMethod(buffer, value).addStatement("$N.serialize($N, $N)", new Object[]{serializer, buffer, value}).build();
    }

    MethodSpec derialize(TypeName returnType, FieldSpec serializer) {
        ParameterSpec buffer = this.utils.parameter((TypeName)this.utils.serialReader(), "buffer");
        return this.utils.deserializeMethod(returnType, buffer).addStatement("return $N.deserialize($N)", new Object[]{serializer, buffer}).build();
    }

    Unverified<List<ValueSubType>> subTypes(Element element, String defaultPackageName) {
        return this.utils.subTypes(element).map(unverifiedSubTypes -> unverifiedSubTypes.transform(subTypes -> {
            HashSet<Short> seenIds = new HashSet<Short>();
            int offset = 0;
            ShortIterator index = new ShortIterator();
            ImmutableList.Builder results = ImmutableList.builder();
            for (SubTypeMirror s : subTypes.getSubTypes()) {
                DeclaredType type = (DeclaredType)s.getValue().get();
                short id = s.getId().orElseGet(index::next);
                if (!seenIds.add(id)) {
                    results.add(Unverified.brokenElement(String.format("Conflicting subtype id (%d) defined for definition #%d", id, offset), element));
                    continue;
                }
                results.add(Unverified.verified(new ValueSubType(type, id)));
                ++offset;
            }
            return Unverified.combine(results.build());
        })).orElse(Unverified.verified(ImmutableList.of()));
    }

    @ConstructorProperties(value={"elements", "statements", "utils"})
    public AutoSerializeAbstractProcessor(Elements elements, FrameworkStatements statements, AutoSerializeUtils utils) {
        this.elements = elements;
        this.statements = statements;
        this.utils = utils;
    }
}

