/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import eu.toolchain.serializer.processor.AutoSerializeProcessor;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.FrameworkMethodBuilder;
import eu.toolchain.serializer.processor.FrameworkStatements;
import eu.toolchain.serializer.processor.annotation.AutoSerializeMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import eu.toolchain.serializer.processor.value.Value;
import eu.toolchain.serializer.processor.value.ValueSet;
import eu.toolchain.serializer.processor.value.ValueType;
import eu.toolchain.serializer.processor.value.ValueTypeBuilder;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AutoSerializeClassProcessor {
    private static final Joiner parameterJoiner = Joiner.on((String)",");
    final Types types;
    final Elements elements;
    final FrameworkStatements statements;
    final AutoSerializeUtils utils;

    public Unverified<JavaFile> process(TypeElement element, AutoSerializeMirror autoSerialize) {
        String packageName = this.elements.getPackageOf(element).getQualifiedName().toString();
        Set<ElementKind> kinds = this.getKinds(element);
        Unverified<Optional<ValueTypeBuilder>> unverifiedBuilder = ValueTypeBuilder.build(this.utils, element, autoSerialize);
        Unverified<ValueSet> unverifiedFields = ValueSet.build(this.utils, element, kinds, autoSerialize);
        ClassName elementType = (ClassName)TypeName.get((TypeMirror)element.asType());
        TypeName supertype = TypeName.get((TypeMirror)this.utils.serializerFor(element.asType()));
        String serializerName = this.utils.serializerName(element);
        Unverified<?> combineDifferent = Unverified.combineDifferent(unverifiedFields, unverifiedBuilder);
        boolean fieldBased = autoSerialize.isFieldBased();
        boolean failOnMissing = autoSerialize.isFailOnMissing();
        TypeElement stringType = this.elements.getTypeElement(String.class.getCanonicalName());
        TypeElement integerType = this.elements.getTypeElement(Integer.class.getCanonicalName());
        return combineDifferent.map(o -> {
            ValueSet values = (ValueSet)unverifiedFields.get();
            Optional builder = (Optional)unverifiedBuilder.get();
            TypeSpec.Builder generated = TypeSpec.classBuilder((String)serializerName);
            AnnotationSpec generatedAnnotation = AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{AutoSerializeProcessor.class.getCanonicalName()}).build();
            generated.addAnnotation(generatedAnnotation);
            FieldSpec count = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.utils.serializerFor(integerType.asType())), (String)"count", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
            FieldSpec name = FieldSpec.builder((TypeName)TypeName.get((TypeMirror)this.utils.serializerFor(stringType.asType())), (String)"name", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
            if (fieldBased) {
                generated.addField(count);
                generated.addField(name);
            }
            for (ValueType t : values.getTypes()) {
                generated.addField(t.getFieldSpec());
            }
            generated.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            generated.addSuperinterface(supertype);
            if (fieldBased) {
                generated.addMethod(this.fieldConstructor(values, count, name));
                generated.addMethod(this.fieldSerializeMethod((TypeName)elementType, values, count, name));
                generated.addMethod(this.fieldDeserializeMethod(elementType, values, builder, count, name, failOnMissing));
            } else {
                generated.addMethod(this.serialConstructor(values));
                generated.addMethod(this.serialSerializeMethod((TypeName)elementType, values));
                generated.addMethod(this.serialDeserializeMethod(elementType, values, builder));
            }
            return JavaFile.builder((String)packageName, (TypeSpec)generated.build()).skipJavaLangImports(true).indent("    ").build();
        });
    }

    Set<ElementKind> getKinds(TypeElement element) {
        ImmutableSet.Builder kinds = ImmutableSet.builder();
        if (element.getKind() == ElementKind.INTERFACE) {
            kinds.add((Object)ElementKind.METHOD);
        }
        if (element.getKind() == ElementKind.CLASS) {
            kinds.add((Object)ElementKind.FIELD);
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                kinds.add((Object)ElementKind.METHOD);
            }
        }
        return kinds.build();
    }

    MethodSpec serialConstructor(ValueSet values) {
        ParameterSpec framework = ParameterSpec.builder((TypeName)this.utils.serializerFramework(), (String)"framework", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        final MethodSpec.Builder b = MethodSpec.constructorBuilder();
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.addParameter(framework);
        for (ValueType t : values.getOrderedTypes()) {
            if (!t.getProvidedParameterSpec().isPresent()) continue;
            b.addParameter(t.getProvidedParameterSpec().get());
        }
        for (final ValueType fieldType : values.getOrderedTypes()) {
            if (fieldType.getProvidedParameterSpec().isPresent()) {
                b.addStatement("$N = $N", new Object[]{fieldType.getFieldSpec(), fieldType.getProvidedParameterSpec().get()});
                continue;
            }
            FrameworkMethodBuilder builder = new FrameworkMethodBuilder(){

                @Override
                public void assign(String statement, List<Object> arguments) {
                    b.addStatement(String.format("$N = %s", statement), ImmutableList.builder().add((Object)fieldType.getFieldSpec()).addAll(arguments).build().toArray());
                }
            };
            this.statements.resolveStatement(this.utils.boxedIfNeeded(fieldType.getTypeMirror()), framework).writeTo(builder);
        }
        return b.build();
    }

    MethodSpec fieldConstructor(ValueSet values, FieldSpec count, FieldSpec name) {
        ParameterSpec framework = ParameterSpec.builder((TypeName)this.utils.serializerFramework(), (String)"framework", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        final MethodSpec.Builder b = MethodSpec.constructorBuilder();
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.addParameter(framework);
        b.addStatement("$N = $N.variableInteger()", new Object[]{count, framework});
        b.addStatement("$N = $N.string()", new Object[]{name, framework});
        for (ValueType t : values.getOrderedTypes()) {
            if (!t.getProvidedParameterSpec().isPresent()) continue;
            b.addParameter(t.getProvidedParameterSpec().get());
        }
        for (final ValueType fieldType : values.getOrderedTypes()) {
            if (fieldType.getProvidedParameterSpec().isPresent()) {
                b.addStatement("$N = $N", new Object[]{fieldType.getFieldSpec(), fieldType.getProvidedParameterSpec().get()});
                continue;
            }
            FrameworkMethodBuilder builder = new FrameworkMethodBuilder(){

                @Override
                public void assign(String statement, List<Object> arguments) {
                    b.addStatement(String.format("$N = %s", statement), ImmutableList.builder().add((Object)fieldType.getFieldSpec()).addAll(arguments).build().toArray());
                }
            };
            this.statements.resolveStatement(this.utils.boxedIfNeeded(fieldType.getTypeMirror()), framework).writeTo(builder);
        }
        return b.build();
    }

    MethodSpec fieldSerializeMethod(TypeName valueType, ValueSet serialized, FieldSpec count, FieldSpec name) {
        ParameterSpec buffer = this.utils.parameter((TypeName)this.utils.serialWriter(), "buffer");
        ParameterSpec value = this.utils.parameter(valueType, "value");
        MethodSpec.Builder b = this.utils.serializeMethod(buffer, value);
        b.addStatement("$N.serialize($N, $L)", new Object[]{count, buffer, serialized.getValues().size()});
        for (Value field : serialized.getOrderedValues()) {
            if (field.getType().isOptional()) {
                b.addStatement("final $T $N = $N.$L()", new Object[]{field.getType().getTypeName(), field.getVariableName(), value, field.getAccessor()});
                b.beginControlFlow("if ($N.isPresent())", new Object[]{field.getVariableName()});
                b.addStatement("$N.serialize($N, $S)", new Object[]{name, buffer, field.getName()});
                b.beginControlFlow("try (final $T w = $N.scope())", new Object[]{this.utils.serialWriter(), buffer});
                b.addStatement("$N.serialize(w, $N)", new Object[]{field.getType().getFieldSpec(), field.getVariableName()});
                b.endControlFlow();
                b.endControlFlow();
                continue;
            }
            b.addStatement("$N.serialize($N, $S)", new Object[]{name, buffer, field.getName()});
            b.beginControlFlow("try (final $T w = $N.scope())", new Object[]{this.utils.serialWriter(), buffer});
            b.addStatement("$N.serialize(w, $N.$L())", new Object[]{field.getType().getFieldSpec(), value, field.getAccessor()});
            b.endControlFlow();
        }
        return b.build();
    }

    MethodSpec fieldDeserializeMethod(ClassName returnType, ValueSet serializedType, Optional<ValueTypeBuilder> typeBuilder, FieldSpec count, FieldSpec name, boolean failOnMissing) {
        ParameterSpec buffer = this.utils.parameter((TypeName)this.utils.serialReader(), "buffer");
        MethodSpec.Builder b = this.utils.deserializeMethod((TypeName)returnType, buffer);
        for (Value field : serializedType.getOrderedValues()) {
            TypeName fieldType = field.getType().getTypeName();
            if (field.getType().isOptional()) {
                b.addStatement("$T $L = $T.empty()", new Object[]{fieldType, field.getVariableName(), this.utils.optional()});
                continue;
            }
            b.addStatement("$T $L = $L", new Object[]{fieldType, field.getVariableName(), this.utils.initLiteral(field.getType().getTypeMirror())});
            b.addStatement("boolean $L = false", new Object[]{field.getIsSetVariableName()});
        }
        b.addStatement("final int total = $N.deserialize($N)", new Object[]{count, buffer});
        b.addStatement("int i = 0", new Object[0]);
        b.beginControlFlow("while (i++ < total)", new Object[0]);
        b.addStatement("final String fieldName = $N.deserialize($N)", new Object[]{name, buffer});
        b.beginControlFlow("switch (fieldName)", new Object[0]);
        for (Value field : serializedType.getOrderedValues()) {
            b.addCode("case $S:\n", new Object[]{field.getName()});
            b.addCode("$>", new Object[0]);
            b.beginControlFlow("try (final $T r = $N.scope())", new Object[]{this.utils.serialReader(), buffer});
            b.addStatement("$N = $N.deserialize(r)", new Object[]{field.getVariableName(), field.getType().getFieldSpec()});
            b.endControlFlow();
            if (!field.getType().isOptional()) {
                b.addStatement("$N = true", new Object[]{field.getIsSetVariableName()});
            }
            b.addStatement("break", new Object[0]);
            b.addCode("$<", new Object[0]);
        }
        b.addCode("default:\n", new Object[0]);
        b.addCode("$>", new Object[0]);
        if (failOnMissing) {
            b.addStatement("throw new $T($S + fieldName)", new Object[]{this.utils.ioException(), "Attempting to assign non-existing field: "});
        } else {
            b.addStatement("$N.skip()", new Object[]{buffer});
            b.addStatement("break", new Object[0]);
        }
        b.addCode("$<", new Object[0]);
        b.endControlFlow();
        b.endControlFlow();
        for (Value field : serializedType.getOrderedValues()) {
            if (field.getType().isOptional()) continue;
            b.beginControlFlow("if (!$N)", new Object[]{field.getIsSetVariableName()});
            b.addStatement("throw new $T($S)", new Object[]{this.utils.ioException(), "Missing required field: " + field.getName()});
            b.endControlFlow();
        }
        if (typeBuilder.isPresent()) {
            typeBuilder.get().writeTo(returnType, b, serializedType.getValues());
        } else {
            b.addStatement("return new $T($L)", new Object[]{returnType, parameterJoiner.join(serializedType.getConstructorVariables())});
        }
        return b.build();
    }

    MethodSpec serialSerializeMethod(TypeName valueType, ValueSet serialized) {
        ParameterSpec buffer = this.utils.parameter((TypeName)this.utils.serialWriter(), "buffer");
        ParameterSpec value = this.utils.parameter(valueType, "value");
        MethodSpec.Builder b = this.utils.serializeMethod(buffer, value);
        for (Value field : serialized.getOrderedValues()) {
            b.addStatement("$N.serialize($N, $N.$L())", new Object[]{field.getType().getFieldSpec(), buffer, value, field.getAccessor()});
        }
        return b.build();
    }

    MethodSpec serialDeserializeMethod(ClassName returnType, ValueSet serializedType, Optional<ValueTypeBuilder> typeBuilder) {
        ParameterSpec buffer = this.utils.parameter((TypeName)this.utils.serialReader(), "buffer");
        MethodSpec.Builder b = this.utils.deserializeMethod((TypeName)returnType, buffer);
        for (Value field : serializedType.getOrderedValues()) {
            TypeName fieldType = field.getType().getTypeName();
            FieldSpec fieldSpec = field.getType().getFieldSpec();
            b.addStatement("final $T $L = $N.deserialize($N)", new Object[]{fieldType, field.getVariableName(), fieldSpec, buffer});
        }
        if (typeBuilder.isPresent()) {
            typeBuilder.get().writeTo(returnType, b, serializedType.getValues());
        } else {
            b.addStatement("return new $T($L)", new Object[]{returnType, parameterJoiner.join(serializedType.getConstructorVariables())});
        }
        return b.build();
    }

    @ConstructorProperties(value={"types", "elements", "statements", "utils"})
    public AutoSerializeClassProcessor(Types types, Elements elements, FrameworkStatements statements, AutoSerializeUtils utils) {
        this.types = types;
        this.elements = elements;
        this.statements = statements;
        this.utils = utils;
    }
}

