/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import eu.toolchain.serializer.AutoSerialize;
import eu.toolchain.serializer.DefaultBuilderType;
import eu.toolchain.serializer.SerialReader;
import eu.toolchain.serializer.SerialWriter;
import eu.toolchain.serializer.Serializer;
import eu.toolchain.serializer.SerializerFramework;
import eu.toolchain.serializer.processor.annotation.AnnotationValues;
import eu.toolchain.serializer.processor.annotation.AutoSerializeMirror;
import eu.toolchain.serializer.processor.annotation.BuilderMirror;
import eu.toolchain.serializer.processor.annotation.FieldMirror;
import eu.toolchain.serializer.processor.annotation.IgnoreMirror;
import eu.toolchain.serializer.processor.annotation.SubTypeMirror;
import eu.toolchain.serializer.processor.annotation.SubTypesMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class AutoSerializeUtils {
    public static final String SERIALIZER_NAME_FORMAT = "%s_Serializer";
    public static final Joiner underscoreJoiner = Joiner.on((char)'_');
    public static final String SERIALIZER = Serializer.class.getCanonicalName();
    public static final String AUTOSERIALIZE = AutoSerialize.class.getCanonicalName();
    public static final String AUTOSERIALIZE_IGNORE = AutoSerialize.Ignore.class.getCanonicalName();
    public static final String AUTOSERIALIZE_BUILDER = AutoSerialize.Builder.class.getCanonicalName();
    public static final String AUTOSERIALIZE_SUBTYPE = AutoSerialize.SubType.class.getCanonicalName();
    public static final String AUTOSERIALIZE_SUBTYPES = AutoSerialize.SubTypes.class.getCanonicalName();
    public static final String AUTOSERIALIZE_FIELD = AutoSerialize.Field.class.getCanonicalName();
    public static final String SERIALIZER_FRAMEWORK = SerializerFramework.class.getCanonicalName();
    public static final String SERIAL_READER = SerialReader.class.getCanonicalName();
    public static final String SERIAL_WRITER = SerialWriter.class.getCanonicalName();
    public static final String TYPE_MAPPING = SerializerFramework.TypeMapping.class.getCanonicalName();
    public static final String DEFAULT_BUILDER_TYPE = DefaultBuilderType.class.getCanonicalName();
    public static final String OPTIONAL = Optional.class.getCanonicalName();
    public static final String IO_EXCEPTION = IOException.class.getCanonicalName();
    final Types types;
    final Elements elements;
    final TypeElement serializer;
    final TypeElement autoSerializeType;

    public AutoSerializeUtils(Types types, Elements elements) {
        this.types = types;
        this.elements = elements;
        this.serializer = elements.getTypeElement(SERIALIZER);
        this.autoSerializeType = elements.getTypeElement(AUTOSERIALIZE);
    }

    public MethodSpec.Builder deserializeMethod(TypeName returnType, ParameterSpec buffer) {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"deserialize");
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.returns(returnType);
        b.addAnnotation(Override.class);
        b.addParameter(buffer);
        b.addException(IOException.class);
        return b;
    }

    public MethodSpec.Builder serializeMethod(ParameterSpec buffer, ParameterSpec value) {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"serialize");
        b.addModifiers(new Modifier[]{Modifier.PUBLIC});
        b.returns(TypeName.VOID);
        b.addAnnotation(Override.class);
        b.addParameter(buffer);
        b.addParameter(value);
        b.addException(IOException.class);
        return b;
    }

    public ParameterSpec parameter(TypeName type, String name) {
        return ParameterSpec.builder((TypeName)type, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
    }

    public TypeMirror serializerFor(TypeMirror type) {
        return this.types.getDeclaredType(this.serializer, this.boxedIfNeeded(type));
    }

    public boolean isPrimitive(TypeMirror type) {
        return type instanceof PrimitiveType;
    }

    public TypeMirror boxedIfNeeded(TypeMirror type) {
        if (type instanceof PrimitiveType) {
            return this.types.boxedClass((PrimitiveType)type).asType();
        }
        return type;
    }

    public Optional<ClassName> pullMirroredClass(Supplier<Class<?>> supplier, String defaultPackageName) {
        try {
            return Optional.of(ClassName.get(supplier.get()));
        }
        catch (MirroredTypeException e) {
            return this.buildClassName(e, e.getTypeMirror(), defaultPackageName);
        }
    }

    private Optional<ClassName> buildClassName(MirroredTypeException e, TypeMirror type, String defaultPackageName) {
        if (type instanceof ErrorType) {
            return Optional.empty();
        }
        return Optional.of((ClassName)TypeName.get((TypeMirror)type));
    }

    public TypeElement refetch(TypeElement element) {
        return this.elements.getTypeElement(element.getQualifiedName());
    }

    public List<AnnotationMirror> getAnnotations(Element element, String lookFor) {
        ImmutableList.Builder results = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(lookFor)) continue;
            results.add((Object)annotationMirror);
        }
        return results.build();
    }

    public AnnotationValues getElementValuesWithDefaults(Element element, AnnotationMirror a) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : this.elements.getElementValuesWithDefaults(a).entrySet()) {
            builder.put((Object)e.getKey().getSimpleName().toString(), (Object)e.getValue());
        }
        return new AnnotationValues(element, a, (Map<String, AnnotationValue>)builder.build());
    }

    public <T extends Annotation> Optional<AnnotationMirror> annotation(Element element, String annotationType) {
        Iterator<AnnotationMirror> iterator = this.getAnnotations(element, annotationType).iterator();
        if (iterator.hasNext()) {
            AnnotationMirror a = iterator.next();
            return Optional.of(a);
        }
        return Optional.empty();
    }

    public Optional<Unverified<AutoSerializeMirror>> autoSerialize(Element element) {
        return this.annotation(element, AUTOSERIALIZE).map(a -> AutoSerializeMirror.getFor(this, element, a));
    }

    public Optional<Unverified<SubTypeMirror>> subType(Element element) {
        return this.annotation(element, AUTOSERIALIZE_SUBTYPE).map(a -> SubTypeMirror.getFor(this, element, a));
    }

    public Optional<Unverified<SubTypesMirror>> subTypes(Element element) {
        return this.annotation(element, AUTOSERIALIZE_SUBTYPES).map(a -> SubTypesMirror.getFor(this, element, a));
    }

    public Optional<FieldMirror> field(Element element) {
        return this.annotation(element, AUTOSERIALIZE_FIELD).map(a -> FieldMirror.getFor(this, element, a));
    }

    public Optional<Unverified<BuilderMirror>> builder(Element element) {
        return this.annotation(element, AUTOSERIALIZE_BUILDER).map(a -> BuilderMirror.getFor(this, element, a));
    }

    public Optional<IgnoreMirror> ignore(Element element) {
        return this.annotation(element, AUTOSERIALIZE_IGNORE).map(a -> IgnoreMirror.getFor(this, element, a));
    }

    public TypeElement autoSerializeType() {
        return this.autoSerializeType;
    }

    public ClassName serializerFramework() {
        return ClassName.get((TypeElement)this.elements.getTypeElement(SERIALIZER_FRAMEWORK));
    }

    public ClassName serialReader() {
        return ClassName.get((TypeElement)this.elements.getTypeElement(SERIAL_READER));
    }

    public ClassName serialWriter() {
        return ClassName.get((TypeElement)this.elements.getTypeElement(SERIAL_WRITER));
    }

    public ClassName typeMapping() {
        return ClassName.get((TypeElement)this.elements.getTypeElement(TYPE_MAPPING));
    }

    public ClassName optional() {
        return ClassName.get((TypeElement)this.elements.getTypeElement(OPTIONAL));
    }

    public ClassName ioException() {
        return ClassName.get((TypeElement)this.elements.getTypeElement(IO_EXCEPTION));
    }

    public boolean isOptional(TypeMirror valueType) {
        if (!(valueType instanceof DeclaredType)) {
            return false;
        }
        DeclaredType d = (DeclaredType)valueType;
        TypeElement t = (TypeElement)d.asElement();
        return t.getQualifiedName().toString().equals(Optional.class.getCanonicalName());
    }

    public String initLiteral(TypeMirror type) {
        if (!(type instanceof PrimitiveType)) {
            return "null";
        }
        PrimitiveType p = (PrimitiveType)type;
        switch (p.getKind()) {
            case BOOLEAN: {
                return "false";
            }
            case SHORT: {
                return "0";
            }
            case INT: {
                return "0";
            }
            case LONG: {
                return "0L";
            }
            case FLOAT: {
                return "0f";
            }
            case DOUBLE: {
                return "0d";
            }
            case BYTE: {
                return "0";
            }
            case CHAR: {
                return "'\u0000'";
            }
        }
        throw new IllegalArgumentException("Unsupported primitive: " + type.toString());
    }

    public String serializerName(Element root) {
        ImmutableList.Builder parts = ImmutableList.builder();
        Element element = root;
        do {
            if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                throw new IllegalArgumentException(String.format("Element is not interface or class (%s)", element));
            }
            if (element.getEnclosingElement().getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                throw new IllegalArgumentException(String.format("Nested element must be static (%s)", element));
            }
            parts.add((Object)element.getSimpleName().toString());
        } while ((element = element.getEnclosingElement()).getKind() != ElementKind.PACKAGE);
        return String.format(SERIALIZER_NAME_FORMAT, underscoreJoiner.join((Iterable)parts.build().reverse()));
    }

    public ClassName serializerClassFor(DeclaredType type) {
        String pkg = this.elements.getPackageOf(type.asElement()).getQualifiedName().toString();
        String name = this.serializerName(type.asElement());
        return ClassName.get((String)pkg, (String)name, (String[])new String[0]);
    }

    @ConstructorProperties(value={"types", "elements", "serializer", "autoSerializeType"})
    public AutoSerializeUtils(Types types, Elements elements, TypeElement serializer, TypeElement autoSerializeType) {
        this.types = types;
        this.elements = elements;
        this.serializer = serializer;
        this.autoSerializeType = autoSerializeType;
    }
}

