/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.element.TypeElement;

public class DeferredProcessing {
    private final TypeElement element;
    private final Optional<Unverified<?>> broken;

    public static Function<DeferredProcessing, DeferredProcessing> refresh(AutoSerializeUtils utils) {
        return d -> new DeferredProcessing(utils.refetch(d.element), Optional.empty());
    }

    public DeferredProcessing withBroken(Unverified<?> broken) {
        return new DeferredProcessing(this.element, Optional.of(broken));
    }

    @ConstructorProperties(value={"element", "broken"})
    public DeferredProcessing(TypeElement element, Optional<Unverified<?>> broken) {
        this.element = element;
        this.broken = broken;
    }

    public TypeElement getElement() {
        return this.element;
    }

    public Optional<Unverified<?>> getBroken() {
        return this.broken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeferredProcessing)) {
            return false;
        }
        DeferredProcessing other = (DeferredProcessing)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TypeElement this$element = this.getElement();
        TypeElement other$element = other.getElement();
        if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
            return false;
        }
        Optional<Unverified<?>> this$broken = this.getBroken();
        Optional<Unverified<?>> other$broken = other.getBroken();
        return !(this$broken == null ? other$broken != null : !((Object)this$broken).equals(other$broken));
    }

    public boolean canEqual(Object other) {
        return other instanceof DeferredProcessing;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TypeElement $element = this.getElement();
        result = result * 59 + ($element == null ? 0 : $element.hashCode());
        Optional<Unverified<?>> $broken = this.getBroken();
        result = result * 59 + ($broken == null ? 0 : ((Object)$broken).hashCode());
        return result;
    }

    public String toString() {
        return "DeferredProcessing(element=" + this.getElement() + ", broken=" + this.getBroken() + ")";
    }
}

