/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor;

import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class Naming {
    static final ClassName optionalType = ClassName.get(Optional.class);
    private final String prefix;
    private final Set<String> seen = new HashSet<String>();

    public String forName(String name) {
        return this.makeUnique(String.format("%s%s", this.prefix, name));
    }

    public String forType(TypeName fieldType, boolean provided) {
        return this.makeUnique(String.format(provided ? "%sProvided%s" : "%s%s", this.prefix, this.composeName(fieldType)));
    }

    private String makeUnique(String base) {
        int index = 1;
        String candidate = base;
        while (this.seen.contains(candidate)) {
            candidate = String.format("%s%d", base, index++);
        }
        this.seen.add(candidate);
        return candidate;
    }

    private String composeName(TypeName fieldType) {
        if (fieldType instanceof ClassName) {
            ClassName c = (ClassName)fieldType;
            return c.simpleName();
        }
        if (fieldType instanceof ParameterizedTypeName) {
            ParameterizedTypeName p = (ParameterizedTypeName)fieldType;
            if (p.rawType.equals((Object)optionalType)) {
                return "Optional" + this.composeName((TypeName)p.typeArguments.iterator().next());
            }
            return p.rawType.simpleName();
        }
        if (fieldType instanceof ArrayTypeName) {
            ArrayTypeName a = (ArrayTypeName)fieldType;
            return this.composeName(a.componentType) + "Array";
        }
        if (fieldType.isPrimitive()) {
            return this.composePrimitive(fieldType);
        }
        throw new IllegalArgumentException("Cannot compose name from " + fieldType.toString());
    }

    private String composePrimitive(TypeName fieldType) {
        if (fieldType.equals((Object)TypeName.BOOLEAN)) {
            return "Boolean";
        }
        if (fieldType.equals((Object)TypeName.BYTE)) {
            return "Byte";
        }
        if (fieldType.equals((Object)TypeName.SHORT)) {
            return "Short";
        }
        if (fieldType.equals((Object)TypeName.INT)) {
            return "Integer";
        }
        if (fieldType.equals((Object)TypeName.LONG)) {
            return "Long";
        }
        if (fieldType.equals((Object)TypeName.CHAR)) {
            return "Character";
        }
        if (fieldType.equals((Object)TypeName.FLOAT)) {
            return "Float";
        }
        if (fieldType.equals((Object)TypeName.DOUBLE)) {
            return "Double";
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + fieldType);
    }

    @ConstructorProperties(value={"prefix"})
    public Naming(String prefix) {
        this.prefix = prefix;
    }
}

