/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.annotation;

import com.google.common.collect.ImmutableList;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public class AnnotationValues {
    private final Element element;
    private final AnnotationMirror annotation;
    private final Map<String, AnnotationValue> values;

    public AnnotationValue get(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        return annotationValue;
    }

    public Value<Boolean> getBoolean(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        return new Value<Boolean>(annotationValue, this.toBoolean(annotationValue));
    }

    public Unverified<Value<TypeMirror>> getTypeMirror(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        TypeMirror typeMirror = this.toTypeMirror(annotationValue);
        if (typeMirror == null) {
            return Unverified.brokenAnnotationValue("Could not resolve type", this.element, this.annotation, annotationValue);
        }
        if (typeMirror instanceof ErrorType) {
            return Unverified.brokenAnnotationValue("Could not resolve type", this.element, this.annotation, annotationValue);
        }
        return Unverified.verified(new Value<TypeMirror>(annotationValue, typeMirror));
    }

    public Value<String> getString(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        return new Value<String>(annotationValue, this.toString(annotationValue));
    }

    public Value<Short> getShort(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        return new Value<Short>(annotationValue, this.toShort(annotationValue));
    }

    public Value<Integer> getInteger(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        return new Value<Integer>(annotationValue, this.toInteger(annotationValue));
    }

    public Value<List<AnnotationMirror>> getAnnotationValue(String key) {
        AnnotationValue annotationValue = this.values.get(key);
        if (annotationValue == null) {
            throw new IllegalArgumentException(key);
        }
        return new Value<List<AnnotationMirror>>(annotationValue, this.toAnnotationMirror(annotationValue));
    }

    public TypeMirror toTypeMirror(AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<TypeMirror, Void>(){

            @Override
            public TypeMirror visitType(TypeMirror t, Void p) {
                return t;
            }

            @Override
            protected TypeMirror defaultAction(Object o, Void p) {
                return null;
            }
        }, null);
    }

    public String toString(AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            public String visitString(String s, Void p) {
                return s;
            }

            @Override
            protected String defaultAction(Object o, Void p) {
                throw new IllegalArgumentException();
            }
        }, null);
    }

    public short toShort(final AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<Short, Void>(){

            @Override
            public Short visitInt(int i, Void p) {
                return Integer.valueOf(i).shortValue();
            }

            @Override
            public Short visitShort(short s, Void p) {
                return s;
            }

            @Override
            protected Short defaultAction(Object o, Void p) {
                throw new IllegalArgumentException(String.format("Could not convert %s to Short", annotationValue));
            }
        }, null);
    }

    public int toInteger(final AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<Integer, Void>(){

            @Override
            public Integer visitInt(int i, Void p) {
                return i;
            }

            @Override
            public Integer visitShort(short s, Void p) {
                return Short.valueOf(s).intValue();
            }

            @Override
            protected Integer defaultAction(Object o, Void p) {
                throw new IllegalArgumentException(String.format("Could not convert %s to Integer", annotationValue));
            }
        }, null);
    }

    public List<AnnotationMirror> toAnnotationMirror(final AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<List<AnnotationMirror>, Void>(){

            @Override
            public List<AnnotationMirror> visitAnnotation(AnnotationMirror a, Void p) {
                return ImmutableList.of((Object)a);
            }

            @Override
            public List<AnnotationMirror> visitArray(List<? extends AnnotationValue> vals, Void p) {
                ImmutableList.Builder mirrors = ImmutableList.builder();
                for (AnnotationValue annotationValue2 : vals) {
                    mirrors.add((Object)annotationValue2.accept(new SimpleAnnotationValueVisitor8<AnnotationMirror, Void>(){

                        @Override
                        public AnnotationMirror visitAnnotation(AnnotationMirror a, Void p) {
                            return a;
                        }

                        @Override
                        protected AnnotationMirror defaultAction(Object o, Void p) {
                            throw new IllegalArgumentException(String.format("Could not convert %s to AnnotationMirror", annotationValue));
                        }
                    }, null));
                }
                return mirrors.build();
            }

            @Override
            protected List<AnnotationMirror> defaultAction(Object o, Void p) {
                throw new IllegalArgumentException(String.format("Could not convert %s to AnnotationMirror", annotationValue));
            }
        }, null);
    }

    public boolean toBoolean(final AnnotationValue annotationValue) {
        return annotationValue.accept(new SimpleAnnotationValueVisitor8<Boolean, Void>(){

            @Override
            public Boolean visitBoolean(boolean b, Void p) {
                return b;
            }

            @Override
            protected Boolean defaultAction(Object o, Void p) {
                throw new IllegalArgumentException(String.format("Could not convert %s to Boolean", annotationValue));
            }
        }, null);
    }

    @ConstructorProperties(value={"element", "annotation", "values"})
    public AnnotationValues(Element element, AnnotationMirror annotation, Map<String, AnnotationValue> values) {
        this.element = element;
        this.annotation = annotation;
        this.values = values;
    }

    public static class Value<T> {
        private final AnnotationValue annotationValue;
        private final T value;

        public T get() {
            return this.value;
        }

        @ConstructorProperties(value={"annotationValue", "value"})
        public Value(AnnotationValue annotationValue, T value) {
            this.annotationValue = annotationValue;
            this.value = value;
        }

        public AnnotationValue getAnnotationValue() {
            return this.annotationValue;
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AnnotationValue this$annotationValue = this.getAnnotationValue();
            AnnotationValue other$annotationValue = other.getAnnotationValue();
            if (this$annotationValue == null ? other$annotationValue != null : !this$annotationValue.equals(other$annotationValue)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public boolean canEqual(Object other) {
            return other instanceof Value;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AnnotationValue $annotationValue = this.getAnnotationValue();
            result = result * 59 + ($annotationValue == null ? 0 : $annotationValue.hashCode());
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 0 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AnnotationValues.Value(annotationValue=" + this.getAnnotationValue() + ", value=" + this.getValue() + ")";
        }
    }
}

