/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.annotation;

import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AnnotationValues;
import eu.toolchain.serializer.processor.annotation.BuilderMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class AutoSerializeMirror {
    private final AnnotationMirror annotation;
    private final String name;
    private final boolean useGetter;
    private final boolean fieldBased;
    private final boolean failOnMissing;
    private final Optional<BuilderMirror> builder;
    private final boolean orderById;
    private final boolean orderConstructorById;

    public static Unverified<AutoSerializeMirror> getFor(AutoSerializeUtils utils, Element element, AnnotationMirror a) {
        AnnotationValues values = utils.getElementValuesWithDefaults(element, a);
        String name = values.getString("name").get();
        boolean useGetter = values.getBoolean("useGetter").get();
        boolean fieldBased = values.getBoolean("fieldBased").get();
        boolean failOnMissing = values.getBoolean("failOnMissing").get();
        boolean orderById = values.getBoolean("orderById").get();
        boolean orderConstructorById = values.getBoolean("orderConstructorById").get();
        Unverified<Optional<BuilderMirror>> unverifiedBuilder = AutoSerializeMirror.makeBuilder(utils, element, values);
        return unverifiedBuilder.map(builder -> new AutoSerializeMirror(a, name, useGetter, fieldBased, failOnMissing, (Optional<BuilderMirror>)builder, orderById, orderConstructorById));
    }

    private static Unverified<Optional<BuilderMirror>> makeBuilder(AutoSerializeUtils utils, Element element, AnnotationValues values) {
        return utils.builder(element).map(bb -> bb.transform(b -> Unverified.verified(Optional.of(b)))).orElseGet(() -> {
            Iterator<AnnotationMirror> iterator = values.getAnnotationValue("builder").get().iterator();
            if (iterator.hasNext()) {
                AnnotationMirror builderMirror = iterator.next();
                return BuilderMirror.getFor(utils, element, builderMirror).map(b -> Optional.of(b));
            }
            return Unverified.verified(Optional.empty());
        });
    }

    @ConstructorProperties(value={"annotation", "name", "useGetter", "fieldBased", "failOnMissing", "builder", "orderById", "orderConstructorById"})
    public AutoSerializeMirror(AnnotationMirror annotation, String name, boolean useGetter, boolean fieldBased, boolean failOnMissing, Optional<BuilderMirror> builder, boolean orderById, boolean orderConstructorById) {
        this.annotation = annotation;
        this.name = name;
        this.useGetter = useGetter;
        this.fieldBased = fieldBased;
        this.failOnMissing = failOnMissing;
        this.builder = builder;
        this.orderById = orderById;
        this.orderConstructorById = orderConstructorById;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public boolean isUseGetter() {
        return this.useGetter;
    }

    public boolean isFieldBased() {
        return this.fieldBased;
    }

    public boolean isFailOnMissing() {
        return this.failOnMissing;
    }

    public Optional<BuilderMirror> getBuilder() {
        return this.builder;
    }

    public boolean isOrderById() {
        return this.orderById;
    }

    public boolean isOrderConstructorById() {
        return this.orderConstructorById;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoSerializeMirror)) {
            return false;
        }
        AutoSerializeMirror other = (AutoSerializeMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnnotationMirror this$annotation = this.getAnnotation();
        AnnotationMirror other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.isUseGetter() != other.isUseGetter()) {
            return false;
        }
        if (this.isFieldBased() != other.isFieldBased()) {
            return false;
        }
        if (this.isFailOnMissing() != other.isFailOnMissing()) {
            return false;
        }
        Optional<BuilderMirror> this$builder = this.getBuilder();
        Optional<BuilderMirror> other$builder = other.getBuilder();
        if (this$builder == null ? other$builder != null : !((Object)this$builder).equals(other$builder)) {
            return false;
        }
        if (this.isOrderById() != other.isOrderById()) {
            return false;
        }
        return this.isOrderConstructorById() == other.isOrderConstructorById();
    }

    public boolean canEqual(Object other) {
        return other instanceof AutoSerializeMirror;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotationMirror $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 0 : $annotation.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        result = result * 59 + (this.isUseGetter() ? 79 : 97);
        result = result * 59 + (this.isFieldBased() ? 79 : 97);
        result = result * 59 + (this.isFailOnMissing() ? 79 : 97);
        Optional<BuilderMirror> $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 0 : ((Object)$builder).hashCode());
        result = result * 59 + (this.isOrderById() ? 79 : 97);
        result = result * 59 + (this.isOrderConstructorById() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "AutoSerializeMirror(annotation=" + this.getAnnotation() + ", name=" + this.getName() + ", useGetter=" + this.isUseGetter() + ", fieldBased=" + this.isFieldBased() + ", failOnMissing=" + this.isFailOnMissing() + ", builder=" + this.getBuilder() + ", orderById=" + this.isOrderById() + ", orderConstructorById=" + this.isOrderConstructorById() + ")";
    }
}

