/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.annotation;

import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AnnotationValues;
import java.beans.ConstructorProperties;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class FieldMirror {
    private final AnnotationMirror annotation;
    private final String name;
    private final String fieldName;
    private final String accessor;
    private final int id;
    private final int constructorOrder;
    private final boolean useGetter;
    private final boolean provided;
    private final String providerName;

    public static FieldMirror getFor(AutoSerializeUtils utils, Element element, AnnotationMirror a) {
        AnnotationValues values = utils.getElementValuesWithDefaults(element, a);
        String name = values.getString("name").get();
        String fieldName = values.getString("fieldName").get();
        String accessor = values.getString("accessor").get();
        int id = values.getInteger("id").get();
        int constructorOrder = values.getInteger("constructorOrder").get();
        boolean useGetter = values.getBoolean("useGetter").get();
        boolean provided = values.getBoolean("provided").get();
        String providerName = values.getString("providerName").get();
        return new FieldMirror(a, name, fieldName, accessor, id, constructorOrder, useGetter, provided, providerName);
    }

    @ConstructorProperties(value={"annotation", "name", "fieldName", "accessor", "id", "constructorOrder", "useGetter", "provided", "providerName"})
    public FieldMirror(AnnotationMirror annotation, String name, String fieldName, String accessor, int id, int constructorOrder, boolean useGetter, boolean provided, String providerName) {
        this.annotation = annotation;
        this.name = name;
        this.fieldName = fieldName;
        this.accessor = accessor;
        this.id = id;
        this.constructorOrder = constructorOrder;
        this.useGetter = useGetter;
        this.provided = provided;
        this.providerName = providerName;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAccessor() {
        return this.accessor;
    }

    public int getId() {
        return this.id;
    }

    public int getConstructorOrder() {
        return this.constructorOrder;
    }

    public boolean isUseGetter() {
        return this.useGetter;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldMirror)) {
            return false;
        }
        FieldMirror other = (FieldMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnnotationMirror this$annotation = this.getAnnotation();
        AnnotationMirror other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$accessor = this.getAccessor();
        String other$accessor = other.getAccessor();
        if (this$accessor == null ? other$accessor != null : !this$accessor.equals(other$accessor)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getConstructorOrder() != other.getConstructorOrder()) {
            return false;
        }
        if (this.isUseGetter() != other.isUseGetter()) {
            return false;
        }
        if (this.isProvided() != other.isProvided()) {
            return false;
        }
        String this$providerName = this.getProviderName();
        String other$providerName = other.getProviderName();
        return !(this$providerName == null ? other$providerName != null : !this$providerName.equals(other$providerName));
    }

    public boolean canEqual(Object other) {
        return other instanceof FieldMirror;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotationMirror $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 0 : $annotation.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 0 : $fieldName.hashCode());
        String $accessor = this.getAccessor();
        result = result * 59 + ($accessor == null ? 0 : $accessor.hashCode());
        result = result * 59 + this.getId();
        result = result * 59 + this.getConstructorOrder();
        result = result * 59 + (this.isUseGetter() ? 79 : 97);
        result = result * 59 + (this.isProvided() ? 79 : 97);
        String $providerName = this.getProviderName();
        result = result * 59 + ($providerName == null ? 0 : $providerName.hashCode());
        return result;
    }

    public String toString() {
        return "FieldMirror(annotation=" + this.getAnnotation() + ", name=" + this.getName() + ", fieldName=" + this.getFieldName() + ", accessor=" + this.getAccessor() + ", id=" + this.getId() + ", constructorOrder=" + this.getConstructorOrder() + ", useGetter=" + this.isUseGetter() + ", provided=" + this.isProvided() + ", providerName=" + this.getProviderName() + ")";
    }
}

