/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.annotation;

import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AnnotationValues;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class SubTypeMirror {
    private final AnnotationMirror annotation;
    private final AnnotationValues.Value<TypeMirror> value;
    private final Optional<Short> id;

    public static Unverified<SubTypeMirror> getFor(AutoSerializeUtils utils, Element element, AnnotationMirror a) {
        AnnotationValues values = utils.getElementValuesWithDefaults(element, a);
        Unverified<AnnotationValues.Value<TypeMirror>> unverifiedValue = values.getTypeMirror("value");
        Optional<Short> id = Optional.of(values.getShort("id").get()).filter(i -> i >= 0);
        return unverifiedValue.map(value -> new SubTypeMirror(a, (AnnotationValues.Value<TypeMirror>)value, id));
    }

    @ConstructorProperties(value={"annotation", "value", "id"})
    public SubTypeMirror(AnnotationMirror annotation, AnnotationValues.Value<TypeMirror> value, Optional<Short> id) {
        this.annotation = annotation;
        this.value = value;
        this.id = id;
    }

    public AnnotationMirror getAnnotation() {
        return this.annotation;
    }

    public AnnotationValues.Value<TypeMirror> getValue() {
        return this.value;
    }

    public Optional<Short> getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubTypeMirror)) {
            return false;
        }
        SubTypeMirror other = (SubTypeMirror)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AnnotationMirror this$annotation = this.getAnnotation();
        AnnotationMirror other$annotation = other.getAnnotation();
        if (this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation)) {
            return false;
        }
        AnnotationValues.Value<TypeMirror> this$value = this.getValue();
        AnnotationValues.Value<TypeMirror> other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Optional<Short> this$id = this.getId();
        Optional<Short> other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    public boolean canEqual(Object other) {
        return other instanceof SubTypeMirror;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnnotationMirror $annotation = this.getAnnotation();
        result = result * 59 + ($annotation == null ? 0 : $annotation.hashCode());
        AnnotationValues.Value<TypeMirror> $value = this.getValue();
        result = result * 59 + ($value == null ? 0 : ((Object)$value).hashCode());
        Optional<Short> $id = this.getId();
        result = result * 59 + ($id == null ? 0 : ((Object)$id).hashCode());
        return result;
    }

    public String toString() {
        return "SubTypeMirror(annotation=" + this.getAnnotation() + ", value=" + this.getValue() + ", id=" + this.getId() + ")";
    }
}

