/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.value;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.Naming;
import eu.toolchain.serializer.processor.unverified.Unverified;
import eu.toolchain.serializer.processor.value.Value;
import eu.toolchain.serializer.processor.value.ValueSet;
import eu.toolchain.serializer.processor.value.ValueSpecification;
import eu.toolchain.serializer.processor.value.ValueType;
import eu.toolchain.serializer.processor.value.ValueTypeIdentifier;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;

public class ValueSetBuilder {
    final Naming fieldNaming = new Naming("s_");
    final Naming providerNaming = new Naming("p_");
    final Naming variableNaming = new Naming("v_");
    final Naming isSetVariableNaming = new Naming("i_");
    final List<ValueType> types = new ArrayList<ValueType>();
    final List<Unverified<Value>> unverifiedValues = new ArrayList<Unverified<Value>>();
    final AutoSerializeUtils utils;

    public void add(Unverified<ValueSpecification> unverifiedValueSpecification) {
        this.unverifiedValues.add(unverifiedValueSpecification.map(spec -> {
            ValueType type;
            TypeName valueType = TypeName.get((TypeMirror)spec.getValueType());
            TypeName serializerType = TypeName.get((TypeMirror)this.utils.serializerFor(spec.getValueType()));
            ValueTypeIdentifier identifier = new ValueTypeIdentifier(valueType, spec.isProvided(), spec.getProviderName());
            Optional<ValueType> found = this.types.stream().filter(t -> t.getIdentifier().equals(identifier)).findFirst();
            if (found.isPresent()) {
                type = found.get();
            } else {
                Optional<ParameterSpec> providedParameterSpec;
                String typeFieldName = this.fieldNaming.forType(valueType, spec.isProvided());
                FieldSpec fieldSpec = FieldSpec.builder((TypeName)serializerType, (String)typeFieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
                if (spec.isProvided()) {
                    String uniqueProviderName = spec.getProviderName().isPresent() ? this.providerNaming.forName(spec.getProviderName().get()) : this.providerNaming.forType(valueType, false);
                    providedParameterSpec = Optional.of(ParameterSpec.builder((TypeName)serializerType, (String)uniqueProviderName, (Modifier[])new Modifier[]{Modifier.FINAL}).build());
                } else {
                    providedParameterSpec = Optional.empty();
                }
                type = new ValueType(identifier, spec.getValueType(), valueType, fieldSpec, providedParameterSpec, spec.getId(), spec.isOptional());
                this.types.add(type);
            }
            return new Value(type, spec.getValueName(), spec.getAccessor(), this.variableNaming.forName(spec.getValueName()), this.isSetVariableNaming.forName(spec.getValueName()), spec.getId(), spec.getConstructorOrder());
        }));
    }

    public Unverified<ValueSet> build(boolean isOrdereById, boolean isOrderConstructorById) {
        return Unverified.combine(this.unverifiedValues).map(values -> new ValueSet(isOrdereById, isOrderConstructorById, (List<ValueType>)ImmutableList.copyOf(this.types), (List<Value>)ImmutableList.copyOf((Collection)values)));
    }

    @ConstructorProperties(value={"utils"})
    public ValueSetBuilder(AutoSerializeUtils utils) {
        this.utils = utils;
    }
}

