/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.value;

import com.google.common.base.CaseFormat;
import com.squareup.javapoet.TypeName;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.FieldMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class ValueSpecification {
    private final Element element;
    private final TypeMirror valueType;
    private final String valueName;
    private final boolean provided;
    private final boolean optional;
    private final String accessor;
    private final Optional<Integer> constructorOrder;
    private final Optional<Integer> id;
    private final Optional<String> providerName;

    public static Unverified<ValueSpecification> build(AutoSerializeUtils utils, Element parent, Element element, boolean defaultUseGetter) {
        boolean useGetter;
        TypeMirror valueType;
        Optional<FieldMirror> field = utils.field(element);
        if (element instanceof ExecutableElement) {
            ExecutableElement executable = (ExecutableElement)element;
            valueType = executable.getReturnType();
            useGetter = false;
        } else {
            valueType = element.asType();
            useGetter = field.map(FieldMirror::isUseGetter).orElse(defaultUseGetter);
        }
        boolean provided = field.map(FieldMirror::isProvided).orElse(false);
        boolean optional = utils.isOptional(valueType);
        String fieldName = field.map(FieldMirror::getFieldName).filter(n -> !n.trim().isEmpty()).orElse(element.getSimpleName().toString());
        String name = field.map(FieldMirror::getName).filter(n -> !n.trim().isEmpty()).orElse(fieldName);
        String accessor = field.map(FieldMirror::getAccessor).filter(a -> !a.trim().isEmpty()).orElseGet(ValueSpecification.getDefaultAccessor(fieldName, useGetter));
        Optional<String> providerName = field.map(FieldMirror::getProviderName).filter(p -> !p.trim().isEmpty());
        Optional<Integer> constructorOrder = field.map(FieldMirror::getConstructorOrder).filter(o -> o >= 0);
        Optional<Integer> id = field.map(FieldMirror::getId).filter(o -> o >= 0);
        if (!ValueSpecification.accessorMethodExists(parent, accessor, TypeName.get((TypeMirror)valueType))) {
            String message = String.format(String.format("Missing accessor %s %s()", valueType, accessor), new Object[0]);
            return field.map(f -> Unverified.brokenAnnotation(message, element, f.getAnnotation())).orElseGet(() -> Unverified.brokenElement(message, element));
        }
        return Unverified.verified(new ValueSpecification(element, valueType, name, provided, optional, accessor, constructorOrder, id, providerName));
    }

    static boolean accessorMethodExists(Element root, String accessor, TypeName serializedType) {
        for (Element element : root.getEnclosedElements()) {
            ExecutableElement executable;
            if (element.getKind() != ElementKind.METHOD || !(executable = (ExecutableElement)element).getSimpleName().toString().equals(accessor) || !executable.getParameters().isEmpty()) continue;
            TypeName returnType = TypeName.get((TypeMirror)executable.getReturnType());
            return serializedType.equals((Object)returnType);
        }
        return false;
    }

    static Supplier<String> getDefaultAccessor(String fieldName, boolean useGetter) {
        return () -> {
            if (!useGetter) {
                return fieldName;
            }
            return "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
        };
    }

    @ConstructorProperties(value={"element", "valueType", "valueName", "provided", "optional", "accessor", "constructorOrder", "id", "providerName"})
    public ValueSpecification(Element element, TypeMirror valueType, String valueName, boolean provided, boolean optional, String accessor, Optional<Integer> constructorOrder, Optional<Integer> id, Optional<String> providerName) {
        this.element = element;
        this.valueType = valueType;
        this.valueName = valueName;
        this.provided = provided;
        this.optional = optional;
        this.accessor = accessor;
        this.constructorOrder = constructorOrder;
        this.id = id;
        this.providerName = providerName;
    }

    public Element getElement() {
        return this.element;
    }

    public TypeMirror getValueType() {
        return this.valueType;
    }

    public String getValueName() {
        return this.valueName;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getAccessor() {
        return this.accessor;
    }

    public Optional<Integer> getConstructorOrder() {
        return this.constructorOrder;
    }

    public Optional<Integer> getId() {
        return this.id;
    }

    public Optional<String> getProviderName() {
        return this.providerName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueSpecification)) {
            return false;
        }
        ValueSpecification other = (ValueSpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Element this$element = this.getElement();
        Element other$element = other.getElement();
        if (this$element == null ? other$element != null : !((Object)this$element).equals(other$element)) {
            return false;
        }
        TypeMirror this$valueType = this.getValueType();
        TypeMirror other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !((Object)this$valueType).equals(other$valueType)) {
            return false;
        }
        String this$valueName = this.getValueName();
        String other$valueName = other.getValueName();
        if (this$valueName == null ? other$valueName != null : !this$valueName.equals(other$valueName)) {
            return false;
        }
        if (this.isProvided() != other.isProvided()) {
            return false;
        }
        if (this.isOptional() != other.isOptional()) {
            return false;
        }
        String this$accessor = this.getAccessor();
        String other$accessor = other.getAccessor();
        if (this$accessor == null ? other$accessor != null : !this$accessor.equals(other$accessor)) {
            return false;
        }
        Optional<Integer> this$constructorOrder = this.getConstructorOrder();
        Optional<Integer> other$constructorOrder = other.getConstructorOrder();
        if (this$constructorOrder == null ? other$constructorOrder != null : !((Object)this$constructorOrder).equals(other$constructorOrder)) {
            return false;
        }
        Optional<Integer> this$id = this.getId();
        Optional<Integer> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Optional<String> this$providerName = this.getProviderName();
        Optional<String> other$providerName = other.getProviderName();
        return !(this$providerName == null ? other$providerName != null : !((Object)this$providerName).equals(other$providerName));
    }

    public boolean canEqual(Object other) {
        return other instanceof ValueSpecification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Element $element = this.getElement();
        result = result * 59 + ($element == null ? 0 : ((Object)$element).hashCode());
        TypeMirror $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 0 : ((Object)$valueType).hashCode());
        String $valueName = this.getValueName();
        result = result * 59 + ($valueName == null ? 0 : $valueName.hashCode());
        result = result * 59 + (this.isProvided() ? 79 : 97);
        result = result * 59 + (this.isOptional() ? 79 : 97);
        String $accessor = this.getAccessor();
        result = result * 59 + ($accessor == null ? 0 : $accessor.hashCode());
        Optional<Integer> $constructorOrder = this.getConstructorOrder();
        result = result * 59 + ($constructorOrder == null ? 0 : ((Object)$constructorOrder).hashCode());
        Optional<Integer> $id = this.getId();
        result = result * 59 + ($id == null ? 0 : ((Object)$id).hashCode());
        Optional<String> $providerName = this.getProviderName();
        result = result * 59 + ($providerName == null ? 0 : ((Object)$providerName).hashCode());
        return result;
    }

    public String toString() {
        return "ValueSpecification(element=" + this.getElement() + ", valueType=" + this.getValueType() + ", valueName=" + this.getValueName() + ", provided=" + this.isProvided() + ", optional=" + this.isOptional() + ", accessor=" + this.getAccessor() + ", constructorOrder=" + this.getConstructorOrder() + ", id=" + this.getId() + ", providerName=" + this.getProviderName() + ")";
    }
}

