/*
 * Decompiled with CFR 0.152.
 */
package eu.toolchain.serializer.processor.value;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import eu.toolchain.serializer.processor.AutoSerializeUtils;
import eu.toolchain.serializer.processor.annotation.AutoSerializeMirror;
import eu.toolchain.serializer.processor.annotation.BuilderMirror;
import eu.toolchain.serializer.processor.unverified.Unverified;
import eu.toolchain.serializer.processor.value.Value;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class ValueTypeBuilder {
    static final Joiner emptyJoiner = Joiner.on((String)"");
    final BuilderMirror builder;
    final boolean useConstructor;
    final boolean useSetter;
    final String method;

    public static Unverified<Optional<ValueTypeBuilder>> build(AutoSerializeUtils utils, TypeElement element, AutoSerializeMirror autoSerialize) {
        return utils.builder(element).map(unverifiedDirect -> unverifiedDirect.map(direct -> Optional.of(ValueTypeBuilder.build(direct, element, utils)))).orElseGet(() -> Unverified.verified(autoSerialize.getBuilder().map(nested -> Optional.of(ValueTypeBuilder.build(nested, element, utils))).orElse(Optional.empty())));
    }

    static ValueTypeBuilder build(BuilderMirror builder, TypeElement element, AutoSerializeUtils utils) {
        boolean useConstructor = builder.shouldUseConstructor();
        return new ValueTypeBuilder(builder, useConstructor, builder.isUseSetter(), builder.getMethodName());
    }

    public void writeTo(ClassName returnType, MethodSpec.Builder b, List<Value> variables) {
        String builderStatement;
        TypeName builderType;
        ImmutableList.Builder builders = ImmutableList.builder();
        ImmutableList.Builder parameters = ImmutableList.builder();
        if (this.useConstructor) {
            builderType = this.getBuilderTypeForConstructor(returnType);
            builderStatement = "new $T()";
        } else {
            builderType = this.getBuilderTypeForMethod(returnType);
            builderStatement = String.format("$T.%s()", this.method);
        }
        parameters.add((Object)builderType);
        for (Value f : variables) {
            builders.add((Object)String.format(".%s($L)", this.builderSetter(f)));
            parameters.add((Object)f.getVariableName());
        }
        b.addStatement(String.format("return %s%s.build()", builderStatement, emptyJoiner.join((Iterable)builders.build())), parameters.build().toArray());
    }

    TypeName getBuilderTypeForConstructor(ClassName returnType) {
        return this.builder.getType().map(t -> TypeName.get((TypeMirror)((TypeMirror)t.get()))).orElse((TypeName)returnType.nestedClass("Builder"));
    }

    TypeName getBuilderTypeForMethod(ClassName returnType) {
        return this.builder.getType().map(t -> TypeName.get((TypeMirror)((TypeMirror)t.get()))).orElse((TypeName)returnType);
    }

    String builderSetter(Value f) {
        if (this.useSetter) {
            return "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, f.getName());
        }
        return f.getName();
    }

    @ConstructorProperties(value={"builder", "useConstructor", "useSetter", "method"})
    public ValueTypeBuilder(BuilderMirror builder, boolean useConstructor, boolean useSetter, String method) {
        this.builder = builder;
        this.useConstructor = useConstructor;
        this.useSetter = useSetter;
        this.method = method;
    }

    public BuilderMirror getBuilder() {
        return this.builder;
    }

    public boolean isUseConstructor() {
        return this.useConstructor;
    }

    public boolean isUseSetter() {
        return this.useSetter;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValueTypeBuilder)) {
            return false;
        }
        ValueTypeBuilder other = (ValueTypeBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BuilderMirror this$builder = this.getBuilder();
        BuilderMirror other$builder = other.getBuilder();
        if (this$builder == null ? other$builder != null : !((Object)this$builder).equals(other$builder)) {
            return false;
        }
        if (this.isUseConstructor() != other.isUseConstructor()) {
            return false;
        }
        if (this.isUseSetter() != other.isUseSetter()) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !this$method.equals(other$method));
    }

    public boolean canEqual(Object other) {
        return other instanceof ValueTypeBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BuilderMirror $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 0 : ((Object)$builder).hashCode());
        result = result * 59 + (this.isUseConstructor() ? 79 : 97);
        result = result * 59 + (this.isUseSetter() ? 79 : 97);
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 0 : $method.hashCode());
        return result;
    }

    public String toString() {
        return "ValueTypeBuilder(builder=" + this.getBuilder() + ", useConstructor=" + this.isUseConstructor() + ", useSetter=" + this.isUseSetter() + ", method=" + this.getMethod() + ")";
    }
}

