/*
 * Decompiled with CFR 0.152.
 */
package com.helger.bdve.api;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.id.IHasID;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EValidationType implements IHasID<String>,
IHasName
{
    XML("xml", "XML Syntax"),
    XSD("xsd", "XML Schema"),
    PARTIAL_XSD("partial-xsd", "Partial XML Schema"),
    SCHEMATRON_PURE("schematron-pure", "Schematron (XPath)"),
    SCHEMATRON_SCH("schematron-sch", "Schematron (SCH)"),
    SCHEMATRON_XSLT("schematron-xslt", "Schematron (XSLT)"),
    SCHEMATRON_OIOUBL("schematron-xslt-oioubl", "Schematron (XSLT) [OIOUBL]");

    private final String m_sID;
    private final String m_sName;

    private EValidationType(String string2, String string3) {
        this.m_sID = string2;
        this.m_sName = string3;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    public boolean isXML() {
        return this == XML;
    }

    public boolean isXSD() {
        return this == XSD || this == PARTIAL_XSD;
    }

    public boolean isSchematron() {
        return this == SCHEMATRON_PURE || this == SCHEMATRON_SCH || this == SCHEMATRON_XSLT || this == SCHEMATRON_OIOUBL;
    }

    public boolean isStopValidationOnError() {
        return this.isXML() || this.isXSD();
    }

    public boolean isContextRequired() {
        return this == PARTIAL_XSD;
    }

    @Nullable
    public static EValidationType getFromIDOrNull(@Nullable String string) {
        return EnumHelper.getFromIDOrNull(EValidationType.class, string);
    }
}

